<?php

namespace EnumType;

/**
 * This class stands for nutzungType EnumType
 * @subpackage Enumerations
 */
class NutzungType
{
    /**
     * Constant for value 'Privat'
     * @return string 'Privat'
     */
    const VALUE_PRIVAT = 'Privat';
    /**
     * Constant for value 'Privat u. Beruf'
     * @return string 'Privat u. Beruf'
     */
    const VALUE_PRIVAT_U_BERUF = 'Privat u. Beruf';
    /**
     * Constant for value 'Beruf'
     * @return string 'Beruf'
     */
    const VALUE_BERUF = 'Beruf';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRIVAT
     * @uses self::VALUE_PRIVAT_U_BERUF
     * @uses self::VALUE_BERUF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRIVAT,
            self::VALUE_PRIVAT_U_BERUF,
            self::VALUE_BERUF,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
