<?php

namespace EnumType;

/**
 * This class stands for nebengebaeudeType EnumType
 * @subpackage Enumerations
 */
class NebengebaeudeType
{
    /**
     * Constant for value 'Abstellgebäude'
     * @return string 'Abstellgebäude'
     */
    const VALUE_ABSTELLGEB_ÄUDE = 'Abstellgebäude';
    /**
     * Constant for value 'Badehütte'
     * @return string 'Badehütte'
     */
    const VALUE_BADEH_ÜTTE = 'Badehütte';
    /**
     * Constant for value 'Bootshaus'
     * @return string 'Bootshaus'
     */
    const VALUE_BOOTSHAUS = 'Bootshaus';
    /**
     * Constant for value 'Carport'
     * @return string 'Carport'
     */
    const VALUE_CARPORT = 'Carport';
    /**
     * Constant for value 'ehemaliges Wirtschaftsgebäude'
     * @return string 'ehemaliges Wirtschaftsgebäude'
     */
    const VALUE_EHEMALIGES_WIRTSCHAFTSGEB_ÄUDE = 'ehemaliges Wirtschaftsgebäude';
    /**
     * Constant for value 'Garage'
     * @return string 'Garage'
     */
    const VALUE_GARAGE = 'Garage';
    /**
     * Constant for value 'Gartenhaus (nicht für Wohnzwecke)'
     * @return string 'Gartenhaus (nicht für Wohnzwecke)'
     */
    const VALUE_GARTENHAUS_NICHT_F_ÜR_WOHNZWECKE = 'Gartenhaus (nicht für Wohnzwecke)';
    /**
     * Constant for value 'Holzhütte'
     * @return string 'Holzhütte'
     */
    const VALUE_HOLZH_ÜTTE = 'Holzhütte';
    /**
     * Constant for value 'Keller'
     * @return string 'Keller'
     */
    const VALUE_KELLER = 'Keller';
    /**
     * Constant for value 'Mobilheim (stationär)'
     * @return string 'Mobilheim (stationär)'
     */
    const VALUE_MOBILHEIM_STATION_ÄR = 'Mobilheim (stationär)';
    /**
     * Constant for value 'Nebengebäude'
     * @return string 'Nebengebäude'
     */
    const VALUE_NEBENGEB_ÄUDE = 'Nebengebäude';
    /**
     * Constant for value 'Nebengebäude mit Garage'
     * @return string 'Nebengebäude mit Garage'
     */
    const VALUE_NEBENGEB_ÄUDE_MIT_GARAGE = 'Nebengebäude mit Garage';
    /**
     * Constant for value 'Presshaus'
     * @return string 'Presshaus'
     */
    const VALUE_PRESSHAUS = 'Presshaus';
    /**
     * Constant for value 'Sauna'
     * @return string 'Sauna'
     */
    const VALUE_SAUNA = 'Sauna';
    /**
     * Constant for value 'Scheune / Schuppen / Stadel'
     * @return string 'Scheune / Schuppen / Stadel'
     */
    const VALUE_SCHEUNE_SCHUPPEN_STADEL = 'Scheune / Schuppen / Stadel';
    /**
     * Constant for value 'Werkstätte'
     * @return string 'Werkstätte'
     */
    const VALUE_WERKST_ÄTTE = 'Werkstätte';
    /**
     * Constant for value 'Werkzeug- und Geräteschuppen'
     * @return string 'Werkzeug- und Geräteschuppen'
     */
    const VALUE_WERKZEUG_UND_GER_ÄTESCHUPPEN = 'Werkzeug- und Geräteschuppen';
    /**
     * Constant for value 'Wintergarten, Veranda'
     * @return string 'Wintergarten, Veranda'
     */
    const VALUE_WINTERGARTEN_VERANDA = 'Wintergarten, Veranda';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ABSTELLGEB_ÄUDE
     * @uses self::VALUE_BADEH_ÜTTE
     * @uses self::VALUE_BOOTSHAUS
     * @uses self::VALUE_CARPORT
     * @uses self::VALUE_EHEMALIGES_WIRTSCHAFTSGEB_ÄUDE
     * @uses self::VALUE_GARAGE
     * @uses self::VALUE_GARTENHAUS_NICHT_F_ÜR_WOHNZWECKE
     * @uses self::VALUE_HOLZH_ÜTTE
     * @uses self::VALUE_KELLER
     * @uses self::VALUE_MOBILHEIM_STATION_ÄR
     * @uses self::VALUE_NEBENGEB_ÄUDE
     * @uses self::VALUE_NEBENGEB_ÄUDE_MIT_GARAGE
     * @uses self::VALUE_PRESSHAUS
     * @uses self::VALUE_SAUNA
     * @uses self::VALUE_SCHEUNE_SCHUPPEN_STADEL
     * @uses self::VALUE_WERKST_ÄTTE
     * @uses self::VALUE_WERKZEUG_UND_GER_ÄTESCHUPPEN
     * @uses self::VALUE_WINTERGARTEN_VERANDA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ABSTELLGEB_ÄUDE,
            self::VALUE_BADEH_ÜTTE,
            self::VALUE_BOOTSHAUS,
            self::VALUE_CARPORT,
            self::VALUE_EHEMALIGES_WIRTSCHAFTSGEB_ÄUDE,
            self::VALUE_GARAGE,
            self::VALUE_GARTENHAUS_NICHT_F_ÜR_WOHNZWECKE,
            self::VALUE_HOLZH_ÜTTE,
            self::VALUE_KELLER,
            self::VALUE_MOBILHEIM_STATION_ÄR,
            self::VALUE_NEBENGEB_ÄUDE,
            self::VALUE_NEBENGEB_ÄUDE_MIT_GARAGE,
            self::VALUE_PRESSHAUS,
            self::VALUE_SAUNA,
            self::VALUE_SCHEUNE_SCHUPPEN_STADEL,
            self::VALUE_WERKST_ÄTTE,
            self::VALUE_WERKZEUG_UND_GER_ÄTESCHUPPEN,
            self::VALUE_WINTERGARTEN_VERANDA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
