<?php

namespace EnumType;

/**
 * This class stands for MessageType EnumType
 * @subpackage Enumerations
 */
class MessageType
{
    /**
     * Constant for value 'Eingang'
     * Meta information extracted from the WSDL
     * - id: Eingang
     * @return string 'Eingang'
     */
    const VALUE_EINGANG = 'Eingang';
    /**
     * Constant for value 'Archiv'
     * Meta information extracted from the WSDL
     * - id: Archiv
     * @return string 'Archiv'
     */
    const VALUE_ARCHIV = 'Archiv';
    /**
     * Constant for value 'PersArchiv'
     * Meta information extracted from the WSDL
     * - id: PersArchiv
     * @return string 'PersArchiv'
     */
    const VALUE_PERS_ARCHIV = 'PersArchiv';
    /**
     * Constant for value 'Ausgang'
     * Meta information extracted from the WSDL
     * - id: Ausgang
     * @return string 'Ausgang'
     */
    const VALUE_AUSGANG = 'Ausgang';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EINGANG
     * @uses self::VALUE_ARCHIV
     * @uses self::VALUE_PERS_ARCHIV
     * @uses self::VALUE_AUSGANG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EINGANG,
            self::VALUE_ARCHIV,
            self::VALUE_PERS_ARCHIV,
            self::VALUE_AUSGANG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
