<?php

namespace EnumType;

/**
 * This class stands for kfzVerwendungType EnumType
 * @subpackage Enumerations
 */
class KfzVerwendungType
{
    /**
     * Constant for value 'ohne'
     * @return string 'ohne'
     */
    const VALUE_OHNE = 'ohne';
    /**
     * Constant for value 'Abschleppwagen'
     * @return string 'Abschleppwagen'
     */
    const VALUE_ABSCHLEPPWAGEN = 'Abschleppwagen';
    /**
     * Constant for value 'Feuerwehrwagen oder Bergrettungsdienst'
     * @return string 'Feuerwehrwagen oder Bergrettungsdienst'
     */
    const VALUE_FEUERWEHRWAGEN_ODER_BERGRETTUNGSDIENST = 'Feuerwehrwagen oder Bergrettungsdienst';
    /**
     * Constant for value 'Rettungsdienst- und Krankenwagen'
     * @return string 'Rettungsdienst- und Krankenwagen'
     */
    const VALUE_RETTUNGSDIENST_UND_KRANKENWAGEN = 'Rettungsdienst- und Krankenwagen';
    /**
     * Constant for value 'Leichenwagen'
     * @return string 'Leichenwagen'
     */
    const VALUE_LEICHENWAGEN = 'Leichenwagen';
    /**
     * Constant for value 'Straßendienst'
     * @return string 'Straßendienst'
     */
    const VALUE_STRA_ßENDIENST = 'Straßendienst';
    /**
     * Constant for value 'Schulfahrzeuge'
     * @return string 'Schulfahrzeuge'
     */
    const VALUE_SCHULFAHRZEUGE = 'Schulfahrzeuge';
    /**
     * Constant for value 'Mannschaftstransportwagen'
     * @return string 'Mannschaftstransportwagen'
     */
    const VALUE_MANNSCHAFTSTRANSPORTWAGEN = 'Mannschaftstransportwagen';
    /**
     * Constant for value 'Müllabfuhr'
     * @return string 'Müllabfuhr'
     */
    const VALUE_M_ÜLLABFUHR = 'Müllabfuhr';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OHNE
     * @uses self::VALUE_ABSCHLEPPWAGEN
     * @uses self::VALUE_FEUERWEHRWAGEN_ODER_BERGRETTUNGSDIENST
     * @uses self::VALUE_RETTUNGSDIENST_UND_KRANKENWAGEN
     * @uses self::VALUE_LEICHENWAGEN
     * @uses self::VALUE_STRA_ßENDIENST
     * @uses self::VALUE_SCHULFAHRZEUGE
     * @uses self::VALUE_MANNSCHAFTSTRANSPORTWAGEN
     * @uses self::VALUE_M_ÜLLABFUHR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OHNE,
            self::VALUE_ABSCHLEPPWAGEN,
            self::VALUE_FEUERWEHRWAGEN_ODER_BERGRETTUNGSDIENST,
            self::VALUE_RETTUNGSDIENST_UND_KRANKENWAGEN,
            self::VALUE_LEICHENWAGEN,
            self::VALUE_STRA_ßENDIENST,
            self::VALUE_SCHULFAHRZEUGE,
            self::VALUE_MANNSCHAFTSTRANSPORTWAGEN,
            self::VALUE_M_ÜLLABFUHR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
