<?php

namespace EnumType;

/**
 * This class stands for kfzArtType EnumType
 * @subpackage Enumerations
 */
class KfzArtType
{
    /**
     * Constant for value 'PKW'
     * @return string 'PKW'
     */
    const VALUE_PKW = 'PKW';
    /**
     * Constant for value 'LKW'
     * @return string 'LKW'
     */
    const VALUE_LKW = 'LKW';
    /**
     * Constant for value 'Invalidenkraftfahrzeug'
     * @return string 'Invalidenkraftfahrzeug'
     */
    const VALUE_INVALIDENKRAFTFAHRZEUG = 'Invalidenkraftfahrzeug';
    /**
     * Constant for value 'Kradanhänger'
     * @return string 'Kradanhänger'
     */
    const VALUE_KRADANH_ÄNGER = 'Kradanhänger';
    /**
     * Constant for value 'Motordreirad'
     * @return string 'Motordreirad'
     */
    const VALUE_MOTORDREIRAD = 'Motordreirad';
    /**
     * Constant for value 'einsp.Kleinkraftrad (Motorfahrrad)'
     * @return string 'einsp.Kleinkraftrad (Motorfahrrad)'
     */
    const VALUE_EINSP_KLEINKRAFTRAD_MOTORFAHRRAD = 'einsp.Kleinkraftrad (Motorfahrrad)';
    /**
     * Constant for value 'Motorkarren'
     * @return string 'Motorkarren'
     */
    const VALUE_MOTORKARREN = 'Motorkarren';
    /**
     * Constant for value 'Motorrad'
     * @return string 'Motorrad'
     */
    const VALUE_MOTORRAD = 'Motorrad';
    /**
     * Constant for value 'Motorrad mit Beiwagen'
     * @return string 'Motorrad mit Beiwagen'
     */
    const VALUE_MOTORRAD_MIT_BEIWAGEN = 'Motorrad mit Beiwagen';
    /**
     * Constant for value 'Omnibus'
     * @return string 'Omnibus'
     */
    const VALUE_OMNIBUS = 'Omnibus';
    /**
     * Constant for value 'leichter Anhänger'
     * @return string 'leichter Anhänger'
     */
    const VALUE_LEICHTER_ANH_ÄNGER = 'leichter Anhänger';
    /**
     * Constant for value 'selbstfahrende Arbeitsmaschine'
     * @return string 'selbstfahrende Arbeitsmaschine'
     */
    const VALUE_SELBSTFAHRENDE_ARBEITSMASCHINE = 'selbstfahrende Arbeitsmaschine';
    /**
     * Constant for value 'Sonderkfz mit Gleisketten'
     * @return string 'Sonderkfz mit Gleisketten'
     */
    const VALUE_SONDERKFZ_MIT_GLEISKETTEN = 'Sonderkfz mit Gleisketten';
    /**
     * Constant for value 'schwerer Anhänger'
     * @return string 'schwerer Anhänger'
     */
    const VALUE_SCHWERER_ANH_ÄNGER = 'schwerer Anhänger';
    /**
     * Constant for value 'Transportkarren'
     * @return string 'Transportkarren'
     */
    const VALUE_TRANSPORTKARREN = 'Transportkarren';
    /**
     * Constant for value 'Wohnmobil'
     * @return string 'Wohnmobil'
     */
    const VALUE_WOHNMOBIL = 'Wohnmobil';
    /**
     * Constant for value 'Wohnwagenanhänger'
     * @return string 'Wohnwagenanhänger'
     */
    const VALUE_WOHNWAGENANH_ÄNGER = 'Wohnwagenanhänger';
    /**
     * Constant for value 'Zugmaschine'
     * @return string 'Zugmaschine'
     */
    const VALUE_ZUGMASCHINE = 'Zugmaschine';
    /**
     * Constant for value 'E-Bike'
     * @return string 'E-Bike'
     */
    const VALUE_E_BIKE = 'E-Bike';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PKW
     * @uses self::VALUE_LKW
     * @uses self::VALUE_INVALIDENKRAFTFAHRZEUG
     * @uses self::VALUE_KRADANH_ÄNGER
     * @uses self::VALUE_MOTORDREIRAD
     * @uses self::VALUE_EINSP_KLEINKRAFTRAD_MOTORFAHRRAD
     * @uses self::VALUE_MOTORKARREN
     * @uses self::VALUE_MOTORRAD
     * @uses self::VALUE_MOTORRAD_MIT_BEIWAGEN
     * @uses self::VALUE_OMNIBUS
     * @uses self::VALUE_LEICHTER_ANH_ÄNGER
     * @uses self::VALUE_SELBSTFAHRENDE_ARBEITSMASCHINE
     * @uses self::VALUE_SONDERKFZ_MIT_GLEISKETTEN
     * @uses self::VALUE_SCHWERER_ANH_ÄNGER
     * @uses self::VALUE_TRANSPORTKARREN
     * @uses self::VALUE_WOHNMOBIL
     * @uses self::VALUE_WOHNWAGENANH_ÄNGER
     * @uses self::VALUE_ZUGMASCHINE
     * @uses self::VALUE_E_BIKE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PKW,
            self::VALUE_LKW,
            self::VALUE_INVALIDENKRAFTFAHRZEUG,
            self::VALUE_KRADANH_ÄNGER,
            self::VALUE_MOTORDREIRAD,
            self::VALUE_EINSP_KLEINKRAFTRAD_MOTORFAHRRAD,
            self::VALUE_MOTORKARREN,
            self::VALUE_MOTORRAD,
            self::VALUE_MOTORRAD_MIT_BEIWAGEN,
            self::VALUE_OMNIBUS,
            self::VALUE_LEICHTER_ANH_ÄNGER,
            self::VALUE_SELBSTFAHRENDE_ARBEITSMASCHINE,
            self::VALUE_SONDERKFZ_MIT_GLEISKETTEN,
            self::VALUE_SCHWERER_ANH_ÄNGER,
            self::VALUE_TRANSPORTKARREN,
            self::VALUE_WOHNMOBIL,
            self::VALUE_WOHNWAGENANH_ÄNGER,
            self::VALUE_ZUGMASCHINE,
            self::VALUE_E_BIKE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
