<?php

namespace EnumType;

/**
 * This class stands for kaskoVersicherungsartType EnumType
 * @subpackage Enumerations
 */
class KaskoVersicherungsartType
{
    /**
     * Constant for value 'Vollkasko'
     * @return string 'Vollkasko'
     */
    const VALUE_VOLLKASKO = 'Vollkasko';
    /**
     * Constant for value 'Vollkasko mit gen. SB'
     * @return string 'Vollkasko mit gen. SB'
     */
    const VALUE_VOLLKASKO_MIT_GEN_SB = 'Vollkasko mit gen. SB';
    /**
     * Constant for value 'Teilkasko'
     * @return string 'Teilkasko'
     */
    const VALUE_TEILKASKO = 'Teilkasko';
    /**
     * Constant for value 'Teilkasko mit gen. SB'
     * @return string 'Teilkasko mit gen. SB'
     */
    const VALUE_TEILKASKO_MIT_GEN_SB = 'Teilkasko mit gen. SB';
    /**
     * Constant for value 'Parkschadenkasko'
     * @return string 'Parkschadenkasko'
     */
    const VALUE_PARKSCHADENKASKO = 'Parkschadenkasko';
    /**
     * Constant for value 'Parkschadenkasko mit gen. SB'
     * @return string 'Parkschadenkasko mit gen. SB'
     */
    const VALUE_PARKSCHADENKASKO_MIT_GEN_SB = 'Parkschadenkasko mit gen. SB';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VOLLKASKO
     * @uses self::VALUE_VOLLKASKO_MIT_GEN_SB
     * @uses self::VALUE_TEILKASKO
     * @uses self::VALUE_TEILKASKO_MIT_GEN_SB
     * @uses self::VALUE_PARKSCHADENKASKO
     * @uses self::VALUE_PARKSCHADENKASKO_MIT_GEN_SB
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VOLLKASKO,
            self::VALUE_VOLLKASKO_MIT_GEN_SB,
            self::VALUE_TEILKASKO,
            self::VALUE_TEILKASKO_MIT_GEN_SB,
            self::VALUE_PARKSCHADENKASKO,
            self::VALUE_PARKSCHADENKASKO_MIT_GEN_SB,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
