<?php

namespace EnumType;

/**
 * This class stands for iuVersicherungsartType EnumType
 * @subpackage Enumerations
 */
class IuVersicherungsartType
{
    /**
     * Constant for value 'Kfz-Insassenschutz'
     * @return string 'Kfz-Insassenschutz'
     */
    const VALUE_KFZ_INSASSENSCHUTZ = 'Kfz-Insassenschutz';
    /**
     * Constant for value 'Kfz-Top-Insassenschutz'
     * @return string 'Kfz-Top-Insassenschutz'
     */
    const VALUE_KFZ_TOP_INSASSENSCHUTZ = 'Kfz-Top-Insassenschutz';
    /**
     * Constant for value 'Platzsystem'
     * @return string 'Platzsystem'
     */
    const VALUE_PLATZSYSTEM = 'Platzsystem';
    /**
     * Constant for value 'Pauschalsystem'
     * @return string 'Pauschalsystem'
     */
    const VALUE_PAUSCHALSYSTEM = 'Pauschalsystem';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KFZ_INSASSENSCHUTZ
     * @uses self::VALUE_KFZ_TOP_INSASSENSCHUTZ
     * @uses self::VALUE_PLATZSYSTEM
     * @uses self::VALUE_PAUSCHALSYSTEM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KFZ_INSASSENSCHUTZ,
            self::VALUE_KFZ_TOP_INSASSENSCHUTZ,
            self::VALUE_PLATZSYSTEM,
            self::VALUE_PAUSCHALSYSTEM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
