<?php

namespace EnumType;

/**
 * This class stands for injuredBodyPart EnumType
 * @subpackage Enumerations
 */
class InjuredBodyPart
{
    /**
     * Constant for value 'Arm (einer) bis oberhalb Ellenbogen'
     * @return string 'Arm (einer) bis oberhalb Ellenbogen'
     */
    const VALUE_ARM_EINER_BIS_OBERHALB_ELLENBOGEN = 'Arm (einer) bis oberhalb Ellenbogen';
    /**
     * Constant for value 'Arm (einer) inkl. Schultergelenk'
     * @return string 'Arm (einer) inkl. Schultergelenk'
     */
    const VALUE_ARM_EINER_INKL_SCHULTERGELENK = 'Arm (einer) inkl. Schultergelenk';
    /**
     * Constant for value 'Arm (einer) inkl.Ellenbogen'
     * @return string 'Arm (einer) inkl.Ellenbogen'
     */
    const VALUE_ARM_EINER_INKL_ELLENBOGEN = 'Arm (einer) inkl.Ellenbogen';
    /**
     * Constant for value 'Auge (eines)'
     * @return string 'Auge (eines)'
     */
    const VALUE_AUGE_EINES = 'Auge (eines)';
    /**
     * Constant for value 'Augen (beide)'
     * @return string 'Augen (beide)'
     */
    const VALUE_AUGEN_BEIDE = 'Augen (beide)';
    /**
     * Constant for value 'Becken'
     * @return string 'Becken'
     */
    const VALUE_BECKEN = 'Becken';
    /**
     * Constant for value 'Bein (eines) bis Mitte Oberschenkel'
     * @return string 'Bein (eines) bis Mitte Oberschenkel'
     */
    const VALUE_BEIN_EINES_BIS_MITTE_OBERSCHENKEL = 'Bein (eines) bis Mitte Oberschenkel';
    /**
     * Constant for value 'Bein (eines) bis Mitte Unterschenkel'
     * @return string 'Bein (eines) bis Mitte Unterschenkel'
     */
    const VALUE_BEIN_EINES_BIS_MITTE_UNTERSCHENKEL = 'Bein (eines) bis Mitte Unterschenkel';
    /**
     * Constant for value 'Bein (eines) bis unterhalb Knie'
     * @return string 'Bein (eines) bis unterhalb Knie'
     */
    const VALUE_BEIN_EINES_BIS_UNTERHALB_KNIE = 'Bein (eines) bis unterhalb Knie';
    /**
     * Constant for value 'Bein (eines) bis zur Hüfte'
     * @return string 'Bein (eines) bis zur Hüfte'
     */
    const VALUE_BEIN_EINES_BIS_ZUR_H_ÜFTE = 'Bein (eines) bis zur Hüfte';
    /**
     * Constant for value 'Beine/Füße (beide)'
     * @return string 'Beine/Füße (beide)'
     */
    const VALUE_BEINE_F_ÜßE_BEIDE = 'Beine/Füße (beide)';
    /**
     * Constant for value 'Brust (weibl.)'
     * @return string 'Brust (weibl.)'
     */
    const VALUE_BRUST_WEIBL = 'Brust (weibl.)';
    /**
     * Constant for value 'Brustkorb/Bauch'
     * @return string 'Brustkorb/Bauch'
     */
    const VALUE_BRUSTKORB_BAUCH = 'Brustkorb/Bauch';
    /**
     * Constant for value 'Endglied Daumen'
     * @return string 'Endglied Daumen'
     */
    const VALUE_ENDGLIED_DAUMEN = 'Endglied Daumen';
    /**
     * Constant for value 'Endglied Mittelfinger'
     * @return string 'Endglied Mittelfinger'
     */
    const VALUE_ENDGLIED_MITTELFINGER = 'Endglied Mittelfinger';
    /**
     * Constant for value 'Endglied Zeigefinger'
     * @return string 'Endglied Zeigefinger'
     */
    const VALUE_ENDGLIED_ZEIGEFINGER = 'Endglied Zeigefinger';
    /**
     * Constant for value 'Ertrinken/Ersticken/Verbrennen'
     * @return string 'Ertrinken/Ersticken/Verbrennen'
     */
    const VALUE_ERTRINKEN_ERSTICKEN_VERBRENNEN = 'Ertrinken/Ersticken/Verbrennen';
    /**
     * Constant for value 'Finger (Daumen)'
     * @return string 'Finger (Daumen)'
     */
    const VALUE_FINGER_DAUMEN = 'Finger (Daumen)';
    /**
     * Constant for value 'Finger (mehrere)'
     * @return string 'Finger (mehrere)'
     */
    const VALUE_FINGER_MEHRERE = 'Finger (mehrere)';
    /**
     * Constant for value 'Finger (Mittelfinger)'
     * @return string 'Finger (Mittelfinger)'
     */
    const VALUE_FINGER_MITTELFINGER = 'Finger (Mittelfinger)';
    /**
     * Constant for value 'Finger (Ring/Kleinfinger)'
     * @return string 'Finger (Ring/Kleinfinger)'
     */
    const VALUE_FINGER_RING_KLEINFINGER = 'Finger (Ring/Kleinfinger)';
    /**
     * Constant for value 'Finger (Zeigefinger)'
     * @return string 'Finger (Zeigefinger)'
     */
    const VALUE_FINGER_ZEIGEFINGER = 'Finger (Zeigefinger)';
    /**
     * Constant for value 'Geruch'
     * @return string 'Geruch'
     */
    const VALUE_GERUCH = 'Geruch';
    /**
     * Constant for value 'Geschlechtsorgan (männl.)'
     * @return string 'Geschlechtsorgan (männl.)'
     */
    const VALUE_GESCHLECHTSORGAN_M_ÄNNL = 'Geschlechtsorgan (männl.)';
    /**
     * Constant for value 'Geschmack'
     * @return string 'Geschmack'
     */
    const VALUE_GESCHMACK = 'Geschmack';
    /**
     * Constant for value 'Gliedmaßen (untere und obere)'
     * @return string 'Gliedmaßen (untere und obere)'
     */
    const VALUE_GLIEDMA_ßEN_UNTERE_UND_OBERE = 'Gliedmaßen (untere und obere)';
    /**
     * Constant for value 'Gliedmaßen u.Rumpf'
     * @return string 'Gliedmaßen u.Rumpf'
     */
    const VALUE_GLIEDMA_ßEN_U_RUMPF = 'Gliedmaßen u.Rumpf';
    /**
     * Constant for value 'Gliedmaßen und Kopf/Hals'
     * @return string 'Gliedmaßen und Kopf/Hals'
     */
    const VALUE_GLIEDMA_ßEN_UND_KOPF_HALS = 'Gliedmaßen und Kopf/Hals';
    /**
     * Constant for value 'Hände/Arme (beide)'
     * @return string 'Hände/Arme (beide)'
     */
    const VALUE_H_ÄNDE_ARME_BEIDE = 'Hände/Arme (beide)';
    /**
     * Constant for value 'Hand (eine)'
     * @return string 'Hand (eine)'
     */
    const VALUE_HAND_EINE = 'Hand (eine)';
    /**
     * Constant for value 'innere Organe (sonstige)'
     * @return string 'innere Organe (sonstige)'
     */
    const VALUE_INNERE_ORGANE_SONSTIGE = 'innere Organe (sonstige)';
    /**
     * Constant for value 'innere Organe und andere Körperteile'
     * @return string 'innere Organe und andere Körperteile'
     */
    const VALUE_INNERE_ORGANE_UND_ANDERE_K_ÖRPERTEILE = 'innere Organe und andere Körperteile';
    /**
     * Constant for value 'Körperteile (mehrere)'
     * @return string 'Körperteile (mehrere)'
     */
    const VALUE_K_ÖRPERTEILE_MEHRERE = 'Körperteile (mehrere)';
    /**
     * Constant for value 'Knie'
     * @return string 'Knie'
     */
    const VALUE_KNIE = 'Knie';
    /**
     * Constant for value 'Kopf und Hals'
     * @return string 'Kopf und Hals'
     */
    const VALUE_KOPF_UND_HALS = 'Kopf und Hals';
    /**
     * Constant for value 'Kopf/Gehirn mit Sinnesorgane'
     * @return string 'Kopf/Gehirn mit Sinnesorgane'
     */
    const VALUE_KOPF_GEHIRN_MIT_SINNESORGANE = 'Kopf/Gehirn mit Sinnesorgane';
    /**
     * Constant for value 'Kopf/Gehirn ohne Sinnesorgane'
     * @return string 'Kopf/Gehirn ohne Sinnesorgane'
     */
    const VALUE_KOPF_GEHIRN_OHNE_SINNESORGANE = 'Kopf/Gehirn ohne Sinnesorgane';
    /**
     * Constant for value 'Kopf/Hals und Rumpf'
     * @return string 'Kopf/Hals und Rumpf'
     */
    const VALUE_KOPF_HALS_UND_RUMPF = 'Kopf/Hals und Rumpf';
    /**
     * Constant for value 'Leber'
     * @return string 'Leber'
     */
    const VALUE_LEBER = 'Leber';
    /**
     * Constant for value 'Leber/Niere/Milz (mehrere Verletzungen)'
     * @return string 'Leber/Niere/Milz (mehrere Verletzungen)'
     */
    const VALUE_LEBER_NIERE_MILZ_MEHRERE_VERLETZUNGEN = 'Leber/Niere/Milz (mehrere Verletzungen)';
    /**
     * Constant for value 'Magen'
     * @return string 'Magen'
     */
    const VALUE_MAGEN = 'Magen';
    /**
     * Constant for value 'Milz'
     * @return string 'Milz'
     */
    const VALUE_MILZ = 'Milz';
    /**
     * Constant for value 'Niere (eine)'
     * @return string 'Niere (eine)'
     */
    const VALUE_NIERE_EINE = 'Niere (eine)';
    /**
     * Constant for value 'Nieren (beide)'
     * @return string 'Nieren (beide)'
     */
    const VALUE_NIEREN_BEIDE = 'Nieren (beide)';
    /**
     * Constant for value 'Nieren und Milz'
     * @return string 'Nieren und Milz'
     */
    const VALUE_NIEREN_UND_MILZ = 'Nieren und Milz';
    /**
     * Constant for value 'Ohr (eines)'
     * @return string 'Ohr (eines)'
     */
    const VALUE_OHR_EINES = 'Ohr (eines)';
    /**
     * Constant for value 'Ohren (beide)'
     * @return string 'Ohren (beide)'
     */
    const VALUE_OHREN_BEIDE = 'Ohren (beide)';
    /**
     * Constant for value 'Sinnesorgane (mehrere)'
     * @return string 'Sinnesorgane (mehrere)'
     */
    const VALUE_SINNESORGANE_MEHRERE = 'Sinnesorgane (mehrere)';
    /**
     * Constant for value 'Sonstige'
     * @return string 'Sonstige'
     */
    const VALUE_SONSTIGE = 'Sonstige';
    /**
     * Constant for value 'Teile (mehrere) des Rumpfes'
     * @return string 'Teile (mehrere) des Rumpfes'
     */
    const VALUE_TEILE_MEHRERE_DES_RUMPFES = 'Teile (mehrere) des Rumpfes';
    /**
     * Constant for value 'Unterleib'
     * @return string 'Unterleib'
     */
    const VALUE_UNTERLEIB = 'Unterleib';
    /**
     * Constant for value 'Verschlüsselung nicht möglich'
     * @return string 'Verschlüsselung nicht möglich'
     */
    const VALUE_VERSCHL_ÜSSELUNG_NICHT_M_ÖGLICH = 'Verschlüsselung nicht möglich';
    /**
     * Constant for value 'Wirbelsäule mit Querschnitt'
     * @return string 'Wirbelsäule mit Querschnitt'
     */
    const VALUE_WIRBELS_ÄULE_MIT_QUERSCHNITT = 'Wirbelsäule mit Querschnitt';
    /**
     * Constant for value 'Wirbelsäule ohne Querschnitt'
     * @return string 'Wirbelsäule ohne Querschnitt'
     */
    const VALUE_WIRBELS_ÄULE_OHNE_QUERSCHNITT = 'Wirbelsäule ohne Querschnitt';
    /**
     * Constant for value 'Zähne, Kiefer, keine sonstigen Verletzungen'
     * @return string 'Zähne, Kiefer, keine sonstigen Verletzungen'
     */
    const VALUE_Z_ÄHNE_KIEFER_KEINE_SONSTIGEN_VERLETZUNGEN = 'Zähne, Kiefer, keine sonstigen Verletzungen';
    /**
     * Constant for value 'Zehe (außer Großzehe)'
     * @return string 'Zehe (außer Großzehe)'
     */
    const VALUE_ZEHE_AU_ßER_GRO_ßZEHE = 'Zehe (außer Großzehe)';
    /**
     * Constant for value 'Zehe (Großzehe)'
     * @return string 'Zehe (Großzehe)'
     */
    const VALUE_ZEHE_GRO_ßZEHE = 'Zehe (Großzehe)';
    /**
     * Constant for value 'Zehen (mehrere)'
     * @return string 'Zehen (mehrere)'
     */
    const VALUE_ZEHEN_MEHRERE = 'Zehen (mehrere)';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ARM_EINER_BIS_OBERHALB_ELLENBOGEN
     * @uses self::VALUE_ARM_EINER_INKL_SCHULTERGELENK
     * @uses self::VALUE_ARM_EINER_INKL_ELLENBOGEN
     * @uses self::VALUE_AUGE_EINES
     * @uses self::VALUE_AUGEN_BEIDE
     * @uses self::VALUE_BECKEN
     * @uses self::VALUE_BEIN_EINES_BIS_MITTE_OBERSCHENKEL
     * @uses self::VALUE_BEIN_EINES_BIS_MITTE_UNTERSCHENKEL
     * @uses self::VALUE_BEIN_EINES_BIS_UNTERHALB_KNIE
     * @uses self::VALUE_BEIN_EINES_BIS_ZUR_H_ÜFTE
     * @uses self::VALUE_BEINE_F_ÜßE_BEIDE
     * @uses self::VALUE_BRUST_WEIBL
     * @uses self::VALUE_BRUSTKORB_BAUCH
     * @uses self::VALUE_ENDGLIED_DAUMEN
     * @uses self::VALUE_ENDGLIED_MITTELFINGER
     * @uses self::VALUE_ENDGLIED_ZEIGEFINGER
     * @uses self::VALUE_ERTRINKEN_ERSTICKEN_VERBRENNEN
     * @uses self::VALUE_FINGER_DAUMEN
     * @uses self::VALUE_FINGER_MEHRERE
     * @uses self::VALUE_FINGER_MITTELFINGER
     * @uses self::VALUE_FINGER_RING_KLEINFINGER
     * @uses self::VALUE_FINGER_ZEIGEFINGER
     * @uses self::VALUE_GERUCH
     * @uses self::VALUE_GESCHLECHTSORGAN_M_ÄNNL
     * @uses self::VALUE_GESCHMACK
     * @uses self::VALUE_GLIEDMA_ßEN_UNTERE_UND_OBERE
     * @uses self::VALUE_GLIEDMA_ßEN_U_RUMPF
     * @uses self::VALUE_GLIEDMA_ßEN_UND_KOPF_HALS
     * @uses self::VALUE_H_ÄNDE_ARME_BEIDE
     * @uses self::VALUE_HAND_EINE
     * @uses self::VALUE_INNERE_ORGANE_SONSTIGE
     * @uses self::VALUE_INNERE_ORGANE_UND_ANDERE_K_ÖRPERTEILE
     * @uses self::VALUE_K_ÖRPERTEILE_MEHRERE
     * @uses self::VALUE_KNIE
     * @uses self::VALUE_KOPF_UND_HALS
     * @uses self::VALUE_KOPF_GEHIRN_MIT_SINNESORGANE
     * @uses self::VALUE_KOPF_GEHIRN_OHNE_SINNESORGANE
     * @uses self::VALUE_KOPF_HALS_UND_RUMPF
     * @uses self::VALUE_LEBER
     * @uses self::VALUE_LEBER_NIERE_MILZ_MEHRERE_VERLETZUNGEN
     * @uses self::VALUE_MAGEN
     * @uses self::VALUE_MILZ
     * @uses self::VALUE_NIERE_EINE
     * @uses self::VALUE_NIEREN_BEIDE
     * @uses self::VALUE_NIEREN_UND_MILZ
     * @uses self::VALUE_OHR_EINES
     * @uses self::VALUE_OHREN_BEIDE
     * @uses self::VALUE_SINNESORGANE_MEHRERE
     * @uses self::VALUE_SONSTIGE
     * @uses self::VALUE_TEILE_MEHRERE_DES_RUMPFES
     * @uses self::VALUE_UNTERLEIB
     * @uses self::VALUE_VERSCHL_ÜSSELUNG_NICHT_M_ÖGLICH
     * @uses self::VALUE_WIRBELS_ÄULE_MIT_QUERSCHNITT
     * @uses self::VALUE_WIRBELS_ÄULE_OHNE_QUERSCHNITT
     * @uses self::VALUE_Z_ÄHNE_KIEFER_KEINE_SONSTIGEN_VERLETZUNGEN
     * @uses self::VALUE_ZEHE_AU_ßER_GRO_ßZEHE
     * @uses self::VALUE_ZEHE_GRO_ßZEHE
     * @uses self::VALUE_ZEHEN_MEHRERE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ARM_EINER_BIS_OBERHALB_ELLENBOGEN,
            self::VALUE_ARM_EINER_INKL_SCHULTERGELENK,
            self::VALUE_ARM_EINER_INKL_ELLENBOGEN,
            self::VALUE_AUGE_EINES,
            self::VALUE_AUGEN_BEIDE,
            self::VALUE_BECKEN,
            self::VALUE_BEIN_EINES_BIS_MITTE_OBERSCHENKEL,
            self::VALUE_BEIN_EINES_BIS_MITTE_UNTERSCHENKEL,
            self::VALUE_BEIN_EINES_BIS_UNTERHALB_KNIE,
            self::VALUE_BEIN_EINES_BIS_ZUR_H_ÜFTE,
            self::VALUE_BEINE_F_ÜßE_BEIDE,
            self::VALUE_BRUST_WEIBL,
            self::VALUE_BRUSTKORB_BAUCH,
            self::VALUE_ENDGLIED_DAUMEN,
            self::VALUE_ENDGLIED_MITTELFINGER,
            self::VALUE_ENDGLIED_ZEIGEFINGER,
            self::VALUE_ERTRINKEN_ERSTICKEN_VERBRENNEN,
            self::VALUE_FINGER_DAUMEN,
            self::VALUE_FINGER_MEHRERE,
            self::VALUE_FINGER_MITTELFINGER,
            self::VALUE_FINGER_RING_KLEINFINGER,
            self::VALUE_FINGER_ZEIGEFINGER,
            self::VALUE_GERUCH,
            self::VALUE_GESCHLECHTSORGAN_M_ÄNNL,
            self::VALUE_GESCHMACK,
            self::VALUE_GLIEDMA_ßEN_UNTERE_UND_OBERE,
            self::VALUE_GLIEDMA_ßEN_U_RUMPF,
            self::VALUE_GLIEDMA_ßEN_UND_KOPF_HALS,
            self::VALUE_H_ÄNDE_ARME_BEIDE,
            self::VALUE_HAND_EINE,
            self::VALUE_INNERE_ORGANE_SONSTIGE,
            self::VALUE_INNERE_ORGANE_UND_ANDERE_K_ÖRPERTEILE,
            self::VALUE_K_ÖRPERTEILE_MEHRERE,
            self::VALUE_KNIE,
            self::VALUE_KOPF_UND_HALS,
            self::VALUE_KOPF_GEHIRN_MIT_SINNESORGANE,
            self::VALUE_KOPF_GEHIRN_OHNE_SINNESORGANE,
            self::VALUE_KOPF_HALS_UND_RUMPF,
            self::VALUE_LEBER,
            self::VALUE_LEBER_NIERE_MILZ_MEHRERE_VERLETZUNGEN,
            self::VALUE_MAGEN,
            self::VALUE_MILZ,
            self::VALUE_NIERE_EINE,
            self::VALUE_NIEREN_BEIDE,
            self::VALUE_NIEREN_UND_MILZ,
            self::VALUE_OHR_EINES,
            self::VALUE_OHREN_BEIDE,
            self::VALUE_SINNESORGANE_MEHRERE,
            self::VALUE_SONSTIGE,
            self::VALUE_TEILE_MEHRERE_DES_RUMPFES,
            self::VALUE_UNTERLEIB,
            self::VALUE_VERSCHL_ÜSSELUNG_NICHT_M_ÖGLICH,
            self::VALUE_WIRBELS_ÄULE_MIT_QUERSCHNITT,
            self::VALUE_WIRBELS_ÄULE_OHNE_QUERSCHNITT,
            self::VALUE_Z_ÄHNE_KIEFER_KEINE_SONSTIGEN_VERLETZUNGEN,
            self::VALUE_ZEHE_AU_ßER_GRO_ßZEHE,
            self::VALUE_ZEHE_GRO_ßZEHE,
            self::VALUE_ZEHEN_MEHRERE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
