<?php

namespace EnumType;

/**
 * This class stands for IVClaimBranch EnumType
 * Meta information extracted from the WSDL
 * - documentation: Claim for which the policy issue.
 * @subpackage Enumerations
 */
class IVClaimBranch
{
    /**
     * Constant for value 'KFZ'
     * @return string 'KFZ'
     */
    const VALUE_KFZ = 'KFZ';
    /**
     * Constant for value 'KRANKEN'
     * @return string 'KRANKEN'
     */
    const VALUE_KRANKEN = 'KRANKEN';
    /**
     * Constant for value 'RS'
     * @return string 'RS'
     */
    const VALUE_RS = 'RS';
    /**
     * Constant for value 'SACHHAFT'
     * @return string 'SACHHAFT'
     */
    const VALUE_SACHHAFT = 'SACHHAFT';
    /**
     * Constant for value 'UNFALL'
     * @return string 'UNFALL'
     */
    const VALUE_UNFALL = 'UNFALL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KFZ
     * @uses self::VALUE_KRANKEN
     * @uses self::VALUE_RS
     * @uses self::VALUE_SACHHAFT
     * @uses self::VALUE_UNFALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KFZ,
            self::VALUE_KRANKEN,
            self::VALUE_RS,
            self::VALUE_SACHHAFT,
            self::VALUE_UNFALL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
