<?php

namespace EnumType;

/**
 * This class stands for gueterbefoerderungLkwType EnumType
 * @subpackage Enumerations
 */
class GueterbefoerderungLkwType
{
    /**
     * Constant for value 'Werksverkehr'
     * @return string 'Werksverkehr'
     */
    const VALUE_WERKSVERKEHR = 'Werksverkehr';
    /**
     * Constant for value 'Transportgewerbe'
     * @return string 'Transportgewerbe'
     */
    const VALUE_TRANSPORTGEWERBE = 'Transportgewerbe';
    /**
     * Constant for value 'ohne Güterbeförderung'
     * @return string 'ohne Güterbeförderung'
     */
    const VALUE_OHNE_G_ÜTERBEF_ÖRDERUNG = 'ohne Güterbeförderung';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WERKSVERKEHR
     * @uses self::VALUE_TRANSPORTGEWERBE
     * @uses self::VALUE_OHNE_G_ÜTERBEF_ÖRDERUNG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WERKSVERKEHR,
            self::VALUE_TRANSPORTGEWERBE,
            self::VALUE_OHNE_G_ÜTERBEF_ÖRDERUNG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
