<?php

namespace EnumType;

/**
 * This class stands for geschaeftsstelleType EnumType
 * @subpackage Enumerations
 */
class GeschaeftsstelleType
{
    /**
     * Constant for value 'Simmering'
     * @return string 'Simmering'
     */
    const VALUE_SIMMERING = 'Simmering';
    /**
     * Constant for value 'Süd'
     * @return string 'Süd'
     */
    const VALUE_S_ÜD = 'Süd';
    /**
     * Constant for value 'VZ Landstrasse, Landstraßer Hauptstrasse 153-155'
     * @return string 'VZ Landstrasse, Landstraßer Hauptstrasse 153-155'
     */
    const VALUE_VZ_LANDSTRASSE_LANDSTRA_ßER_HAUPTSTRASSE_153_155 = 'VZ Landstrasse, Landstraßer Hauptstrasse 153-155';
    /**
     * Constant for value 'Zentrum'
     * @return string 'Zentrum'
     */
    const VALUE_ZENTRUM = 'Zentrum';
    /**
     * Constant for value 'ÖAMTC Wien'
     * @return string 'ÖAMTC Wien'
     */
    const VALUE_ÖAMTC_WIEN = 'ÖAMTC Wien';
    /**
     * Constant for value 'Unabhängige Vertriebe Div. 1 (W)'
     * @return string 'Unabhängige Vertriebe Div. 1 (W)'
     */
    const VALUE_UNABH_ÄNGIGE_VERTRIEBE_DIV_1_W = 'Unabhängige Vertriebe Div. 1 (W)';
    /**
     * Constant for value 'Unabhängige Vertriebe Div. 2 (W)'
     * @return string 'Unabhängige Vertriebe Div. 2 (W)'
     */
    const VALUE_UNABH_ÄNGIGE_VERTRIEBE_DIV_2_W = 'Unabhängige Vertriebe Div. 2 (W)';
    /**
     * Constant for value 'Unabhängige Vertriebe Div. 3 (W)'
     * @return string 'Unabhängige Vertriebe Div. 3 (W)'
     */
    const VALUE_UNABH_ÄNGIGE_VERTRIEBE_DIV_3_W = 'Unabhängige Vertriebe Div. 3 (W)';
    /**
     * Constant for value 'Unabhängige Vertriebe Div. 4 (W)'
     * @return string 'Unabhängige Vertriebe Div. 4 (W)'
     */
    const VALUE_UNABH_ÄNGIGE_VERTRIEBE_DIV_4_W = 'Unabhängige Vertriebe Div. 4 (W)';
    /**
     * Constant for value 'Innendienst (Wien)'
     * @return string 'Innendienst (Wien)'
     */
    const VALUE_INNENDIENST_WIEN = 'Innendienst (Wien)';
    /**
     * Constant for value 'Wien Nord'
     * @return string 'Wien Nord'
     */
    const VALUE_WIEN_NORD = 'Wien Nord';
    /**
     * Constant for value 'VG Hietzing'
     * @return string 'VG Hietzing'
     */
    const VALUE_VG_HIETZING = 'VG Hietzing';
    /**
     * Constant for value 'Donaufelderhof'
     * @return string 'Donaufelderhof'
     */
    const VALUE_DONAUFELDERHOF = 'Donaufelderhof';
    /**
     * Constant for value 'Favoriten'
     * @return string 'Favoriten'
     */
    const VALUE_FAVORITEN = 'Favoriten';
    /**
     * Constant for value 'Floridsdorf'
     * @return string 'Floridsdorf'
     */
    const VALUE_FLORIDSDORF = 'Floridsdorf';
    /**
     * Constant for value 'Am Hof / HM'
     * @return string 'Am Hof / HM'
     */
    const VALUE_AM_HOF_HM = 'Am Hof / HM';
    /**
     * Constant for value 'Augasse'
     * @return string 'Augasse'
     */
    const VALUE_AUGASSE = 'Augasse';
    /**
     * Constant for value 'Landstrasse, Landstraßer Hauptstraße 26 1.+2. Stock'
     * @return string 'Landstrasse, Landstraßer Hauptstraße 26 1.+2. Stock'
     */
    const VALUE_LANDSTRASSE_LANDSTRA_ßER_HAUPTSTRA_ßE_26_1_2_STOCK = 'Landstrasse, Landstraßer Hauptstraße 26 1.+2. Stock';
    /**
     * Constant for value 'Meiselstrasse'
     * @return string 'Meiselstrasse'
     */
    const VALUE_MEISELSTRASSE = 'Meiselstrasse';
    /**
     * Constant for value 'Amstetten'
     * @return string 'Amstetten'
     */
    const VALUE_AMSTETTEN = 'Amstetten';
    /**
     * Constant for value 'Baden'
     * @return string 'Baden'
     */
    const VALUE_BADEN = 'Baden';
    /**
     * Constant for value 'Bruck/Leitha (NÖ)'
     * @return string 'Bruck/Leitha (NÖ)'
     */
    const VALUE_BRUCK_LEITHA_N_Ö = 'Bruck/Leitha (NÖ)';
    /**
     * Constant for value 'Gänserndorf'
     * @return string 'Gänserndorf'
     */
    const VALUE_G_ÄNSERNDORF = 'Gänserndorf';
    /**
     * Constant for value 'Gloggnitz'
     * @return string 'Gloggnitz'
     */
    const VALUE_GLOGGNITZ = 'Gloggnitz';
    /**
     * Constant for value 'Gmünd'
     * @return string 'Gmünd'
     */
    const VALUE_GM_ÜND = 'Gmünd';
    /**
     * Constant for value 'Gr.Enzersdorf'
     * @return string 'Gr.Enzersdorf'
     */
    const VALUE_GR_ENZERSDORF = 'Gr.Enzersdorf';
    /**
     * Constant for value 'Haag'
     * @return string 'Haag'
     */
    const VALUE_HAAG = 'Haag';
    /**
     * Constant for value 'Hollabrunn'
     * @return string 'Hollabrunn'
     */
    const VALUE_HOLLABRUNN = 'Hollabrunn';
    /**
     * Constant for value 'Horn'
     * @return string 'Horn'
     */
    const VALUE_HORN = 'Horn';
    /**
     * Constant for value 'Klosterneuburg'
     * @return string 'Klosterneuburg'
     */
    const VALUE_KLOSTERNEUBURG = 'Klosterneuburg';
    /**
     * Constant for value 'Korneuburg'
     * @return string 'Korneuburg'
     */
    const VALUE_KORNEUBURG = 'Korneuburg';
    /**
     * Constant for value 'Krems'
     * @return string 'Krems'
     */
    const VALUE_KREMS = 'Krems';
    /**
     * Constant for value 'Lilienfeld'
     * @return string 'Lilienfeld'
     */
    const VALUE_LILIENFELD = 'Lilienfeld';
    /**
     * Constant for value 'Ma. Enzersdorf'
     * @return string 'Ma. Enzersdorf'
     */
    const VALUE_MA_ENZERSDORF = 'Ma. Enzersdorf';
    /**
     * Constant for value 'Melk'
     * @return string 'Melk'
     */
    const VALUE_MELK = 'Melk';
    /**
     * Constant for value 'Mistelbach'
     * @return string 'Mistelbach'
     */
    const VALUE_MISTELBACH = 'Mistelbach';
    /**
     * Constant for value 'Neunkirchen'
     * @return string 'Neunkirchen'
     */
    const VALUE_NEUNKIRCHEN = 'Neunkirchen';
    /**
     * Constant for value 'Purkersdorf'
     * @return string 'Purkersdorf'
     */
    const VALUE_PURKERSDORF = 'Purkersdorf';
    /**
     * Constant for value 'Wieselburg'
     * @return string 'Wieselburg'
     */
    const VALUE_WIESELBURG = 'Wieselburg';
    /**
     * Constant for value 'Schwechat'
     * @return string 'Schwechat'
     */
    const VALUE_SCHWECHAT = 'Schwechat';
    /**
     * Constant for value 'St. Pölten'
     * @return string 'St. Pölten'
     */
    const VALUE_ST_P_ÖLTEN = 'St. Pölten';
    /**
     * Constant for value 'Tulln'
     * @return string 'Tulln'
     */
    const VALUE_TULLN = 'Tulln';
    /**
     * Constant for value 'Waidhofen/Thaya'
     * @return string 'Waidhofen/Thaya'
     */
    const VALUE_WAIDHOFEN_THAYA = 'Waidhofen/Thaya';
    /**
     * Constant for value 'Waidhofen/Ybbs'
     * @return string 'Waidhofen/Ybbs'
     */
    const VALUE_WAIDHOFEN_YBBS = 'Waidhofen/Ybbs';
    /**
     * Constant for value 'Wr. Neustadt'
     * @return string 'Wr. Neustadt'
     */
    const VALUE_WR_NEUSTADT = 'Wr. Neustadt';
    /**
     * Constant for value 'Zwettl'
     * @return string 'Zwettl'
     */
    const VALUE_ZWETTL = 'Zwettl';
    /**
     * Constant for value 'ÖAMTC Niederösterreich'
     * @return string 'ÖAMTC Niederösterreich'
     */
    const VALUE_ÖAMTC_NIEDER_ÖSTERREICH = 'ÖAMTC Niederösterreich';
    /**
     * Constant for value 'Unabhängige Vertriebe (NÖ)'
     * @return string 'Unabhängige Vertriebe (NÖ)'
     */
    const VALUE_UNABH_ÄNGIGE_VERTRIEBE_N_Ö = 'Unabhängige Vertriebe (NÖ)';
    /**
     * Constant for value 'Innendienst (NÖ)'
     * @return string 'Innendienst (NÖ)'
     */
    const VALUE_INNENDIENST_N_Ö = 'Innendienst (NÖ)';
    /**
     * Constant for value 'Amstetten (Spezialistenvertrieb)'
     * @return string 'Amstetten (Spezialistenvertrieb)'
     */
    const VALUE_AMSTETTEN_SPEZIALISTENVERTRIEB = 'Amstetten (Spezialistenvertrieb)';
    /**
     * Constant for value 'Tulln (Spezialistenvertrieb)'
     * @return string 'Tulln (Spezialistenvertrieb)'
     */
    const VALUE_TULLN_SPEZIALISTENVERTRIEB = 'Tulln (Spezialistenvertrieb)';
    /**
     * Constant for value 'Ma. Enzersdorf (Spezialistenvertrieb)'
     * @return string 'Ma. Enzersdorf (Spezialistenvertrieb)'
     */
    const VALUE_MA_ENZERSDORF_SPEZIALISTENVERTRIEB = 'Ma. Enzersdorf (Spezialistenvertrieb)';
    /**
     * Constant for value 'Krems (Spezialistenvertrieb)'
     * @return string 'Krems (Spezialistenvertrieb)'
     */
    const VALUE_KREMS_SPEZIALISTENVERTRIEB = 'Krems (Spezialistenvertrieb)';
    /**
     * Constant for value 'St. Pölten (Spezialistenvertrieb)'
     * @return string 'St. Pölten (Spezialistenvertrieb)'
     */
    const VALUE_ST_P_ÖLTEN_SPEZIALISTENVERTRIEB = 'St. Pölten (Spezialistenvertrieb)';
    /**
     * Constant for value 'Bad Ischl'
     * @return string 'Bad Ischl'
     */
    const VALUE_BAD_ISCHL = 'Bad Ischl';
    /**
     * Constant for value 'Eferding'
     * @return string 'Eferding'
     */
    const VALUE_EFERDING = 'Eferding';
    /**
     * Constant for value 'Freistadt'
     * @return string 'Freistadt'
     */
    const VALUE_FREISTADT = 'Freistadt';
    /**
     * Constant for value 'Gmunden'
     * @return string 'Gmunden'
     */
    const VALUE_GMUNDEN = 'Gmunden';
    /**
     * Constant for value 'Grieskirchen'
     * @return string 'Grieskirchen'
     */
    const VALUE_GRIESKIRCHEN = 'Grieskirchen';
    /**
     * Constant for value 'Kirchdorf'
     * @return string 'Kirchdorf'
     */
    const VALUE_KIRCHDORF = 'Kirchdorf';
    /**
     * Constant for value 'Linz, Stifterplatz'
     * @return string 'Linz, Stifterplatz'
     */
    const VALUE_LINZ_STIFTERPLATZ = 'Linz, Stifterplatz';
    /**
     * Constant for value 'Linz, Unionstr. (Agenturvertrieb OÖ)'
     * @return string 'Linz, Unionstr. (Agenturvertrieb OÖ)'
     */
    const VALUE_LINZ_UNIONSTR_AGENTURVERTRIEB_O_Ö = 'Linz, Unionstr. (Agenturvertrieb OÖ)';
    /**
     * Constant for value 'Linz, Urfahr Umgebung'
     * @return string 'Linz, Urfahr Umgebung'
     */
    const VALUE_LINZ_URFAHR_UMGEBUNG = 'Linz, Urfahr Umgebung';
    /**
     * Constant for value 'Perg'
     * @return string 'Perg'
     */
    const VALUE_PERG = 'Perg';
    /**
     * Constant for value 'Ried'
     * @return string 'Ried'
     */
    const VALUE_RIED = 'Ried';
    /**
     * Constant for value 'Rohrbach'
     * @return string 'Rohrbach'
     */
    const VALUE_ROHRBACH = 'Rohrbach';
    /**
     * Constant for value 'Schärding'
     * @return string 'Schärding'
     */
    const VALUE_SCH_ÄRDING = 'Schärding';
    /**
     * Constant for value 'Steyr'
     * @return string 'Steyr'
     */
    const VALUE_STEYR = 'Steyr';
    /**
     * Constant for value 'Traun'
     * @return string 'Traun'
     */
    const VALUE_TRAUN = 'Traun';
    /**
     * Constant for value 'Vöcklabruck'
     * @return string 'Vöcklabruck'
     */
    const VALUE_V_ÖCKLABRUCK = 'Vöcklabruck';
    /**
     * Constant for value 'Wels'
     * @return string 'Wels'
     */
    const VALUE_WELS = 'Wels';
    /**
     * Constant for value 'Windischgarsten'
     * @return string 'Windischgarsten'
     */
    const VALUE_WINDISCHGARSTEN = 'Windischgarsten';
    /**
     * Constant for value 'ÖAMTC Oberösterreich'
     * @return string 'ÖAMTC Oberösterreich'
     */
    const VALUE_ÖAMTC_OBER_ÖSTERREICH = 'ÖAMTC Oberösterreich';
    /**
     * Constant for value 'Unabhängige Vertriebe (OÖ)'
     * @return string 'Unabhängige Vertriebe (OÖ)'
     */
    const VALUE_UNABH_ÄNGIGE_VERTRIEBE_O_Ö = 'Unabhängige Vertriebe (OÖ)';
    /**
     * Constant for value 'Innendienst (OÖ)'
     * @return string 'Innendienst (OÖ)'
     */
    const VALUE_INNENDIENST_O_Ö = 'Innendienst (OÖ)';
    /**
     * Constant for value 'Bad Hofgastein'
     * @return string 'Bad Hofgastein'
     */
    const VALUE_BAD_HOFGASTEIN = 'Bad Hofgastein';
    /**
     * Constant for value 'Braunau'
     * @return string 'Braunau'
     */
    const VALUE_BRAUNAU = 'Braunau';
    /**
     * Constant for value 'Hallein'
     * @return string 'Hallein'
     */
    const VALUE_HALLEIN = 'Hallein';
    /**
     * Constant for value 'Mattighofen'
     * @return string 'Mattighofen'
     */
    const VALUE_MATTIGHOFEN = 'Mattighofen';
    /**
     * Constant for value 'Mondsee'
     * @return string 'Mondsee'
     */
    const VALUE_MONDSEE = 'Mondsee';
    /**
     * Constant for value 'Neumarkt (S)'
     * @return string 'Neumarkt (S)'
     */
    const VALUE_NEUMARKT_S = 'Neumarkt (S)';
    /**
     * Constant for value 'Oberndorf'
     * @return string 'Oberndorf'
     */
    const VALUE_OBERNDORF = 'Oberndorf';
    /**
     * Constant for value 'Ostermiething'
     * @return string 'Ostermiething'
     */
    const VALUE_OSTERMIETHING = 'Ostermiething';
    /**
     * Constant for value 'Saalfelden'
     * @return string 'Saalfelden'
     */
    const VALUE_SAALFELDEN = 'Saalfelden';
    /**
     * Constant for value 'Salzburg Stadt'
     * @return string 'Salzburg Stadt'
     */
    const VALUE_SALZBURG_STADT = 'Salzburg Stadt';
    /**
     * Constant for value 'Seekirchen'
     * @return string 'Seekirchen'
     */
    const VALUE_SEEKIRCHEN = 'Seekirchen';
    /**
     * Constant for value 'St.Johann'
     * @return string 'St.Johann'
     */
    const VALUE_ST_JOHANN = 'St.Johann';
    /**
     * Constant for value 'Tamsweg'
     * @return string 'Tamsweg'
     */
    const VALUE_TAMSWEG = 'Tamsweg';
    /**
     * Constant for value 'Zell am See'
     * @return string 'Zell am See'
     */
    const VALUE_ZELL_AM_SEE = 'Zell am See';
    /**
     * Constant for value 'ÖAMTC Salzburg'
     * @return string 'ÖAMTC Salzburg'
     */
    const VALUE_ÖAMTC_SALZBURG = 'ÖAMTC Salzburg';
    /**
     * Constant for value 'Unabhängige Vertriebe (S)'
     * @return string 'Unabhängige Vertriebe (S)'
     */
    const VALUE_UNABH_ÄNGIGE_VERTRIEBE_S = 'Unabhängige Vertriebe (S)';
    /**
     * Constant for value 'Agentur Partner Service (S)'
     * @return string 'Agentur Partner Service (S)'
     */
    const VALUE_AGENTUR_PARTNER_SERVICE_S = 'Agentur Partner Service (S)';
    /**
     * Constant for value 'Imst'
     * @return string 'Imst'
     */
    const VALUE_IMST = 'Imst';
    /**
     * Constant for value 'Innsbruck, Grabenweg'
     * @return string 'Innsbruck, Grabenweg'
     */
    const VALUE_INNSBRUCK_GRABENWEG = 'Innsbruck, Grabenweg';
    /**
     * Constant for value 'Innsbruck, Rennweg'
     * @return string 'Innsbruck, Rennweg'
     */
    const VALUE_INNSBRUCK_RENNWEG = 'Innsbruck, Rennweg';
    /**
     * Constant for value 'Kaltenbach'
     * @return string 'Kaltenbach'
     */
    const VALUE_KALTENBACH = 'Kaltenbach';
    /**
     * Constant for value 'Kitzbühel'
     * @return string 'Kitzbühel'
     */
    const VALUE_KITZB_ÜHEL = 'Kitzbühel';
    /**
     * Constant for value 'Kufstein'
     * @return string 'Kufstein'
     */
    const VALUE_KUFSTEIN = 'Kufstein';
    /**
     * Constant for value 'Landeck'
     * @return string 'Landeck'
     */
    const VALUE_LANDECK = 'Landeck';
    /**
     * Constant for value 'Reutte'
     * @return string 'Reutte'
     */
    const VALUE_REUTTE = 'Reutte';
    /**
     * Constant for value 'Schwaz'
     * @return string 'Schwaz'
     */
    const VALUE_SCHWAZ = 'Schwaz';
    /**
     * Constant for value 'Telfs'
     * @return string 'Telfs'
     */
    const VALUE_TELFS = 'Telfs';
    /**
     * Constant for value 'Wörgl'
     * @return string 'Wörgl'
     */
    const VALUE_W_ÖRGL = 'Wörgl';
    /**
     * Constant for value 'ÖAMTC Tirol'
     * @return string 'ÖAMTC Tirol'
     */
    const VALUE_ÖAMTC_TIROL = 'ÖAMTC Tirol';
    /**
     * Constant for value 'Unabhängige Vertriebe (T)'
     * @return string 'Unabhängige Vertriebe (T)'
     */
    const VALUE_UNABH_ÄNGIGE_VERTRIEBE_T = 'Unabhängige Vertriebe (T)';
    /**
     * Constant for value 'Bludenz'
     * @return string 'Bludenz'
     */
    const VALUE_BLUDENZ = 'Bludenz';
    /**
     * Constant for value 'Bregenz'
     * @return string 'Bregenz'
     */
    const VALUE_BREGENZ = 'Bregenz';
    /**
     * Constant for value 'Dornbirn'
     * @return string 'Dornbirn'
     */
    const VALUE_DORNBIRN = 'Dornbirn';
    /**
     * Constant for value 'Egg'
     * @return string 'Egg'
     */
    const VALUE_EGG = 'Egg';
    /**
     * Constant for value 'Feldkirch'
     * @return string 'Feldkirch'
     */
    const VALUE_FELDKIRCH = 'Feldkirch';
    /**
     * Constant for value 'Götzis'
     * @return string 'Götzis'
     */
    const VALUE_G_ÖTZIS = 'Götzis';
    /**
     * Constant for value 'ÖAMTC Vorarlberg'
     * @return string 'ÖAMTC Vorarlberg'
     */
    const VALUE_ÖAMTC_VORARLBERG = 'ÖAMTC Vorarlberg';
    /**
     * Constant for value 'Unabhängige Vertriebe (VLBG)'
     * @return string 'Unabhängige Vertriebe (VLBG)'
     */
    const VALUE_UNABH_ÄNGIGE_VERTRIEBE_VLBG = 'Unabhängige Vertriebe (VLBG)';
    /**
     * Constant for value 'VOLZ'
     * @return string 'VOLZ'
     */
    const VALUE_VOLZ = 'VOLZ';
    /**
     * Constant for value 'Jennersdorf'
     * @return string 'Jennersdorf'
     */
    const VALUE_JENNERSDORF = 'Jennersdorf';
    /**
     * Constant for value 'Mattersburg'
     * @return string 'Mattersburg'
     */
    const VALUE_MATTERSBURG = 'Mattersburg';
    /**
     * Constant for value 'Neusiedl/See'
     * @return string 'Neusiedl/See'
     */
    const VALUE_NEUSIEDL_SEE = 'Neusiedl/See';
    /**
     * Constant for value 'Oberpullendorf'
     * @return string 'Oberpullendorf'
     */
    const VALUE_OBERPULLENDORF = 'Oberpullendorf';
    /**
     * Constant for value 'Oberwart'
     * @return string 'Oberwart'
     */
    const VALUE_OBERWART = 'Oberwart';
    /**
     * Constant for value 'ÖAMTC Burgenland'
     * @return string 'ÖAMTC Burgenland'
     */
    const VALUE_ÖAMTC_BURGENLAND = 'ÖAMTC Burgenland';
    /**
     * Constant for value 'Unabhängige Vertriebe (BGLD)'
     * @return string 'Unabhängige Vertriebe (BGLD)'
     */
    const VALUE_UNABH_ÄNGIGE_VERTRIEBE_BGLD = 'Unabhängige Vertriebe (BGLD)';
    /**
     * Constant for value 'Bruck/Leitha (Bgld)'
     * @return string 'Bruck/Leitha (Bgld)'
     */
    const VALUE_BRUCK_LEITHA_BGLD = 'Bruck/Leitha (Bgld)';
    /**
     * Constant for value 'Eisenstadt'
     * @return string 'Eisenstadt'
     */
    const VALUE_EISENSTADT = 'Eisenstadt';
    /**
     * Constant for value 'Güssing'
     * @return string 'Güssing'
     */
    const VALUE_G_ÜSSING = 'Güssing';
    /**
     * Constant for value 'Bad Aussee'
     * @return string 'Bad Aussee'
     */
    const VALUE_BAD_AUSSEE = 'Bad Aussee';
    /**
     * Constant for value 'Bruck/Mur'
     * @return string 'Bruck/Mur'
     */
    const VALUE_BRUCK_MUR = 'Bruck/Mur';
    /**
     * Constant for value 'Deutschlandsberg'
     * @return string 'Deutschlandsberg'
     */
    const VALUE_DEUTSCHLANDSBERG = 'Deutschlandsberg';
    /**
     * Constant for value 'Eibiswald'
     * @return string 'Eibiswald'
     */
    const VALUE_EIBISWALD = 'Eibiswald';
    /**
     * Constant for value 'Graz, Waltendorfer Hauptstraße 5'
     * @return string 'Graz, Waltendorfer Hauptstraße 5'
     */
    const VALUE_GRAZ_WALTENDORFER_HAUPTSTRA_ßE_5 = 'Graz, Waltendorfer Hauptstraße 5';
    /**
     * Constant for value 'Graz/Arland'
     * @return string 'Graz/Arland'
     */
    const VALUE_GRAZ_ARLAND = 'Graz/Arland';
    /**
     * Constant for value 'Graz/Kärntnerstraße'
     * @return string 'Graz/Kärntnerstraße'
     */
    const VALUE_GRAZ_K_ÄRNTNERSTRA_ßE = 'Graz/Kärntnerstraße';
    /**
     * Constant for value 'Graz/Jakomini'
     * @return string 'Graz/Jakomini'
     */
    const VALUE_GRAZ_JAKOMINI = 'Graz/Jakomini';
    /**
     * Constant for value 'Feldbach'
     * @return string 'Feldbach'
     */
    const VALUE_FELDBACH = 'Feldbach';
    /**
     * Constant for value 'Fürstenfeld'
     * @return string 'Fürstenfeld'
     */
    const VALUE_F_ÜRSTENFELD = 'Fürstenfeld';
    /**
     * Constant for value 'Gleisdorf'
     * @return string 'Gleisdorf'
     */
    const VALUE_GLEISDORF = 'Gleisdorf';
    /**
     * Constant for value 'Gröbming'
     * @return string 'Gröbming'
     */
    const VALUE_GR_ÖBMING = 'Gröbming';
    /**
     * Constant for value 'Hartberg'
     * @return string 'Hartberg'
     */
    const VALUE_HARTBERG = 'Hartberg';
    /**
     * Constant for value 'Judenburg'
     * @return string 'Judenburg'
     */
    const VALUE_JUDENBURG = 'Judenburg';
    /**
     * Constant for value 'Kapfenberg'
     * @return string 'Kapfenberg'
     */
    const VALUE_KAPFENBERG = 'Kapfenberg';
    /**
     * Constant for value 'Knittelfeld'
     * @return string 'Knittelfeld'
     */
    const VALUE_KNITTELFELD = 'Knittelfeld';
    /**
     * Constant for value 'Leibnitz'
     * @return string 'Leibnitz'
     */
    const VALUE_LEIBNITZ = 'Leibnitz';
    /**
     * Constant for value 'Leoben'
     * @return string 'Leoben'
     */
    const VALUE_LEOBEN = 'Leoben';
    /**
     * Constant for value 'Liezen'
     * @return string 'Liezen'
     */
    const VALUE_LIEZEN = 'Liezen';
    /**
     * Constant for value 'Mariazell'
     * @return string 'Mariazell'
     */
    const VALUE_MARIAZELL = 'Mariazell';
    /**
     * Constant for value 'Murau'
     * @return string 'Murau'
     */
    const VALUE_MURAU = 'Murau';
    /**
     * Constant for value 'Mürzzuschlag'
     * @return string 'Mürzzuschlag'
     */
    const VALUE_M_ÜRZZUSCHLAG = 'Mürzzuschlag';
    /**
     * Constant for value 'Neumarkt (Stmk)'
     * @return string 'Neumarkt (Stmk)'
     */
    const VALUE_NEUMARKT_STMK = 'Neumarkt (Stmk)';
    /**
     * Constant for value 'Radkersburg'
     * @return string 'Radkersburg'
     */
    const VALUE_RADKERSBURG = 'Radkersburg';
    /**
     * Constant for value 'Rosental'
     * @return string 'Rosental'
     */
    const VALUE_ROSENTAL = 'Rosental';
    /**
     * Constant for value 'Weiz'
     * @return string 'Weiz'
     */
    const VALUE_WEIZ = 'Weiz';
    /**
     * Constant for value 'ÖAMTC Steiermark'
     * @return string 'ÖAMTC Steiermark'
     */
    const VALUE_ÖAMTC_STEIERMARK = 'ÖAMTC Steiermark';
    /**
     * Constant for value 'Unabhängige Vertriebe (STMK)'
     * @return string 'Unabhängige Vertriebe (STMK)'
     */
    const VALUE_UNABH_ÄNGIGE_VERTRIEBE_STMK = 'Unabhängige Vertriebe (STMK)';
    /**
     * Constant for value 'Innendienst (Stmk)'
     * @return string 'Innendienst (Stmk)'
     */
    const VALUE_INNENDIENST_STMK = 'Innendienst (Stmk)';
    /**
     * Constant for value 'Graz/Liebenau'
     * @return string 'Graz/Liebenau'
     */
    const VALUE_GRAZ_LIEBENAU = 'Graz/Liebenau';
    /**
     * Constant for value 'Feldkirchen'
     * @return string 'Feldkirchen'
     */
    const VALUE_FELDKIRCHEN = 'Feldkirchen';
    /**
     * Constant for value 'Hermagor'
     * @return string 'Hermagor'
     */
    const VALUE_HERMAGOR = 'Hermagor';
    /**
     * Constant for value 'Klagenfurt, Bahnhofstrasse'
     * @return string 'Klagenfurt, Bahnhofstrasse'
     */
    const VALUE_KLAGENFURT_BAHNHOFSTRASSE = 'Klagenfurt, Bahnhofstrasse';
    /**
     * Constant for value 'Klagenfurt, Fromillerstrasse'
     * @return string 'Klagenfurt, Fromillerstrasse'
     */
    const VALUE_KLAGENFURT_FROMILLERSTRASSE = 'Klagenfurt, Fromillerstrasse';
    /**
     * Constant for value 'Klagenfurt, Burggasse'
     * @return string 'Klagenfurt, Burggasse'
     */
    const VALUE_KLAGENFURT_BURGGASSE = 'Klagenfurt, Burggasse';
    /**
     * Constant for value 'Lienz'
     * @return string 'Lienz'
     */
    const VALUE_LIENZ = 'Lienz';
    /**
     * Constant for value 'Spittal/Drau'
     * @return string 'Spittal/Drau'
     */
    const VALUE_SPITTAL_DRAU = 'Spittal/Drau';
    /**
     * Constant for value 'St.Veit/Glan'
     * @return string 'St.Veit/Glan'
     */
    const VALUE_ST_VEIT_GLAN = 'St.Veit/Glan';
    /**
     * Constant for value 'Velden'
     * @return string 'Velden'
     */
    const VALUE_VELDEN = 'Velden';
    /**
     * Constant for value 'Villach'
     * @return string 'Villach'
     */
    const VALUE_VILLACH = 'Villach';
    /**
     * Constant for value 'Völkermarkt'
     * @return string 'Völkermarkt'
     */
    const VALUE_V_ÖLKERMARKT = 'Völkermarkt';
    /**
     * Constant for value 'Wolfsberg'
     * @return string 'Wolfsberg'
     */
    const VALUE_WOLFSBERG = 'Wolfsberg';
    /**
     * Constant for value 'ÖAMTC Kärnten'
     * @return string 'ÖAMTC Kärnten'
     */
    const VALUE_ÖAMTC_K_ÄRNTEN = 'ÖAMTC Kärnten';
    /**
     * Constant for value 'Unabhängige Vertriebe (KTN)'
     * @return string 'Unabhängige Vertriebe (KTN)'
     */
    const VALUE_UNABH_ÄNGIGE_VERTRIEBE_KTN = 'Unabhängige Vertriebe (KTN)';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SIMMERING
     * @uses self::VALUE_S_ÜD
     * @uses self::VALUE_VZ_LANDSTRASSE_LANDSTRA_ßER_HAUPTSTRASSE_153_155
     * @uses self::VALUE_ZENTRUM
     * @uses self::VALUE_ÖAMTC_WIEN
     * @uses self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_DIV_1_W
     * @uses self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_DIV_2_W
     * @uses self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_DIV_3_W
     * @uses self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_DIV_4_W
     * @uses self::VALUE_INNENDIENST_WIEN
     * @uses self::VALUE_WIEN_NORD
     * @uses self::VALUE_VG_HIETZING
     * @uses self::VALUE_DONAUFELDERHOF
     * @uses self::VALUE_FAVORITEN
     * @uses self::VALUE_FLORIDSDORF
     * @uses self::VALUE_AM_HOF_HM
     * @uses self::VALUE_AUGASSE
     * @uses self::VALUE_LANDSTRASSE_LANDSTRA_ßER_HAUPTSTRA_ßE_26_1_2_STOCK
     * @uses self::VALUE_MEISELSTRASSE
     * @uses self::VALUE_AMSTETTEN
     * @uses self::VALUE_BADEN
     * @uses self::VALUE_BRUCK_LEITHA_N_Ö
     * @uses self::VALUE_G_ÄNSERNDORF
     * @uses self::VALUE_GLOGGNITZ
     * @uses self::VALUE_GM_ÜND
     * @uses self::VALUE_GR_ENZERSDORF
     * @uses self::VALUE_HAAG
     * @uses self::VALUE_HOLLABRUNN
     * @uses self::VALUE_HORN
     * @uses self::VALUE_KLOSTERNEUBURG
     * @uses self::VALUE_KORNEUBURG
     * @uses self::VALUE_KREMS
     * @uses self::VALUE_LILIENFELD
     * @uses self::VALUE_MA_ENZERSDORF
     * @uses self::VALUE_MELK
     * @uses self::VALUE_MISTELBACH
     * @uses self::VALUE_NEUNKIRCHEN
     * @uses self::VALUE_PURKERSDORF
     * @uses self::VALUE_WIESELBURG
     * @uses self::VALUE_SCHWECHAT
     * @uses self::VALUE_ST_P_ÖLTEN
     * @uses self::VALUE_TULLN
     * @uses self::VALUE_WAIDHOFEN_THAYA
     * @uses self::VALUE_WAIDHOFEN_YBBS
     * @uses self::VALUE_WR_NEUSTADT
     * @uses self::VALUE_ZWETTL
     * @uses self::VALUE_ÖAMTC_NIEDER_ÖSTERREICH
     * @uses self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_N_Ö
     * @uses self::VALUE_INNENDIENST_N_Ö
     * @uses self::VALUE_AMSTETTEN_SPEZIALISTENVERTRIEB
     * @uses self::VALUE_TULLN_SPEZIALISTENVERTRIEB
     * @uses self::VALUE_MA_ENZERSDORF_SPEZIALISTENVERTRIEB
     * @uses self::VALUE_KREMS_SPEZIALISTENVERTRIEB
     * @uses self::VALUE_ST_P_ÖLTEN_SPEZIALISTENVERTRIEB
     * @uses self::VALUE_BAD_ISCHL
     * @uses self::VALUE_EFERDING
     * @uses self::VALUE_FREISTADT
     * @uses self::VALUE_GMUNDEN
     * @uses self::VALUE_GRIESKIRCHEN
     * @uses self::VALUE_KIRCHDORF
     * @uses self::VALUE_LINZ_STIFTERPLATZ
     * @uses self::VALUE_LINZ_UNIONSTR_AGENTURVERTRIEB_O_Ö
     * @uses self::VALUE_LINZ_URFAHR_UMGEBUNG
     * @uses self::VALUE_PERG
     * @uses self::VALUE_RIED
     * @uses self::VALUE_ROHRBACH
     * @uses self::VALUE_SCH_ÄRDING
     * @uses self::VALUE_STEYR
     * @uses self::VALUE_TRAUN
     * @uses self::VALUE_V_ÖCKLABRUCK
     * @uses self::VALUE_WELS
     * @uses self::VALUE_WINDISCHGARSTEN
     * @uses self::VALUE_ÖAMTC_OBER_ÖSTERREICH
     * @uses self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_O_Ö
     * @uses self::VALUE_INNENDIENST_O_Ö
     * @uses self::VALUE_BAD_HOFGASTEIN
     * @uses self::VALUE_BRAUNAU
     * @uses self::VALUE_HALLEIN
     * @uses self::VALUE_MATTIGHOFEN
     * @uses self::VALUE_MONDSEE
     * @uses self::VALUE_NEUMARKT_S
     * @uses self::VALUE_OBERNDORF
     * @uses self::VALUE_OSTERMIETHING
     * @uses self::VALUE_SAALFELDEN
     * @uses self::VALUE_SALZBURG_STADT
     * @uses self::VALUE_SEEKIRCHEN
     * @uses self::VALUE_ST_JOHANN
     * @uses self::VALUE_TAMSWEG
     * @uses self::VALUE_ZELL_AM_SEE
     * @uses self::VALUE_ÖAMTC_SALZBURG
     * @uses self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_S
     * @uses self::VALUE_AGENTUR_PARTNER_SERVICE_S
     * @uses self::VALUE_IMST
     * @uses self::VALUE_INNSBRUCK_GRABENWEG
     * @uses self::VALUE_INNSBRUCK_RENNWEG
     * @uses self::VALUE_KALTENBACH
     * @uses self::VALUE_KITZB_ÜHEL
     * @uses self::VALUE_KUFSTEIN
     * @uses self::VALUE_LANDECK
     * @uses self::VALUE_REUTTE
     * @uses self::VALUE_SCHWAZ
     * @uses self::VALUE_TELFS
     * @uses self::VALUE_W_ÖRGL
     * @uses self::VALUE_ÖAMTC_TIROL
     * @uses self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_T
     * @uses self::VALUE_BLUDENZ
     * @uses self::VALUE_BREGENZ
     * @uses self::VALUE_DORNBIRN
     * @uses self::VALUE_EGG
     * @uses self::VALUE_FELDKIRCH
     * @uses self::VALUE_G_ÖTZIS
     * @uses self::VALUE_ÖAMTC_VORARLBERG
     * @uses self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_VLBG
     * @uses self::VALUE_VOLZ
     * @uses self::VALUE_JENNERSDORF
     * @uses self::VALUE_MATTERSBURG
     * @uses self::VALUE_NEUSIEDL_SEE
     * @uses self::VALUE_OBERPULLENDORF
     * @uses self::VALUE_OBERWART
     * @uses self::VALUE_ÖAMTC_BURGENLAND
     * @uses self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_BGLD
     * @uses self::VALUE_BRUCK_LEITHA_BGLD
     * @uses self::VALUE_EISENSTADT
     * @uses self::VALUE_G_ÜSSING
     * @uses self::VALUE_BAD_AUSSEE
     * @uses self::VALUE_BRUCK_MUR
     * @uses self::VALUE_DEUTSCHLANDSBERG
     * @uses self::VALUE_EIBISWALD
     * @uses self::VALUE_GRAZ_WALTENDORFER_HAUPTSTRA_ßE_5
     * @uses self::VALUE_GRAZ_ARLAND
     * @uses self::VALUE_GRAZ_K_ÄRNTNERSTRA_ßE
     * @uses self::VALUE_GRAZ_JAKOMINI
     * @uses self::VALUE_FELDBACH
     * @uses self::VALUE_F_ÜRSTENFELD
     * @uses self::VALUE_GLEISDORF
     * @uses self::VALUE_GR_ÖBMING
     * @uses self::VALUE_HARTBERG
     * @uses self::VALUE_JUDENBURG
     * @uses self::VALUE_KAPFENBERG
     * @uses self::VALUE_KNITTELFELD
     * @uses self::VALUE_LEIBNITZ
     * @uses self::VALUE_LEOBEN
     * @uses self::VALUE_LIEZEN
     * @uses self::VALUE_MARIAZELL
     * @uses self::VALUE_MURAU
     * @uses self::VALUE_M_ÜRZZUSCHLAG
     * @uses self::VALUE_NEUMARKT_STMK
     * @uses self::VALUE_RADKERSBURG
     * @uses self::VALUE_ROSENTAL
     * @uses self::VALUE_WEIZ
     * @uses self::VALUE_ÖAMTC_STEIERMARK
     * @uses self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_STMK
     * @uses self::VALUE_INNENDIENST_STMK
     * @uses self::VALUE_GRAZ_LIEBENAU
     * @uses self::VALUE_FELDKIRCHEN
     * @uses self::VALUE_HERMAGOR
     * @uses self::VALUE_KLAGENFURT_BAHNHOFSTRASSE
     * @uses self::VALUE_KLAGENFURT_FROMILLERSTRASSE
     * @uses self::VALUE_KLAGENFURT_BURGGASSE
     * @uses self::VALUE_LIENZ
     * @uses self::VALUE_SPITTAL_DRAU
     * @uses self::VALUE_ST_VEIT_GLAN
     * @uses self::VALUE_VELDEN
     * @uses self::VALUE_VILLACH
     * @uses self::VALUE_V_ÖLKERMARKT
     * @uses self::VALUE_WOLFSBERG
     * @uses self::VALUE_ÖAMTC_K_ÄRNTEN
     * @uses self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_KTN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SIMMERING,
            self::VALUE_S_ÜD,
            self::VALUE_VZ_LANDSTRASSE_LANDSTRA_ßER_HAUPTSTRASSE_153_155,
            self::VALUE_ZENTRUM,
            self::VALUE_ÖAMTC_WIEN,
            self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_DIV_1_W,
            self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_DIV_2_W,
            self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_DIV_3_W,
            self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_DIV_4_W,
            self::VALUE_INNENDIENST_WIEN,
            self::VALUE_WIEN_NORD,
            self::VALUE_VG_HIETZING,
            self::VALUE_DONAUFELDERHOF,
            self::VALUE_FAVORITEN,
            self::VALUE_FLORIDSDORF,
            self::VALUE_AM_HOF_HM,
            self::VALUE_AUGASSE,
            self::VALUE_LANDSTRASSE_LANDSTRA_ßER_HAUPTSTRA_ßE_26_1_2_STOCK,
            self::VALUE_MEISELSTRASSE,
            self::VALUE_AMSTETTEN,
            self::VALUE_BADEN,
            self::VALUE_BRUCK_LEITHA_N_Ö,
            self::VALUE_G_ÄNSERNDORF,
            self::VALUE_GLOGGNITZ,
            self::VALUE_GM_ÜND,
            self::VALUE_GR_ENZERSDORF,
            self::VALUE_HAAG,
            self::VALUE_HOLLABRUNN,
            self::VALUE_HORN,
            self::VALUE_KLOSTERNEUBURG,
            self::VALUE_KORNEUBURG,
            self::VALUE_KREMS,
            self::VALUE_LILIENFELD,
            self::VALUE_MA_ENZERSDORF,
            self::VALUE_MELK,
            self::VALUE_MISTELBACH,
            self::VALUE_NEUNKIRCHEN,
            self::VALUE_PURKERSDORF,
            self::VALUE_WIESELBURG,
            self::VALUE_SCHWECHAT,
            self::VALUE_ST_P_ÖLTEN,
            self::VALUE_TULLN,
            self::VALUE_WAIDHOFEN_THAYA,
            self::VALUE_WAIDHOFEN_YBBS,
            self::VALUE_WR_NEUSTADT,
            self::VALUE_ZWETTL,
            self::VALUE_ÖAMTC_NIEDER_ÖSTERREICH,
            self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_N_Ö,
            self::VALUE_INNENDIENST_N_Ö,
            self::VALUE_AMSTETTEN_SPEZIALISTENVERTRIEB,
            self::VALUE_TULLN_SPEZIALISTENVERTRIEB,
            self::VALUE_MA_ENZERSDORF_SPEZIALISTENVERTRIEB,
            self::VALUE_KREMS_SPEZIALISTENVERTRIEB,
            self::VALUE_ST_P_ÖLTEN_SPEZIALISTENVERTRIEB,
            self::VALUE_BAD_ISCHL,
            self::VALUE_EFERDING,
            self::VALUE_FREISTADT,
            self::VALUE_GMUNDEN,
            self::VALUE_GRIESKIRCHEN,
            self::VALUE_KIRCHDORF,
            self::VALUE_LINZ_STIFTERPLATZ,
            self::VALUE_LINZ_UNIONSTR_AGENTURVERTRIEB_O_Ö,
            self::VALUE_LINZ_URFAHR_UMGEBUNG,
            self::VALUE_PERG,
            self::VALUE_RIED,
            self::VALUE_ROHRBACH,
            self::VALUE_SCH_ÄRDING,
            self::VALUE_STEYR,
            self::VALUE_TRAUN,
            self::VALUE_V_ÖCKLABRUCK,
            self::VALUE_WELS,
            self::VALUE_WINDISCHGARSTEN,
            self::VALUE_ÖAMTC_OBER_ÖSTERREICH,
            self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_O_Ö,
            self::VALUE_INNENDIENST_O_Ö,
            self::VALUE_BAD_HOFGASTEIN,
            self::VALUE_BRAUNAU,
            self::VALUE_HALLEIN,
            self::VALUE_MATTIGHOFEN,
            self::VALUE_MONDSEE,
            self::VALUE_NEUMARKT_S,
            self::VALUE_OBERNDORF,
            self::VALUE_OSTERMIETHING,
            self::VALUE_SAALFELDEN,
            self::VALUE_SALZBURG_STADT,
            self::VALUE_SEEKIRCHEN,
            self::VALUE_ST_JOHANN,
            self::VALUE_TAMSWEG,
            self::VALUE_ZELL_AM_SEE,
            self::VALUE_ÖAMTC_SALZBURG,
            self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_S,
            self::VALUE_AGENTUR_PARTNER_SERVICE_S,
            self::VALUE_IMST,
            self::VALUE_INNSBRUCK_GRABENWEG,
            self::VALUE_INNSBRUCK_RENNWEG,
            self::VALUE_KALTENBACH,
            self::VALUE_KITZB_ÜHEL,
            self::VALUE_KUFSTEIN,
            self::VALUE_LANDECK,
            self::VALUE_REUTTE,
            self::VALUE_SCHWAZ,
            self::VALUE_TELFS,
            self::VALUE_W_ÖRGL,
            self::VALUE_ÖAMTC_TIROL,
            self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_T,
            self::VALUE_BLUDENZ,
            self::VALUE_BREGENZ,
            self::VALUE_DORNBIRN,
            self::VALUE_EGG,
            self::VALUE_FELDKIRCH,
            self::VALUE_G_ÖTZIS,
            self::VALUE_ÖAMTC_VORARLBERG,
            self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_VLBG,
            self::VALUE_VOLZ,
            self::VALUE_JENNERSDORF,
            self::VALUE_MATTERSBURG,
            self::VALUE_NEUSIEDL_SEE,
            self::VALUE_OBERPULLENDORF,
            self::VALUE_OBERWART,
            self::VALUE_ÖAMTC_BURGENLAND,
            self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_BGLD,
            self::VALUE_BRUCK_LEITHA_BGLD,
            self::VALUE_EISENSTADT,
            self::VALUE_G_ÜSSING,
            self::VALUE_BAD_AUSSEE,
            self::VALUE_BRUCK_MUR,
            self::VALUE_DEUTSCHLANDSBERG,
            self::VALUE_EIBISWALD,
            self::VALUE_GRAZ_WALTENDORFER_HAUPTSTRA_ßE_5,
            self::VALUE_GRAZ_ARLAND,
            self::VALUE_GRAZ_K_ÄRNTNERSTRA_ßE,
            self::VALUE_GRAZ_JAKOMINI,
            self::VALUE_FELDBACH,
            self::VALUE_F_ÜRSTENFELD,
            self::VALUE_GLEISDORF,
            self::VALUE_GR_ÖBMING,
            self::VALUE_HARTBERG,
            self::VALUE_JUDENBURG,
            self::VALUE_KAPFENBERG,
            self::VALUE_KNITTELFELD,
            self::VALUE_LEIBNITZ,
            self::VALUE_LEOBEN,
            self::VALUE_LIEZEN,
            self::VALUE_MARIAZELL,
            self::VALUE_MURAU,
            self::VALUE_M_ÜRZZUSCHLAG,
            self::VALUE_NEUMARKT_STMK,
            self::VALUE_RADKERSBURG,
            self::VALUE_ROSENTAL,
            self::VALUE_WEIZ,
            self::VALUE_ÖAMTC_STEIERMARK,
            self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_STMK,
            self::VALUE_INNENDIENST_STMK,
            self::VALUE_GRAZ_LIEBENAU,
            self::VALUE_FELDKIRCHEN,
            self::VALUE_HERMAGOR,
            self::VALUE_KLAGENFURT_BAHNHOFSTRASSE,
            self::VALUE_KLAGENFURT_FROMILLERSTRASSE,
            self::VALUE_KLAGENFURT_BURGGASSE,
            self::VALUE_LIENZ,
            self::VALUE_SPITTAL_DRAU,
            self::VALUE_ST_VEIT_GLAN,
            self::VALUE_VELDEN,
            self::VALUE_VILLACH,
            self::VALUE_V_ÖLKERMARKT,
            self::VALUE_WOLFSBERG,
            self::VALUE_ÖAMTC_K_ÄRNTEN,
            self::VALUE_UNABH_ÄNGIGE_VERTRIEBE_KTN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
