<?php

namespace EnumType;

/**
 * This class stands for Fondskategorie EnumType
 * @subpackage Enumerations
 */
class Fondskategorie
{
    /**
     * Constant for value 'Garantiefondskonzept'
     * @return string 'Garantiefondskonzept'
     */
    const VALUE_GARANTIEFONDSKONZEPT = 'Garantiefondskonzept';
    /**
     * Constant for value 'GeringesRisiko'
     * @return string 'GeringesRisiko'
     */
    const VALUE_GERINGES_RISIKO = 'GeringesRisiko';
    /**
     * Constant for value 'MittleresRisiko'
     * @return string 'MittleresRisiko'
     */
    const VALUE_MITTLERES_RISIKO = 'MittleresRisiko';
    /**
     * Constant for value 'HohesRisiko'
     * @return string 'HohesRisiko'
     */
    const VALUE_HOHES_RISIKO = 'HohesRisiko';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GARANTIEFONDSKONZEPT
     * @uses self::VALUE_GERINGES_RISIKO
     * @uses self::VALUE_MITTLERES_RISIKO
     * @uses self::VALUE_HOHES_RISIKO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GARANTIEFONDSKONZEPT,
            self::VALUE_GERINGES_RISIKO,
            self::VALUE_MITTLERES_RISIKO,
            self::VALUE_HOHES_RISIKO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
