<?php

namespace EnumType;

/**
 * This class stands for ClaimType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Polizzennachspann
 * @subpackage Enumerations
 */
class ClaimType
{
    /**
     * Constant for value 'offen'
     * Meta information extracted from the WSDL
     * - id: claimtType_1
     * @return string 'offen'
     */
    const VALUE_OFFEN = 'offen';
    /**
     * Constant for value 'erledigt'
     * Meta information extracted from the WSDL
     * - id: claimtType_2
     * @return string 'erledigt'
     */
    const VALUE_ERLEDIGT = 'erledigt';
    /**
     * Constant for value 'storniert'
     * Meta information extracted from the WSDL
     * - id: claimtType_3
     * @return string 'storniert'
     */
    const VALUE_STORNIERT = 'storniert';
    /**
     * Constant for value 'reaktiviert'
     * Meta information extracted from the WSDL
     * - id: claimtType_4
     * @return string 'reaktiviert'
     */
    const VALUE_REAKTIVIERT = 'reaktiviert';
    /**
     * Constant for value 'regress offen'
     * Meta information extracted from the WSDL
     * - id: claimtType_5
     * @return string 'regress offen'
     */
    const VALUE_REGRESS_OFFEN = 'regress offen';
    /**
     * Constant for value 'umgebucht'
     * Meta information extracted from the WSDL
     * - id: claimtType_6
     * @return string 'umgebucht'
     */
    const VALUE_UMGEBUCHT = 'umgebucht';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OFFEN
     * @uses self::VALUE_ERLEDIGT
     * @uses self::VALUE_STORNIERT
     * @uses self::VALUE_REAKTIVIERT
     * @uses self::VALUE_REGRESS_OFFEN
     * @uses self::VALUE_UMGEBUCHT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OFFEN,
            self::VALUE_ERLEDIGT,
            self::VALUE_STORNIERT,
            self::VALUE_REAKTIVIERT,
            self::VALUE_REGRESS_OFFEN,
            self::VALUE_UMGEBUCHT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
