<?php

namespace EnumType;

/**
 * This class stands for ClaimCategory EnumType
 * Meta information extracted from the WSDL
 * - documentation: Schadensparte
 * @subpackage Enumerations
 */
class ClaimCategory
{
    /**
     * Constant for value 'Krankenversicherung ambulant'
     * @return string 'Krankenversicherung ambulant'
     */
    const VALUE_KRANKENVERSICHERUNG_AMBULANT = 'Krankenversicherung ambulant';
    /**
     * Constant for value 'Krankenversicherung stationär'
     * @return string 'Krankenversicherung stationär'
     */
    const VALUE_KRANKENVERSICHERUNG_STATION_ÄR = 'Krankenversicherung stationär';
    /**
     * Constant for value 'Feuer'
     * @return string 'Feuer'
     */
    const VALUE_FEUER = 'Feuer';
    /**
     * Constant for value 'Feuer BU-Zusatzversicherung'
     * @return string 'Feuer BU-Zusatzversicherung'
     */
    const VALUE_FEUER_BU_ZUSATZVERSICHERUNG = 'Feuer BU-Zusatzversicherung';
    /**
     * Constant for value 'Feuer BU-Fabrik'
     * @return string 'Feuer BU-Fabrik'
     */
    const VALUE_FEUER_BU_FABRIK = 'Feuer BU-Fabrik';
    /**
     * Constant for value '(Total)-Betriebsunterbrechung'
     * @return string '(Total)-Betriebsunterbrechung'
     */
    const VALUE_TOTAL_BETRIEBSUNTERBRECHUNG = '(Total)-Betriebsunterbrechung';
    /**
     * Constant for value 'Einbruchdiebstahl'
     * @return string 'Einbruchdiebstahl'
     */
    const VALUE_EINBRUCHDIEBSTAHL = 'Einbruchdiebstahl';
    /**
     * Constant for value 'Kassenbotenberaubung'
     * @return string 'Kassenbotenberaubung'
     */
    const VALUE_KASSENBOTENBERAUBUNG = 'Kassenbotenberaubung';
    /**
     * Constant for value 'Beraubung'
     * @return string 'Beraubung'
     */
    const VALUE_BERAUBUNG = 'Beraubung';
    /**
     * Constant for value 'Reise Assistent'
     * @return string 'Reise Assistent'
     */
    const VALUE_REISE_ASSISTENT = 'Reise Assistent';
    /**
     * Constant for value 'KFZ Assistent'
     * @return string 'KFZ Assistent'
     */
    const VALUE_KFZ_ASSISTENT = 'KFZ Assistent';
    /**
     * Constant for value 'Sach/Haft Assistent'
     * @return string 'Sach/Haft Assistent'
     */
    const VALUE_SACH_HAFT_ASSISTENT = 'Sach/Haft Assistent';
    /**
     * Constant for value 'Feuer aus Haushalt'
     * @return string 'Feuer aus Haushalt'
     */
    const VALUE_FEUER_AUS_HAUSHALT = 'Feuer aus Haushalt';
    /**
     * Constant for value 'Einbruch aus Haushalt'
     * @return string 'Einbruch aus Haushalt'
     */
    const VALUE_EINBRUCH_AUS_HAUSHALT = 'Einbruch aus Haushalt';
    /**
     * Constant for value 'Reisegepäck aus Haushalt'
     * @return string 'Reisegepäck aus Haushalt'
     */
    const VALUE_REISEGEP_ÄCK_AUS_HAUSHALT = 'Reisegepäck aus Haushalt';
    /**
     * Constant for value 'Kühlgut aus Haushalt'
     * @return string 'Kühlgut aus Haushalt'
     */
    const VALUE_K_ÜHLGUT_AUS_HAUSHALT = 'Kühlgut aus Haushalt';
    /**
     * Constant for value 'Sturm aus Haushalt'
     * @return string 'Sturm aus Haushalt'
     */
    const VALUE_STURM_AUS_HAUSHALT = 'Sturm aus Haushalt';
    /**
     * Constant for value 'Elektrogerätezusatz'
     * @return string 'Elektrogerätezusatz'
     */
    const VALUE_ELEKTROGER_ÄTEZUSATZ = 'Elektrogerätezusatz';
    /**
     * Constant for value 'Glas aus Haushalt'
     * @return string 'Glas aus Haushalt'
     */
    const VALUE_GLAS_AUS_HAUSHALT = 'Glas aus Haushalt';
    /**
     * Constant for value 'Leitungswasser aus Haushalt'
     * @return string 'Leitungswasser aus Haushalt'
     */
    const VALUE_LEITUNGSWASSER_AUS_HAUSHALT = 'Leitungswasser aus Haushalt';
    /**
     * Constant for value 'Haftpflicht aus Haushalt'
     * @return string 'Haftpflicht aus Haushalt'
     */
    const VALUE_HAFTPFLICHT_AUS_HAUSHALT = 'Haftpflicht aus Haushalt';
    /**
     * Constant for value 'Transport Pauschal'
     * @return string 'Transport Pauschal'
     */
    const VALUE_TRANSPORT_PAUSCHAL = 'Transport Pauschal';
    /**
     * Constant for value 'Reisegepäck'
     * @return string 'Reisegepäck'
     */
    const VALUE_REISEGEP_ÄCK = 'Reisegepäck';
    /**
     * Constant for value 'Glas'
     * @return string 'Glas'
     */
    const VALUE_GLAS = 'Glas';
    /**
     * Constant for value 'KFZ Haftpflicht'
     * @return string 'KFZ Haftpflicht'
     */
    const VALUE_KFZ_HAFTPFLICHT = 'KFZ Haftpflicht';
    /**
     * Constant for value 'Großschadenrisiko KFZ'
     * @return string 'Großschadenrisiko KFZ'
     */
    const VALUE_GRO_ßSCHADENRISIKO_KFZ = 'Großschadenrisiko KFZ';
    /**
     * Constant for value 'Kasko'
     * @return string 'Kasko'
     */
    const VALUE_KASKO = 'Kasko';
    /**
     * Constant for value 'Insassenunfall'
     * @return string 'Insassenunfall'
     */
    const VALUE_INSASSENUNFALL = 'Insassenunfall';
    /**
     * Constant for value 'Reparaturkosten-Versicherung'
     * @return string 'Reparaturkosten-Versicherung'
     */
    const VALUE_REPARATURKOSTEN_VERSICHERUNG = 'Reparaturkosten-Versicherung';
    /**
     * Constant for value 'KFZ Europa Zusatzschutz'
     * @return string 'KFZ Europa Zusatzschutz'
     */
    const VALUE_KFZ_EUROPA_ZUSATZSCHUTZ = 'KFZ Europa Zusatzschutz';
    /**
     * Constant for value 'Kühlgut'
     * @return string 'Kühlgut'
     */
    const VALUE_K_ÜHLGUT = 'Kühlgut';
    /**
     * Constant for value 'Leitungswasser'
     * @return string 'Leitungswasser'
     */
    const VALUE_LEITUNGSWASSER = 'Leitungswasser';
    /**
     * Constant for value 'Hochwasser'
     * @return string 'Hochwasser'
     */
    const VALUE_HOCHWASSER = 'Hochwasser';
    /**
     * Constant for value 'Sturm'
     * @return string 'Sturm'
     */
    const VALUE_STURM = 'Sturm';
    /**
     * Constant for value 'Bauwesen'
     * @return string 'Bauwesen'
     */
    const VALUE_BAUWESEN = 'Bauwesen';
    /**
     * Constant for value 'Rechtsschutz'
     * @return string 'Rechtsschutz'
     */
    const VALUE_RECHTSSCHUTZ = 'Rechtsschutz';
    /**
     * Constant for value 'Elektronik'
     * @return string 'Elektronik'
     */
    const VALUE_ELEKTRONIK = 'Elektronik';
    /**
     * Constant for value 'Veruntreuung Schmuck Pelz'
     * @return string 'Veruntreuung Schmuck Pelz'
     */
    const VALUE_VERUNTREUUNG_SCHMUCK_PELZ = 'Veruntreuung Schmuck Pelz';
    /**
     * Constant for value 'Unfall mit Prämienrückgewähr (UPR)'
     * @return string 'Unfall mit Prämienrückgewähr (UPR)'
     */
    const VALUE_UNFALL_MIT_PR_ÄMIENR_ÜCKGEW_ÄHR_UPR = 'Unfall mit Prämienrückgewähr (UPR)';
    /**
     * Constant for value 'Einzelunfall/Kollektivunfall'
     * @return string 'Einzelunfall/Kollektivunfall'
     */
    const VALUE_EINZELUNFALL_KOLLEKTIVUNFALL = 'Einzelunfall/Kollektivunfall';
    /**
     * Constant for value 'Maschinenbruch'
     * @return string 'Maschinenbruch'
     */
    const VALUE_MASCHINENBRUCH = 'Maschinenbruch';
    /**
     * Constant for value 'Maschinen-Betriebsunterbrechung'
     * @return string 'Maschinen-Betriebsunterbrechung'
     */
    const VALUE_MASCHINEN_BETRIEBSUNTERBRECHUNG = 'Maschinen-Betriebsunterbrechung';
    /**
     * Constant for value 'Maschinen-Montageversicherung'
     * @return string 'Maschinen-Montageversicherung'
     */
    const VALUE_MASCHINEN_MONTAGEVERSICHERUNG = 'Maschinen-Montageversicherung';
    /**
     * Constant for value 'Haftpflicht'
     * @return string 'Haftpflicht'
     */
    const VALUE_HAFTPFLICHT = 'Haftpflicht';
    /**
     * Constant for value 'BU für freiberuflich u. selbständig Erwerbstätige'
     * @return string 'BU für freiberuflich u. selbständig Erwerbstätige'
     */
    const VALUE_BU_F_ÜR_FREIBERUFLICH_U_SELBST_ÄNDIG_ERWERBST_ÄTIGE = 'BU für freiberuflich u. selbständig Erwerbstätige';
    /**
     * Constant for value 'Transport'
     * @return string 'Transport'
     */
    const VALUE_TRANSPORT = 'Transport';
    /**
     * Constant for value 'Einzeltransport'
     * @return string 'Einzeltransport'
     */
    const VALUE_EINZELTRANSPORT = 'Einzeltransport';
    /**
     * Constant for value 'Güterdeckung Transport'
     * @return string 'Güterdeckung Transport'
     */
    const VALUE_G_ÜTERDECKUNG_TRANSPORT = 'Güterdeckung Transport';
    /**
     * Constant for value 'Reise-Unfall-Versicherung'
     * @return string 'Reise-Unfall-Versicherung'
     */
    const VALUE_REISE_UNFALL_VERSICHERUNG = 'Reise-Unfall-Versicherung';
    /**
     * Constant for value 'Reise-Kranken-Versicherung'
     * @return string 'Reise-Kranken-Versicherung'
     */
    const VALUE_REISE_KRANKEN_VERSICHERUNG = 'Reise-Kranken-Versicherung';
    /**
     * Constant for value 'Reise-Storno-Versicherung'
     * @return string 'Reise-Storno-Versicherung'
     */
    const VALUE_REISE_STORNO_VERSICHERUNG = 'Reise-Storno-Versicherung';
    /**
     * Constant for value 'Reise-Assistance-Versicherung'
     * @return string 'Reise-Assistance-Versicherung'
     */
    const VALUE_REISE_ASSISTANCE_VERSICHERUNG = 'Reise-Assistance-Versicherung';
    /**
     * Constant for value 'Reise-Gepäck-Versicherung'
     * @return string 'Reise-Gepäck-Versicherung'
     */
    const VALUE_REISE_GEP_ÄCK_VERSICHERUNG = 'Reise-Gepäck-Versicherung';
    /**
     * Constant for value 'Schiffskasko'
     * @return string 'Schiffskasko'
     */
    const VALUE_SCHIFFSKASKO = 'Schiffskasko';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KRANKENVERSICHERUNG_AMBULANT
     * @uses self::VALUE_KRANKENVERSICHERUNG_STATION_ÄR
     * @uses self::VALUE_FEUER
     * @uses self::VALUE_FEUER_BU_ZUSATZVERSICHERUNG
     * @uses self::VALUE_FEUER_BU_FABRIK
     * @uses self::VALUE_TOTAL_BETRIEBSUNTERBRECHUNG
     * @uses self::VALUE_EINBRUCHDIEBSTAHL
     * @uses self::VALUE_KASSENBOTENBERAUBUNG
     * @uses self::VALUE_BERAUBUNG
     * @uses self::VALUE_REISE_ASSISTENT
     * @uses self::VALUE_KFZ_ASSISTENT
     * @uses self::VALUE_SACH_HAFT_ASSISTENT
     * @uses self::VALUE_FEUER_AUS_HAUSHALT
     * @uses self::VALUE_EINBRUCH_AUS_HAUSHALT
     * @uses self::VALUE_REISEGEP_ÄCK_AUS_HAUSHALT
     * @uses self::VALUE_K_ÜHLGUT_AUS_HAUSHALT
     * @uses self::VALUE_STURM_AUS_HAUSHALT
     * @uses self::VALUE_ELEKTROGER_ÄTEZUSATZ
     * @uses self::VALUE_GLAS_AUS_HAUSHALT
     * @uses self::VALUE_LEITUNGSWASSER_AUS_HAUSHALT
     * @uses self::VALUE_HAFTPFLICHT_AUS_HAUSHALT
     * @uses self::VALUE_TRANSPORT_PAUSCHAL
     * @uses self::VALUE_REISEGEP_ÄCK
     * @uses self::VALUE_GLAS
     * @uses self::VALUE_KFZ_HAFTPFLICHT
     * @uses self::VALUE_GRO_ßSCHADENRISIKO_KFZ
     * @uses self::VALUE_KASKO
     * @uses self::VALUE_INSASSENUNFALL
     * @uses self::VALUE_REPARATURKOSTEN_VERSICHERUNG
     * @uses self::VALUE_KFZ_EUROPA_ZUSATZSCHUTZ
     * @uses self::VALUE_K_ÜHLGUT
     * @uses self::VALUE_LEITUNGSWASSER
     * @uses self::VALUE_HOCHWASSER
     * @uses self::VALUE_STURM
     * @uses self::VALUE_BAUWESEN
     * @uses self::VALUE_RECHTSSCHUTZ
     * @uses self::VALUE_ELEKTRONIK
     * @uses self::VALUE_VERUNTREUUNG_SCHMUCK_PELZ
     * @uses self::VALUE_UNFALL_MIT_PR_ÄMIENR_ÜCKGEW_ÄHR_UPR
     * @uses self::VALUE_EINZELUNFALL_KOLLEKTIVUNFALL
     * @uses self::VALUE_MASCHINENBRUCH
     * @uses self::VALUE_MASCHINEN_BETRIEBSUNTERBRECHUNG
     * @uses self::VALUE_MASCHINEN_MONTAGEVERSICHERUNG
     * @uses self::VALUE_HAFTPFLICHT
     * @uses self::VALUE_BU_F_ÜR_FREIBERUFLICH_U_SELBST_ÄNDIG_ERWERBST_ÄTIGE
     * @uses self::VALUE_TRANSPORT
     * @uses self::VALUE_EINZELTRANSPORT
     * @uses self::VALUE_G_ÜTERDECKUNG_TRANSPORT
     * @uses self::VALUE_REISE_UNFALL_VERSICHERUNG
     * @uses self::VALUE_REISE_KRANKEN_VERSICHERUNG
     * @uses self::VALUE_REISE_STORNO_VERSICHERUNG
     * @uses self::VALUE_REISE_ASSISTANCE_VERSICHERUNG
     * @uses self::VALUE_REISE_GEP_ÄCK_VERSICHERUNG
     * @uses self::VALUE_SCHIFFSKASKO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KRANKENVERSICHERUNG_AMBULANT,
            self::VALUE_KRANKENVERSICHERUNG_STATION_ÄR,
            self::VALUE_FEUER,
            self::VALUE_FEUER_BU_ZUSATZVERSICHERUNG,
            self::VALUE_FEUER_BU_FABRIK,
            self::VALUE_TOTAL_BETRIEBSUNTERBRECHUNG,
            self::VALUE_EINBRUCHDIEBSTAHL,
            self::VALUE_KASSENBOTENBERAUBUNG,
            self::VALUE_BERAUBUNG,
            self::VALUE_REISE_ASSISTENT,
            self::VALUE_KFZ_ASSISTENT,
            self::VALUE_SACH_HAFT_ASSISTENT,
            self::VALUE_FEUER_AUS_HAUSHALT,
            self::VALUE_EINBRUCH_AUS_HAUSHALT,
            self::VALUE_REISEGEP_ÄCK_AUS_HAUSHALT,
            self::VALUE_K_ÜHLGUT_AUS_HAUSHALT,
            self::VALUE_STURM_AUS_HAUSHALT,
            self::VALUE_ELEKTROGER_ÄTEZUSATZ,
            self::VALUE_GLAS_AUS_HAUSHALT,
            self::VALUE_LEITUNGSWASSER_AUS_HAUSHALT,
            self::VALUE_HAFTPFLICHT_AUS_HAUSHALT,
            self::VALUE_TRANSPORT_PAUSCHAL,
            self::VALUE_REISEGEP_ÄCK,
            self::VALUE_GLAS,
            self::VALUE_KFZ_HAFTPFLICHT,
            self::VALUE_GRO_ßSCHADENRISIKO_KFZ,
            self::VALUE_KASKO,
            self::VALUE_INSASSENUNFALL,
            self::VALUE_REPARATURKOSTEN_VERSICHERUNG,
            self::VALUE_KFZ_EUROPA_ZUSATZSCHUTZ,
            self::VALUE_K_ÜHLGUT,
            self::VALUE_LEITUNGSWASSER,
            self::VALUE_HOCHWASSER,
            self::VALUE_STURM,
            self::VALUE_BAUWESEN,
            self::VALUE_RECHTSSCHUTZ,
            self::VALUE_ELEKTRONIK,
            self::VALUE_VERUNTREUUNG_SCHMUCK_PELZ,
            self::VALUE_UNFALL_MIT_PR_ÄMIENR_ÜCKGEW_ÄHR_UPR,
            self::VALUE_EINZELUNFALL_KOLLEKTIVUNFALL,
            self::VALUE_MASCHINENBRUCH,
            self::VALUE_MASCHINEN_BETRIEBSUNTERBRECHUNG,
            self::VALUE_MASCHINEN_MONTAGEVERSICHERUNG,
            self::VALUE_HAFTPFLICHT,
            self::VALUE_BU_F_ÜR_FREIBERUFLICH_U_SELBST_ÄNDIG_ERWERBST_ÄTIGE,
            self::VALUE_TRANSPORT,
            self::VALUE_EINZELTRANSPORT,
            self::VALUE_G_ÜTERDECKUNG_TRANSPORT,
            self::VALUE_REISE_UNFALL_VERSICHERUNG,
            self::VALUE_REISE_KRANKEN_VERSICHERUNG,
            self::VALUE_REISE_STORNO_VERSICHERUNG,
            self::VALUE_REISE_ASSISTANCE_VERSICHERUNG,
            self::VALUE_REISE_GEP_ÄCK_VERSICHERUNG,
            self::VALUE_SCHIFFSKASKO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
