<?php

namespace EnumType;

/**
 * This class stands for BerechnungsbasisType EnumType
 * @subpackage Enumerations
 */
class BerechnungsbasisType
{
    /**
     * Constant for value 'praemie'
     * Meta information extracted from the WSDL
     * - documentation: Generali vpms: value="0"
     * @return string 'praemie'
     */
    const VALUE_PRAEMIE = 'praemie';
    /**
     * Constant for value 'versicherungssumme'
     * Meta information extracted from the WSDL
     * - documentation: Generali vpms: value="1"
     * @return string 'versicherungssumme'
     */
    const VALUE_VERSICHERUNGSSUMME = 'versicherungssumme';
    /**
     * Constant for value 'gesamtrente'
     * Meta information extracted from the WSDL
     * - documentation: Generali vpms: value="3"
     * @return string 'gesamtrente'
     */
    const VALUE_GESAMTRENTE = 'gesamtrente';
    /**
     * Constant for value 'erlebensAuszahlungsbetrag'
     * Meta information extracted from the WSDL
     * - documentation: Generali vpms: value="6"
     * @return string 'erlebensAuszahlungsbetrag'
     */
    const VALUE_ERLEBENS_AUSZAHLUNGSBETRAG = 'erlebensAuszahlungsbetrag';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRAEMIE
     * @uses self::VALUE_VERSICHERUNGSSUMME
     * @uses self::VALUE_GESAMTRENTE
     * @uses self::VALUE_ERLEBENS_AUSZAHLUNGSBETRAG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRAEMIE,
            self::VALUE_VERSICHERUNGSSUMME,
            self::VALUE_GESAMTRENTE,
            self::VALUE_ERLEBENS_AUSZAHLUNGSBETRAG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
