<?php

namespace EnumType;

/**
 * This class stands for bauartType EnumType
 * @subpackage Enumerations
 */
class BauartType
{
    /**
     * Constant for value 'Cabriolet'
     * @return string 'Cabriolet'
     */
    const VALUE_CABRIOLET = 'Cabriolet';
    /**
     * Constant for value 'Coupe'
     * @return string 'Coupe'
     */
    const VALUE_COUPE = 'Coupe';
    /**
     * Constant for value 'Limousine'
     * @return string 'Limousine'
     */
    const VALUE_LIMOUSINE = 'Limousine';
    /**
     * Constant for value 'Roadster'
     * @return string 'Roadster'
     */
    const VALUE_ROADSTER = 'Roadster';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CABRIOLET
     * @uses self::VALUE_COUPE
     * @uses self::VALUE_LIMOUSINE
     * @uses self::VALUE_ROADSTER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CABRIOLET,
            self::VALUE_COUPE,
            self::VALUE_LIMOUSINE,
            self::VALUE_ROADSTER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
