<?php

namespace EnumType;

/**
 * This class stands for aufloesungsgrund EnumType
 * @subpackage Enumerations
 */
class Aufloesungsgrund
{
    /**
     * Constant for value 'aus Schaden'
     * @return string 'aus Schaden'
     */
    const VALUE_AUS_SCHADEN = 'aus Schaden';
    /**
     * Constant for value 'durch einvernehmliche Kündigung'
     * @return string 'durch einvernehmliche Kündigung'
     */
    const VALUE_DURCH_EINVERNEHMLICHE_K_ÜNDIGUNG = 'durch einvernehmliche Kündigung';
    /**
     * Constant for value 'durch Ablauf'
     * @return string 'durch Ablauf'
     */
    const VALUE_DURCH_ABLAUF = 'durch Ablauf';
    /**
     * Constant for value 'durch Besitzwechsel'
     * @return string 'durch Besitzwechsel'
     */
    const VALUE_DURCH_BESITZWECHSEL = 'durch Besitzwechsel';
    /**
     * Constant for value 'aus sonstigen Gründen'
     * @return string 'aus sonstigen Gründen'
     */
    const VALUE_AUS_SONSTIGEN_GR_ÜNDEN = 'aus sonstigen Gründen';
    /**
     * Constant for value 'zum Ablauf gekündigte Vorversicherung'
     * @return string 'zum Ablauf gekündigte Vorversicherung'
     */
    const VALUE_ZUM_ABLAUF_GEK_ÜNDIGTE_VORVERSICHERUNG = 'zum Ablauf gekündigte Vorversicherung';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AUS_SCHADEN
     * @uses self::VALUE_DURCH_EINVERNEHMLICHE_K_ÜNDIGUNG
     * @uses self::VALUE_DURCH_ABLAUF
     * @uses self::VALUE_DURCH_BESITZWECHSEL
     * @uses self::VALUE_AUS_SONSTIGEN_GR_ÜNDEN
     * @uses self::VALUE_ZUM_ABLAUF_GEK_ÜNDIGTE_VORVERSICHERUNG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AUS_SCHADEN,
            self::VALUE_DURCH_EINVERNEHMLICHE_K_ÜNDIGUNG,
            self::VALUE_DURCH_ABLAUF,
            self::VALUE_DURCH_BESITZWECHSEL,
            self::VALUE_AUS_SONSTIGEN_GR_ÜNDEN,
            self::VALUE_ZUM_ABLAUF_GEK_ÜNDIGTE_VORVERSICHERUNG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
