<?php

namespace EnumType;

/**
 * This class stands for antriebsartType EnumType
 * @subpackage Enumerations
 */
class AntriebsartType
{
    /**
     * Constant for value 'Benzin ohne Katalysator'
     * @return string 'Benzin ohne Katalysator'
     */
    const VALUE_BENZIN_OHNE_KATALYSATOR = 'Benzin ohne Katalysator';
    /**
     * Constant for value 'Gas'
     * @return string 'Gas'
     */
    const VALUE_GAS = 'Gas';
    /**
     * Constant for value 'Diesel'
     * @return string 'Diesel'
     */
    const VALUE_DIESEL = 'Diesel';
    /**
     * Constant for value 'Benzin mit Katalysator'
     * @return string 'Benzin mit Katalysator'
     */
    const VALUE_BENZIN_MIT_KATALYSATOR = 'Benzin mit Katalysator';
    /**
     * Constant for value 'Elektroantrieb'
     * @return string 'Elektroantrieb'
     */
    const VALUE_ELEKTROANTRIEB = 'Elektroantrieb';
    /**
     * Constant for value 'Diesel mit Katalysator'
     * @return string 'Diesel mit Katalysator'
     */
    const VALUE_DIESEL_MIT_KATALYSATOR = 'Diesel mit Katalysator';
    /**
     * Constant for value 'Kombinierter Betrieb Benzin/Elektro'
     * @return string 'Kombinierter Betrieb Benzin/Elektro'
     */
    const VALUE_KOMBINIERTER_BETRIEB_BENZIN_ELEKTRO = 'Kombinierter Betrieb Benzin/Elektro';
    /**
     * Constant for value 'Kombinierter Betrieb Diesel/Elektro'
     * @return string 'Kombinierter Betrieb Diesel/Elektro'
     */
    const VALUE_KOMBINIERTER_BETRIEB_DIESEL_ELEKTRO = 'Kombinierter Betrieb Diesel/Elektro';
    /**
     * Constant for value 'sonstige'
     * @return string 'sonstige'
     */
    const VALUE_SONSTIGE = 'sonstige';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BENZIN_OHNE_KATALYSATOR
     * @uses self::VALUE_GAS
     * @uses self::VALUE_DIESEL
     * @uses self::VALUE_BENZIN_MIT_KATALYSATOR
     * @uses self::VALUE_ELEKTROANTRIEB
     * @uses self::VALUE_DIESEL_MIT_KATALYSATOR
     * @uses self::VALUE_KOMBINIERTER_BETRIEB_BENZIN_ELEKTRO
     * @uses self::VALUE_KOMBINIERTER_BETRIEB_DIESEL_ELEKTRO
     * @uses self::VALUE_SONSTIGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BENZIN_OHNE_KATALYSATOR,
            self::VALUE_GAS,
            self::VALUE_DIESEL,
            self::VALUE_BENZIN_MIT_KATALYSATOR,
            self::VALUE_ELEKTROANTRIEB,
            self::VALUE_DIESEL_MIT_KATALYSATOR,
            self::VALUE_KOMBINIERTER_BETRIEB_BENZIN_ELEKTRO,
            self::VALUE_KOMBINIERTER_BETRIEB_DIESEL_ELEKTRO,
            self::VALUE_SONSTIGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
