<?php

namespace EnumType;

/**
 * This class stands for akkubewertungType EnumType
 * @subpackage Enumerations
 */
class AkkubewertungType
{
    /**
     * Constant for value 'Akku mitversichert (im Fahrzeugwert enthalten)'
     * @return string 'Akku mitversichert (im Fahrzeugwert enthalten)'
     */
    const VALUE_AKKU_MITVERSICHERT_IM_FAHRZEUGWERT_ENTHALTEN = 'Akku mitversichert (im Fahrzeugwert enthalten)';
    /**
     * Constant for value 'Akku mitversichert (im Fahrzeugwert nicht enthalten)'
     * @return string 'Akku mitversichert (im Fahrzeugwert nicht enthalten)'
     */
    const VALUE_AKKU_MITVERSICHERT_IM_FAHRZEUGWERT_NICHT_ENTHALTEN = 'Akku mitversichert (im Fahrzeugwert nicht enthalten)';
    /**
     * Constant for value 'Akku nicht mitversichert'
     * @return string 'Akku nicht mitversichert'
     */
    const VALUE_AKKU_NICHT_MITVERSICHERT = 'Akku nicht mitversichert';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AKKU_MITVERSICHERT_IM_FAHRZEUGWERT_ENTHALTEN
     * @uses self::VALUE_AKKU_MITVERSICHERT_IM_FAHRZEUGWERT_NICHT_ENTHALTEN
     * @uses self::VALUE_AKKU_NICHT_MITVERSICHERT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AKKU_MITVERSICHERT_IM_FAHRZEUGWERT_ENTHALTEN,
            self::VALUE_AKKU_MITVERSICHERT_IM_FAHRZEUGWERT_NICHT_ENTHALTEN,
            self::VALUE_AKKU_NICHT_MITVERSICHERT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
