<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZeusCar StructType
 * Meta information extracted from the WSDL
 * - documentation: Car from Zeus
 * @subpackage Structs
 */
class ZeusCar extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: name of the car holder
     * @var string
     */
    public $name;
    /**
     * The typeOfCar
     * Meta information extracted from the WSDL
     * - documentation: type/model of the car
     * @var string
     */
    public $typeOfCar;
    /**
     * The licencePlate
     * Meta information extracted from the WSDL
     * - documentation: licence number of the car
     * @var string
     */
    public $licencePlate;
    /**
     * The vbNumber
     * Meta information extracted from the WSDL
     * - documentation: vb number of the car
     * @var string
     */
    public $vbNumber;
    /**
     * The carSerialNumber
     * Meta information extracted from the WSDL
     * - documentation: serial number of the car
     * @var string
     */
    public $carSerialNumber;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - documentation: date
     * @var string
     */
    public $date;
    /**
     * The file
     * Meta information extracted from the WSDL
     * - documentation: the zeuscar file
     * - minOccurs: 0
     * @var \StructType\ZeusCarFileData
     */
    public $file;
    /**
     * Constructor method for ZeusCar
     * @uses ZeusCar::setName()
     * @uses ZeusCar::setTypeOfCar()
     * @uses ZeusCar::setLicencePlate()
     * @uses ZeusCar::setVbNumber()
     * @uses ZeusCar::setCarSerialNumber()
     * @uses ZeusCar::setDate()
     * @uses ZeusCar::setFile()
     * @param string $name
     * @param string $typeOfCar
     * @param string $licencePlate
     * @param string $vbNumber
     * @param string $carSerialNumber
     * @param string $date
     * @param \StructType\ZeusCarFileData $file
     */
    public function __construct($name = null, $typeOfCar = null, $licencePlate = null, $vbNumber = null, $carSerialNumber = null, $date = null, \StructType\ZeusCarFileData $file = null)
    {
        $this
            ->setName($name)
            ->setTypeOfCar($typeOfCar)
            ->setLicencePlate($licencePlate)
            ->setVbNumber($vbNumber)
            ->setCarSerialNumber($carSerialNumber)
            ->setDate($date)
            ->setFile($file);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ZeusCar
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get typeOfCar value
     * @return string|null
     */
    public function getTypeOfCar()
    {
        return $this->typeOfCar;
    }
    /**
     * Set typeOfCar value
     * @param string $typeOfCar
     * @return \StructType\ZeusCar
     */
    public function setTypeOfCar($typeOfCar = null)
    {
        // validation for constraint: string
        if (!is_null($typeOfCar) && !is_string($typeOfCar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeOfCar, true), gettype($typeOfCar)), __LINE__);
        }
        $this->typeOfCar = $typeOfCar;
        return $this;
    }
    /**
     * Get licencePlate value
     * @return string|null
     */
    public function getLicencePlate()
    {
        return $this->licencePlate;
    }
    /**
     * Set licencePlate value
     * @param string $licencePlate
     * @return \StructType\ZeusCar
     */
    public function setLicencePlate($licencePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licencePlate) && !is_string($licencePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licencePlate, true), gettype($licencePlate)), __LINE__);
        }
        $this->licencePlate = $licencePlate;
        return $this;
    }
    /**
     * Get vbNumber value
     * @return string|null
     */
    public function getVbNumber()
    {
        return $this->vbNumber;
    }
    /**
     * Set vbNumber value
     * @param string $vbNumber
     * @return \StructType\ZeusCar
     */
    public function setVbNumber($vbNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vbNumber) && !is_string($vbNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vbNumber, true), gettype($vbNumber)), __LINE__);
        }
        $this->vbNumber = $vbNumber;
        return $this;
    }
    /**
     * Get carSerialNumber value
     * @return string|null
     */
    public function getCarSerialNumber()
    {
        return $this->carSerialNumber;
    }
    /**
     * Set carSerialNumber value
     * @param string $carSerialNumber
     * @return \StructType\ZeusCar
     */
    public function setCarSerialNumber($carSerialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($carSerialNumber) && !is_string($carSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carSerialNumber, true), gettype($carSerialNumber)), __LINE__);
        }
        $this->carSerialNumber = $carSerialNumber;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\ZeusCar
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get file value
     * @return \StructType\ZeusCarFileData|null
     */
    public function getFile()
    {
        return $this->file;
    }
    /**
     * Set file value
     * @param \StructType\ZeusCarFileData $file
     * @return \StructType\ZeusCar
     */
    public function setFile(\StructType\ZeusCarFileData $file = null)
    {
        $this->file = $file;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ZeusCar
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
