<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vinkularglaeubigerType StructType
 * @subpackage Structs
 */
class VinkularglaeubigerType extends AbstractStructBase
{
    /**
     * The vertragsnummer
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $vertragsnummer;
    /**
     * The vinkularglaeubigerBank
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 100
     * - minLength: 2
     * @var string
     */
    public $vinkularglaeubigerBank;
    /**
     * The vinkularglaeubigerPlz
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 5
     * - minLength: 4
     * @var string
     */
    public $vinkularglaeubigerPlz;
    /**
     * The vinkularglaeubigerStrasse
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 100
     * - minLength: 3
     * - minOccurs: 0
     * @var string
     */
    public $vinkularglaeubigerStrasse;
    /**
     * Constructor method for vinkularglaeubigerType
     * @uses VinkularglaeubigerType::setVertragsnummer()
     * @uses VinkularglaeubigerType::setVinkularglaeubigerBank()
     * @uses VinkularglaeubigerType::setVinkularglaeubigerPlz()
     * @uses VinkularglaeubigerType::setVinkularglaeubigerStrasse()
     * @param string $vertragsnummer
     * @param string $vinkularglaeubigerBank
     * @param string $vinkularglaeubigerPlz
     * @param string $vinkularglaeubigerStrasse
     */
    public function __construct($vertragsnummer = null, $vinkularglaeubigerBank = null, $vinkularglaeubigerPlz = null, $vinkularglaeubigerStrasse = null)
    {
        $this
            ->setVertragsnummer($vertragsnummer)
            ->setVinkularglaeubigerBank($vinkularglaeubigerBank)
            ->setVinkularglaeubigerPlz($vinkularglaeubigerPlz)
            ->setVinkularglaeubigerStrasse($vinkularglaeubigerStrasse);
    }
    /**
     * Get vertragsnummer value
     * @return string|null
     */
    public function getVertragsnummer()
    {
        return $this->vertragsnummer;
    }
    /**
     * Set vertragsnummer value
     * @param string $vertragsnummer
     * @return \StructType\VinkularglaeubigerType
     */
    public function setVertragsnummer($vertragsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($vertragsnummer) && !is_string($vertragsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vertragsnummer, true), gettype($vertragsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($vertragsnummer) && mb_strlen($vertragsnummer) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($vertragsnummer)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vertragsnummer) && mb_strlen($vertragsnummer) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vertragsnummer)), __LINE__);
        }
        $this->vertragsnummer = $vertragsnummer;
        return $this;
    }
    /**
     * Get vinkularglaeubigerBank value
     * @return string|null
     */
    public function getVinkularglaeubigerBank()
    {
        return $this->vinkularglaeubigerBank;
    }
    /**
     * Set vinkularglaeubigerBank value
     * @param string $vinkularglaeubigerBank
     * @return \StructType\VinkularglaeubigerType
     */
    public function setVinkularglaeubigerBank($vinkularglaeubigerBank = null)
    {
        // validation for constraint: string
        if (!is_null($vinkularglaeubigerBank) && !is_string($vinkularglaeubigerBank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vinkularglaeubigerBank, true), gettype($vinkularglaeubigerBank)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($vinkularglaeubigerBank) && mb_strlen($vinkularglaeubigerBank) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($vinkularglaeubigerBank)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($vinkularglaeubigerBank) && mb_strlen($vinkularglaeubigerBank) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($vinkularglaeubigerBank)), __LINE__);
        }
        $this->vinkularglaeubigerBank = $vinkularglaeubigerBank;
        return $this;
    }
    /**
     * Get vinkularglaeubigerPlz value
     * @return string|null
     */
    public function getVinkularglaeubigerPlz()
    {
        return $this->vinkularglaeubigerPlz;
    }
    /**
     * Set vinkularglaeubigerPlz value
     * @param string $vinkularglaeubigerPlz
     * @return \StructType\VinkularglaeubigerType
     */
    public function setVinkularglaeubigerPlz($vinkularglaeubigerPlz = null)
    {
        // validation for constraint: string
        if (!is_null($vinkularglaeubigerPlz) && !is_string($vinkularglaeubigerPlz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vinkularglaeubigerPlz, true), gettype($vinkularglaeubigerPlz)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($vinkularglaeubigerPlz) && mb_strlen($vinkularglaeubigerPlz) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($vinkularglaeubigerPlz)), __LINE__);
        }
        // validation for constraint: minLength(4)
        if (!is_null($vinkularglaeubigerPlz) && mb_strlen($vinkularglaeubigerPlz) < 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 4', mb_strlen($vinkularglaeubigerPlz)), __LINE__);
        }
        $this->vinkularglaeubigerPlz = $vinkularglaeubigerPlz;
        return $this;
    }
    /**
     * Get vinkularglaeubigerStrasse value
     * @return string|null
     */
    public function getVinkularglaeubigerStrasse()
    {
        return $this->vinkularglaeubigerStrasse;
    }
    /**
     * Set vinkularglaeubigerStrasse value
     * @param string $vinkularglaeubigerStrasse
     * @return \StructType\VinkularglaeubigerType
     */
    public function setVinkularglaeubigerStrasse($vinkularglaeubigerStrasse = null)
    {
        // validation for constraint: string
        if (!is_null($vinkularglaeubigerStrasse) && !is_string($vinkularglaeubigerStrasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vinkularglaeubigerStrasse, true), gettype($vinkularglaeubigerStrasse)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($vinkularglaeubigerStrasse) && mb_strlen($vinkularglaeubigerStrasse) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($vinkularglaeubigerStrasse)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($vinkularglaeubigerStrasse) && mb_strlen($vinkularglaeubigerStrasse) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($vinkularglaeubigerStrasse)), __LINE__);
        }
        $this->vinkularglaeubigerStrasse = $vinkularglaeubigerStrasse;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VinkularglaeubigerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
