<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vereinbarungenInsassenunfallType StructType
 * @subpackage Structs
 */
class VereinbarungenInsassenunfallType extends AbstractStructBase
{
    /**
     * The sonderrabattInsassenunfall
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * @var \StructType\SonderrabattType[]
     */
    public $sonderrabattInsassenunfall;
    /**
     * The zuschlag
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - fractionDigits: 2
     * - maxInclusive: 100
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $zuschlag;
    /**
     * Constructor method for vereinbarungenInsassenunfallType
     * @uses VereinbarungenInsassenunfallType::setSonderrabattInsassenunfall()
     * @uses VereinbarungenInsassenunfallType::setZuschlag()
     * @param \StructType\SonderrabattType[] $sonderrabattInsassenunfall
     * @param float $zuschlag
     */
    public function __construct(array $sonderrabattInsassenunfall = array(), $zuschlag = null)
    {
        $this
            ->setSonderrabattInsassenunfall($sonderrabattInsassenunfall)
            ->setZuschlag($zuschlag);
    }
    /**
     * Get sonderrabattInsassenunfall value
     * @return \StructType\SonderrabattType[]|null
     */
    public function getSonderrabattInsassenunfall()
    {
        return $this->sonderrabattInsassenunfall;
    }
    /**
     * This method is responsible for validating the values passed to the setSonderrabattInsassenunfall method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSonderrabattInsassenunfall method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSonderrabattInsassenunfallForArrayConstraintsFromSetSonderrabattInsassenunfall(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vereinbarungenInsassenunfallTypeSonderrabattInsassenunfallItem) {
            // validation for constraint: itemType
            if (!$vereinbarungenInsassenunfallTypeSonderrabattInsassenunfallItem instanceof \StructType\SonderrabattType) {
                $invalidValues[] = is_object($vereinbarungenInsassenunfallTypeSonderrabattInsassenunfallItem) ? get_class($vereinbarungenInsassenunfallTypeSonderrabattInsassenunfallItem) : sprintf('%s(%s)', gettype($vereinbarungenInsassenunfallTypeSonderrabattInsassenunfallItem), var_export($vereinbarungenInsassenunfallTypeSonderrabattInsassenunfallItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sonderrabattInsassenunfall property can only contain items of type \StructType\SonderrabattType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sonderrabattInsassenunfall value
     * @throws \InvalidArgumentException
     * @param \StructType\SonderrabattType[] $sonderrabattInsassenunfall
     * @return \StructType\VereinbarungenInsassenunfallType
     */
    public function setSonderrabattInsassenunfall(array $sonderrabattInsassenunfall = array())
    {
        // validation for constraint: array
        if ('' !== ($sonderrabattInsassenunfallArrayErrorMessage = self::validateSonderrabattInsassenunfallForArrayConstraintsFromSetSonderrabattInsassenunfall($sonderrabattInsassenunfall))) {
            throw new \InvalidArgumentException($sonderrabattInsassenunfallArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($sonderrabattInsassenunfall) && count($sonderrabattInsassenunfall) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($sonderrabattInsassenunfall)), __LINE__);
        }
        $this->sonderrabattInsassenunfall = $sonderrabattInsassenunfall;
        return $this;
    }
    /**
     * Add item to sonderrabattInsassenunfall value
     * @throws \InvalidArgumentException
     * @param \StructType\SonderrabattType $item
     * @return \StructType\VereinbarungenInsassenunfallType
     */
    public function addToSonderrabattInsassenunfall(\StructType\SonderrabattType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SonderrabattType) {
            throw new \InvalidArgumentException(sprintf('The sonderrabattInsassenunfall property can only contain items of type \StructType\SonderrabattType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->sonderrabattInsassenunfall) && count($this->sonderrabattInsassenunfall) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->sonderrabattInsassenunfall)), __LINE__);
        }
        $this->sonderrabattInsassenunfall[] = $item;
        return $this;
    }
    /**
     * Get zuschlag value
     * @return float|null
     */
    public function getZuschlag()
    {
        return $this->zuschlag;
    }
    /**
     * Set zuschlag value
     * @param float $zuschlag
     * @return \StructType\VereinbarungenInsassenunfallType
     */
    public function setZuschlag($zuschlag = null)
    {
        // validation for constraint: float
        if (!is_null($zuschlag) && !(is_float($zuschlag) || is_numeric($zuschlag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zuschlag, true), gettype($zuschlag)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($zuschlag) && mb_strlen(mb_substr($zuschlag, mb_strpos($zuschlag, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($zuschlag, true), mb_strlen(mb_substr($zuschlag, mb_strpos($zuschlag, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(100)
        if (!is_null($zuschlag) && $zuschlag > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100', var_export($zuschlag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($zuschlag) && $zuschlag < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($zuschlag, true)), __LINE__);
        }
        $this->zuschlag = $zuschlag;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VereinbarungenInsassenunfallType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
