<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tarifierungsdatenType StructType
 * @subpackage Structs
 */
class TarifierungsdatenType extends AbstractStructBase
{
    /**
     * The beginn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $beginn;
    /**
     * The hauptfaelligkeit
     * Meta information extracted from the WSDL
     * - documentation: Format für Hauptsfälligkeit: dd.mm.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [0-9]{2}[.][0-9]{2}.
     * @var string
     */
    public $hauptfaelligkeit;
    /**
     * The versicherungsEnde
     * Meta information extracted from the WSDL
     * - base: xs:integer
     * - maxExclusive: 2100
     * - minInclusive: 1900
     * - minOccurs: 0
     * @var int
     */
    public $versicherungsEnde;
    /**
     * The zahlungsfrequenz
     * @var string
     */
    public $zahlungsfrequenz;
    /**
     * The produktvariante
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $produktvariante;
    /**
     * The kmuBranchengruppe
     * Meta information extracted from the WSDL
     * - documentation: Dieses Feld ist nur sichtbar, wenn im Feld "produktvariante" der Wert 'KMU-Schutz' gewählt wird
     * - minOccurs: 0
     * @var string
     */
    public $kmuBranchengruppe;
    /**
     * The haftpflicht
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\HaftpflichtType
     */
    public $haftpflicht;
    /**
     * The kasko
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\KaskoType
     */
    public $kasko;
    /**
     * The insassenunfall
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InsassenunfallType
     */
    public $insassenunfall;
    /**
     * The rechtsschutz
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RechtschutzType
     */
    public $rechtsschutz;
    /**
     * The variante
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $variante;
    /**
     * The sonderrabatt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sonderrabatt;
    /**
     * The sonderrabattRs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sonderrabattRs;
    /**
     * The deckungFeuer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deckungFeuer;
    /**
     * The deckungLeitungswasser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deckungLeitungswasser;
    /**
     * The deckungElementar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deckungElementar;
    /**
     * The deckungHochwasser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeckungVsType
     */
    public $deckungHochwasser;
    /**
     * The deckungNiederschlag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeckungVsType
     */
    public $deckungNiederschlag;
    /**
     * The deckungErdbeben
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeckungVsType
     */
    public $deckungErdbeben;
    /**
     * The deckungHaushalt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeckungVsType
     */
    public $deckungHaushalt;
    /**
     * The deckungGlasbruch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deckungGlasbruch;
    /**
     * The deckungHaftpflicht
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeckungVsType
     */
    public $deckungHaftpflicht;
    /**
     * The deckungRechtsschutz
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeckungVsType
     */
    public $deckungRechtsschutz;
    /**
     * The deckungGrobeFahrlaessigkeit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeckungProzentType
     */
    public $deckungGrobeFahrlaessigkeit;
    /**
     * The deckungTipUndTat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deckungTipUndTat;
    /**
     * The deckungSonderverglasung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeckungVsType
     */
    public $deckungSonderverglasung;
    /**
     * The deckungSchwimmbecken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeckungVsType
     */
    public $deckungSchwimmbecken;
    /**
     * The deckungHeizungsanlagen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deckungHeizungsanlagen;
    /**
     * The deckungEZusatz
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deckungEZusatz;
    /**
     * The deckungFahrzeugeRs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deckungFahrzeugeRs;
    /**
     * Constructor method for tarifierungsdatenType
     * @uses TarifierungsdatenType::setBeginn()
     * @uses TarifierungsdatenType::setHauptfaelligkeit()
     * @uses TarifierungsdatenType::setVersicherungsEnde()
     * @uses TarifierungsdatenType::setZahlungsfrequenz()
     * @uses TarifierungsdatenType::setProduktvariante()
     * @uses TarifierungsdatenType::setKmuBranchengruppe()
     * @uses TarifierungsdatenType::setHaftpflicht()
     * @uses TarifierungsdatenType::setKasko()
     * @uses TarifierungsdatenType::setInsassenunfall()
     * @uses TarifierungsdatenType::setRechtsschutz()
     * @uses TarifierungsdatenType::setVariante()
     * @uses TarifierungsdatenType::setSonderrabatt()
     * @uses TarifierungsdatenType::setSonderrabattRs()
     * @uses TarifierungsdatenType::setDeckungFeuer()
     * @uses TarifierungsdatenType::setDeckungLeitungswasser()
     * @uses TarifierungsdatenType::setDeckungElementar()
     * @uses TarifierungsdatenType::setDeckungHochwasser()
     * @uses TarifierungsdatenType::setDeckungNiederschlag()
     * @uses TarifierungsdatenType::setDeckungErdbeben()
     * @uses TarifierungsdatenType::setDeckungHaushalt()
     * @uses TarifierungsdatenType::setDeckungGlasbruch()
     * @uses TarifierungsdatenType::setDeckungHaftpflicht()
     * @uses TarifierungsdatenType::setDeckungRechtsschutz()
     * @uses TarifierungsdatenType::setDeckungGrobeFahrlaessigkeit()
     * @uses TarifierungsdatenType::setDeckungTipUndTat()
     * @uses TarifierungsdatenType::setDeckungSonderverglasung()
     * @uses TarifierungsdatenType::setDeckungSchwimmbecken()
     * @uses TarifierungsdatenType::setDeckungHeizungsanlagen()
     * @uses TarifierungsdatenType::setDeckungEZusatz()
     * @uses TarifierungsdatenType::setDeckungFahrzeugeRs()
     * @param string $beginn
     * @param string $hauptfaelligkeit
     * @param int $versicherungsEnde
     * @param string $zahlungsfrequenz
     * @param string $produktvariante
     * @param string $kmuBranchengruppe
     * @param \StructType\HaftpflichtType $haftpflicht
     * @param \StructType\KaskoType $kasko
     * @param \StructType\InsassenunfallType $insassenunfall
     * @param \StructType\RechtschutzType $rechtsschutz
     * @param string $variante
     * @param int $sonderrabatt
     * @param int $sonderrabattRs
     * @param bool $deckungFeuer
     * @param bool $deckungLeitungswasser
     * @param bool $deckungElementar
     * @param \StructType\DeckungVsType $deckungHochwasser
     * @param \StructType\DeckungVsType $deckungNiederschlag
     * @param \StructType\DeckungVsType $deckungErdbeben
     * @param \StructType\DeckungVsType $deckungHaushalt
     * @param bool $deckungGlasbruch
     * @param \StructType\DeckungVsType $deckungHaftpflicht
     * @param \StructType\DeckungVsType $deckungRechtsschutz
     * @param \StructType\DeckungProzentType $deckungGrobeFahrlaessigkeit
     * @param bool $deckungTipUndTat
     * @param \StructType\DeckungVsType $deckungSonderverglasung
     * @param \StructType\DeckungVsType $deckungSchwimmbecken
     * @param bool $deckungHeizungsanlagen
     * @param bool $deckungEZusatz
     * @param bool $deckungFahrzeugeRs
     */
    public function __construct($beginn = null, $hauptfaelligkeit = null, $versicherungsEnde = null, $zahlungsfrequenz = null, $produktvariante = null, $kmuBranchengruppe = null, \StructType\HaftpflichtType $haftpflicht = null, \StructType\KaskoType $kasko = null, \StructType\InsassenunfallType $insassenunfall = null, \StructType\RechtschutzType $rechtsschutz = null, $variante = null, $sonderrabatt = null, $sonderrabattRs = null, $deckungFeuer = null, $deckungLeitungswasser = null, $deckungElementar = null, \StructType\DeckungVsType $deckungHochwasser = null, \StructType\DeckungVsType $deckungNiederschlag = null, \StructType\DeckungVsType $deckungErdbeben = null, \StructType\DeckungVsType $deckungHaushalt = null, $deckungGlasbruch = null, \StructType\DeckungVsType $deckungHaftpflicht = null, \StructType\DeckungVsType $deckungRechtsschutz = null, \StructType\DeckungProzentType $deckungGrobeFahrlaessigkeit = null, $deckungTipUndTat = null, \StructType\DeckungVsType $deckungSonderverglasung = null, \StructType\DeckungVsType $deckungSchwimmbecken = null, $deckungHeizungsanlagen = null, $deckungEZusatz = null, $deckungFahrzeugeRs = null)
    {
        $this
            ->setBeginn($beginn)
            ->setHauptfaelligkeit($hauptfaelligkeit)
            ->setVersicherungsEnde($versicherungsEnde)
            ->setZahlungsfrequenz($zahlungsfrequenz)
            ->setProduktvariante($produktvariante)
            ->setKmuBranchengruppe($kmuBranchengruppe)
            ->setHaftpflicht($haftpflicht)
            ->setKasko($kasko)
            ->setInsassenunfall($insassenunfall)
            ->setRechtsschutz($rechtsschutz)
            ->setVariante($variante)
            ->setSonderrabatt($sonderrabatt)
            ->setSonderrabattRs($sonderrabattRs)
            ->setDeckungFeuer($deckungFeuer)
            ->setDeckungLeitungswasser($deckungLeitungswasser)
            ->setDeckungElementar($deckungElementar)
            ->setDeckungHochwasser($deckungHochwasser)
            ->setDeckungNiederschlag($deckungNiederschlag)
            ->setDeckungErdbeben($deckungErdbeben)
            ->setDeckungHaushalt($deckungHaushalt)
            ->setDeckungGlasbruch($deckungGlasbruch)
            ->setDeckungHaftpflicht($deckungHaftpflicht)
            ->setDeckungRechtsschutz($deckungRechtsschutz)
            ->setDeckungGrobeFahrlaessigkeit($deckungGrobeFahrlaessigkeit)
            ->setDeckungTipUndTat($deckungTipUndTat)
            ->setDeckungSonderverglasung($deckungSonderverglasung)
            ->setDeckungSchwimmbecken($deckungSchwimmbecken)
            ->setDeckungHeizungsanlagen($deckungHeizungsanlagen)
            ->setDeckungEZusatz($deckungEZusatz)
            ->setDeckungFahrzeugeRs($deckungFahrzeugeRs);
    }
    /**
     * Get beginn value
     * @return string|null
     */
    public function getBeginn()
    {
        return $this->beginn;
    }
    /**
     * Set beginn value
     * @param string $beginn
     * @return \StructType\TarifierungsdatenType
     */
    public function setBeginn($beginn = null)
    {
        // validation for constraint: string
        if (!is_null($beginn) && !is_string($beginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginn, true), gettype($beginn)), __LINE__);
        }
        $this->beginn = $beginn;
        return $this;
    }
    /**
     * Get hauptfaelligkeit value
     * @return string|null
     */
    public function getHauptfaelligkeit()
    {
        return $this->hauptfaelligkeit;
    }
    /**
     * Set hauptfaelligkeit value
     * @param string $hauptfaelligkeit
     * @return \StructType\TarifierungsdatenType
     */
    public function setHauptfaelligkeit($hauptfaelligkeit = null)
    {
        // validation for constraint: string
        if (!is_null($hauptfaelligkeit) && !is_string($hauptfaelligkeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hauptfaelligkeit, true), gettype($hauptfaelligkeit)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}[.][0-9]{2}.)
        if (!is_null($hauptfaelligkeit) && !preg_match('/[0-9]{2}[.][0-9]{2}./', $hauptfaelligkeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}[.][0-9]{2}.', var_export($hauptfaelligkeit, true)), __LINE__);
        }
        $this->hauptfaelligkeit = $hauptfaelligkeit;
        return $this;
    }
    /**
     * Get versicherungsEnde value
     * @return int|null
     */
    public function getVersicherungsEnde()
    {
        return $this->versicherungsEnde;
    }
    /**
     * Set versicherungsEnde value
     * @param int $versicherungsEnde
     * @return \StructType\TarifierungsdatenType
     */
    public function setVersicherungsEnde($versicherungsEnde = null)
    {
        // validation for constraint: int
        if (!is_null($versicherungsEnde) && !(is_int($versicherungsEnde) || ctype_digit($versicherungsEnde))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($versicherungsEnde, true), gettype($versicherungsEnde)), __LINE__);
        }
        // validation for constraint: maxExclusive(2100)
        if (!is_null($versicherungsEnde) && $versicherungsEnde >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than 2100', var_export($versicherungsEnde, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1900)
        if (!is_null($versicherungsEnde) && $versicherungsEnde < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1900', var_export($versicherungsEnde, true)), __LINE__);
        }
        $this->versicherungsEnde = $versicherungsEnde;
        return $this;
    }
    /**
     * Get zahlungsfrequenz value
     * @return string|null
     */
    public function getZahlungsfrequenz()
    {
        return $this->zahlungsfrequenz;
    }
    /**
     * Set zahlungsfrequenz value
     * @uses \EnumType\ZahlungsweiseType::valueIsValid()
     * @uses \EnumType\ZahlungsweiseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zahlungsfrequenz
     * @return \StructType\TarifierungsdatenType
     */
    public function setZahlungsfrequenz($zahlungsfrequenz = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ZahlungsweiseType::valueIsValid($zahlungsfrequenz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ZahlungsweiseType', is_array($zahlungsfrequenz) ? implode(', ', $zahlungsfrequenz) : var_export($zahlungsfrequenz, true), implode(', ', \EnumType\ZahlungsweiseType::getValidValues())), __LINE__);
        }
        $this->zahlungsfrequenz = $zahlungsfrequenz;
        return $this;
    }
    /**
     * Get produktvariante value
     * @return string|null
     */
    public function getProduktvariante()
    {
        return $this->produktvariante;
    }
    /**
     * Set produktvariante value
     * @uses \EnumType\ProduktvarianteType::valueIsValid()
     * @uses \EnumType\ProduktvarianteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $produktvariante
     * @return \StructType\TarifierungsdatenType
     */
    public function setProduktvariante($produktvariante = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProduktvarianteType::valueIsValid($produktvariante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProduktvarianteType', is_array($produktvariante) ? implode(', ', $produktvariante) : var_export($produktvariante, true), implode(', ', \EnumType\ProduktvarianteType::getValidValues())), __LINE__);
        }
        $this->produktvariante = $produktvariante;
        return $this;
    }
    /**
     * Get kmuBranchengruppe value
     * @return string|null
     */
    public function getKmuBranchengruppe()
    {
        return $this->kmuBranchengruppe;
    }
    /**
     * Set kmuBranchengruppe value
     * @uses \EnumType\KmuBranchengruppeType::valueIsValid()
     * @uses \EnumType\KmuBranchengruppeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kmuBranchengruppe
     * @return \StructType\TarifierungsdatenType
     */
    public function setKmuBranchengruppe($kmuBranchengruppe = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KmuBranchengruppeType::valueIsValid($kmuBranchengruppe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KmuBranchengruppeType', is_array($kmuBranchengruppe) ? implode(', ', $kmuBranchengruppe) : var_export($kmuBranchengruppe, true), implode(', ', \EnumType\KmuBranchengruppeType::getValidValues())), __LINE__);
        }
        $this->kmuBranchengruppe = $kmuBranchengruppe;
        return $this;
    }
    /**
     * Get haftpflicht value
     * @return \StructType\HaftpflichtType|null
     */
    public function getHaftpflicht()
    {
        return $this->haftpflicht;
    }
    /**
     * Set haftpflicht value
     * @param \StructType\HaftpflichtType $haftpflicht
     * @return \StructType\TarifierungsdatenType
     */
    public function setHaftpflicht(\StructType\HaftpflichtType $haftpflicht = null)
    {
        $this->haftpflicht = $haftpflicht;
        return $this;
    }
    /**
     * Get kasko value
     * @return \StructType\KaskoType|null
     */
    public function getKasko()
    {
        return $this->kasko;
    }
    /**
     * Set kasko value
     * @param \StructType\KaskoType $kasko
     * @return \StructType\TarifierungsdatenType
     */
    public function setKasko(\StructType\KaskoType $kasko = null)
    {
        $this->kasko = $kasko;
        return $this;
    }
    /**
     * Get insassenunfall value
     * @return \StructType\InsassenunfallType|null
     */
    public function getInsassenunfall()
    {
        return $this->insassenunfall;
    }
    /**
     * Set insassenunfall value
     * @param \StructType\InsassenunfallType $insassenunfall
     * @return \StructType\TarifierungsdatenType
     */
    public function setInsassenunfall(\StructType\InsassenunfallType $insassenunfall = null)
    {
        $this->insassenunfall = $insassenunfall;
        return $this;
    }
    /**
     * Get rechtsschutz value
     * @return \StructType\RechtschutzType|null
     */
    public function getRechtsschutz()
    {
        return $this->rechtsschutz;
    }
    /**
     * Set rechtsschutz value
     * @param \StructType\RechtschutzType $rechtsschutz
     * @return \StructType\TarifierungsdatenType
     */
    public function setRechtsschutz(\StructType\RechtschutzType $rechtsschutz = null)
    {
        $this->rechtsschutz = $rechtsschutz;
        return $this;
    }
    /**
     * Get variante value
     * @return string|null
     */
    public function getVariante()
    {
        return $this->variante;
    }
    /**
     * Set variante value
     * @uses \EnumType\VarianteType::valueIsValid()
     * @uses \EnumType\VarianteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $variante
     * @return \StructType\TarifierungsdatenType
     */
    public function setVariante($variante = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VarianteType::valueIsValid($variante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VarianteType', is_array($variante) ? implode(', ', $variante) : var_export($variante, true), implode(', ', \EnumType\VarianteType::getValidValues())), __LINE__);
        }
        $this->variante = $variante;
        return $this;
    }
    /**
     * Get sonderrabatt value
     * @return int|null
     */
    public function getSonderrabatt()
    {
        return $this->sonderrabatt;
    }
    /**
     * Set sonderrabatt value
     * @param int $sonderrabatt
     * @return \StructType\TarifierungsdatenType
     */
    public function setSonderrabatt($sonderrabatt = null)
    {
        // validation for constraint: int
        if (!is_null($sonderrabatt) && !(is_int($sonderrabatt) || ctype_digit($sonderrabatt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sonderrabatt, true), gettype($sonderrabatt)), __LINE__);
        }
        $this->sonderrabatt = $sonderrabatt;
        return $this;
    }
    /**
     * Get sonderrabattRs value
     * @return int|null
     */
    public function getSonderrabattRs()
    {
        return $this->sonderrabattRs;
    }
    /**
     * Set sonderrabattRs value
     * @param int $sonderrabattRs
     * @return \StructType\TarifierungsdatenType
     */
    public function setSonderrabattRs($sonderrabattRs = null)
    {
        // validation for constraint: int
        if (!is_null($sonderrabattRs) && !(is_int($sonderrabattRs) || ctype_digit($sonderrabattRs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sonderrabattRs, true), gettype($sonderrabattRs)), __LINE__);
        }
        $this->sonderrabattRs = $sonderrabattRs;
        return $this;
    }
    /**
     * Get deckungFeuer value
     * @return bool|null
     */
    public function getDeckungFeuer()
    {
        return $this->deckungFeuer;
    }
    /**
     * Set deckungFeuer value
     * @param bool $deckungFeuer
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungFeuer($deckungFeuer = null)
    {
        // validation for constraint: boolean
        if (!is_null($deckungFeuer) && !is_bool($deckungFeuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deckungFeuer, true), gettype($deckungFeuer)), __LINE__);
        }
        $this->deckungFeuer = $deckungFeuer;
        return $this;
    }
    /**
     * Get deckungLeitungswasser value
     * @return bool|null
     */
    public function getDeckungLeitungswasser()
    {
        return $this->deckungLeitungswasser;
    }
    /**
     * Set deckungLeitungswasser value
     * @param bool $deckungLeitungswasser
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungLeitungswasser($deckungLeitungswasser = null)
    {
        // validation for constraint: boolean
        if (!is_null($deckungLeitungswasser) && !is_bool($deckungLeitungswasser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deckungLeitungswasser, true), gettype($deckungLeitungswasser)), __LINE__);
        }
        $this->deckungLeitungswasser = $deckungLeitungswasser;
        return $this;
    }
    /**
     * Get deckungElementar value
     * @return bool|null
     */
    public function getDeckungElementar()
    {
        return $this->deckungElementar;
    }
    /**
     * Set deckungElementar value
     * @param bool $deckungElementar
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungElementar($deckungElementar = null)
    {
        // validation for constraint: boolean
        if (!is_null($deckungElementar) && !is_bool($deckungElementar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deckungElementar, true), gettype($deckungElementar)), __LINE__);
        }
        $this->deckungElementar = $deckungElementar;
        return $this;
    }
    /**
     * Get deckungHochwasser value
     * @return \StructType\DeckungVsType|null
     */
    public function getDeckungHochwasser()
    {
        return $this->deckungHochwasser;
    }
    /**
     * Set deckungHochwasser value
     * @param \StructType\DeckungVsType $deckungHochwasser
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungHochwasser(\StructType\DeckungVsType $deckungHochwasser = null)
    {
        $this->deckungHochwasser = $deckungHochwasser;
        return $this;
    }
    /**
     * Get deckungNiederschlag value
     * @return \StructType\DeckungVsType|null
     */
    public function getDeckungNiederschlag()
    {
        return $this->deckungNiederschlag;
    }
    /**
     * Set deckungNiederschlag value
     * @param \StructType\DeckungVsType $deckungNiederschlag
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungNiederschlag(\StructType\DeckungVsType $deckungNiederschlag = null)
    {
        $this->deckungNiederschlag = $deckungNiederschlag;
        return $this;
    }
    /**
     * Get deckungErdbeben value
     * @return \StructType\DeckungVsType|null
     */
    public function getDeckungErdbeben()
    {
        return $this->deckungErdbeben;
    }
    /**
     * Set deckungErdbeben value
     * @param \StructType\DeckungVsType $deckungErdbeben
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungErdbeben(\StructType\DeckungVsType $deckungErdbeben = null)
    {
        $this->deckungErdbeben = $deckungErdbeben;
        return $this;
    }
    /**
     * Get deckungHaushalt value
     * @return \StructType\DeckungVsType|null
     */
    public function getDeckungHaushalt()
    {
        return $this->deckungHaushalt;
    }
    /**
     * Set deckungHaushalt value
     * @param \StructType\DeckungVsType $deckungHaushalt
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungHaushalt(\StructType\DeckungVsType $deckungHaushalt = null)
    {
        $this->deckungHaushalt = $deckungHaushalt;
        return $this;
    }
    /**
     * Get deckungGlasbruch value
     * @return bool|null
     */
    public function getDeckungGlasbruch()
    {
        return $this->deckungGlasbruch;
    }
    /**
     * Set deckungGlasbruch value
     * @param bool $deckungGlasbruch
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungGlasbruch($deckungGlasbruch = null)
    {
        // validation for constraint: boolean
        if (!is_null($deckungGlasbruch) && !is_bool($deckungGlasbruch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deckungGlasbruch, true), gettype($deckungGlasbruch)), __LINE__);
        }
        $this->deckungGlasbruch = $deckungGlasbruch;
        return $this;
    }
    /**
     * Get deckungHaftpflicht value
     * @return \StructType\DeckungVsType|null
     */
    public function getDeckungHaftpflicht()
    {
        return $this->deckungHaftpflicht;
    }
    /**
     * Set deckungHaftpflicht value
     * @param \StructType\DeckungVsType $deckungHaftpflicht
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungHaftpflicht(\StructType\DeckungVsType $deckungHaftpflicht = null)
    {
        $this->deckungHaftpflicht = $deckungHaftpflicht;
        return $this;
    }
    /**
     * Get deckungRechtsschutz value
     * @return \StructType\DeckungVsType|null
     */
    public function getDeckungRechtsschutz()
    {
        return $this->deckungRechtsschutz;
    }
    /**
     * Set deckungRechtsschutz value
     * @param \StructType\DeckungVsType $deckungRechtsschutz
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungRechtsschutz(\StructType\DeckungVsType $deckungRechtsschutz = null)
    {
        $this->deckungRechtsschutz = $deckungRechtsschutz;
        return $this;
    }
    /**
     * Get deckungGrobeFahrlaessigkeit value
     * @return \StructType\DeckungProzentType|null
     */
    public function getDeckungGrobeFahrlaessigkeit()
    {
        return $this->deckungGrobeFahrlaessigkeit;
    }
    /**
     * Set deckungGrobeFahrlaessigkeit value
     * @param \StructType\DeckungProzentType $deckungGrobeFahrlaessigkeit
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungGrobeFahrlaessigkeit(\StructType\DeckungProzentType $deckungGrobeFahrlaessigkeit = null)
    {
        $this->deckungGrobeFahrlaessigkeit = $deckungGrobeFahrlaessigkeit;
        return $this;
    }
    /**
     * Get deckungTipUndTat value
     * @return bool|null
     */
    public function getDeckungTipUndTat()
    {
        return $this->deckungTipUndTat;
    }
    /**
     * Set deckungTipUndTat value
     * @param bool $deckungTipUndTat
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungTipUndTat($deckungTipUndTat = null)
    {
        // validation for constraint: boolean
        if (!is_null($deckungTipUndTat) && !is_bool($deckungTipUndTat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deckungTipUndTat, true), gettype($deckungTipUndTat)), __LINE__);
        }
        $this->deckungTipUndTat = $deckungTipUndTat;
        return $this;
    }
    /**
     * Get deckungSonderverglasung value
     * @return \StructType\DeckungVsType|null
     */
    public function getDeckungSonderverglasung()
    {
        return $this->deckungSonderverglasung;
    }
    /**
     * Set deckungSonderverglasung value
     * @param \StructType\DeckungVsType $deckungSonderverglasung
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungSonderverglasung(\StructType\DeckungVsType $deckungSonderverglasung = null)
    {
        $this->deckungSonderverglasung = $deckungSonderverglasung;
        return $this;
    }
    /**
     * Get deckungSchwimmbecken value
     * @return \StructType\DeckungVsType|null
     */
    public function getDeckungSchwimmbecken()
    {
        return $this->deckungSchwimmbecken;
    }
    /**
     * Set deckungSchwimmbecken value
     * @param \StructType\DeckungVsType $deckungSchwimmbecken
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungSchwimmbecken(\StructType\DeckungVsType $deckungSchwimmbecken = null)
    {
        $this->deckungSchwimmbecken = $deckungSchwimmbecken;
        return $this;
    }
    /**
     * Get deckungHeizungsanlagen value
     * @return bool|null
     */
    public function getDeckungHeizungsanlagen()
    {
        return $this->deckungHeizungsanlagen;
    }
    /**
     * Set deckungHeizungsanlagen value
     * @param bool $deckungHeizungsanlagen
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungHeizungsanlagen($deckungHeizungsanlagen = null)
    {
        // validation for constraint: boolean
        if (!is_null($deckungHeizungsanlagen) && !is_bool($deckungHeizungsanlagen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deckungHeizungsanlagen, true), gettype($deckungHeizungsanlagen)), __LINE__);
        }
        $this->deckungHeizungsanlagen = $deckungHeizungsanlagen;
        return $this;
    }
    /**
     * Get deckungEZusatz value
     * @return bool|null
     */
    public function getDeckungEZusatz()
    {
        return $this->deckungEZusatz;
    }
    /**
     * Set deckungEZusatz value
     * @param bool $deckungEZusatz
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungEZusatz($deckungEZusatz = null)
    {
        // validation for constraint: boolean
        if (!is_null($deckungEZusatz) && !is_bool($deckungEZusatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deckungEZusatz, true), gettype($deckungEZusatz)), __LINE__);
        }
        $this->deckungEZusatz = $deckungEZusatz;
        return $this;
    }
    /**
     * Get deckungFahrzeugeRs value
     * @return bool|null
     */
    public function getDeckungFahrzeugeRs()
    {
        return $this->deckungFahrzeugeRs;
    }
    /**
     * Set deckungFahrzeugeRs value
     * @param bool $deckungFahrzeugeRs
     * @return \StructType\TarifierungsdatenType
     */
    public function setDeckungFahrzeugeRs($deckungFahrzeugeRs = null)
    {
        // validation for constraint: boolean
        if (!is_null($deckungFahrzeugeRs) && !is_bool($deckungFahrzeugeRs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deckungFahrzeugeRs, true), gettype($deckungFahrzeugeRs)), __LINE__);
        }
        $this->deckungFahrzeugeRs = $deckungFahrzeugeRs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TarifierungsdatenType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
