<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rechtschutzType StructType
 * @subpackage Structs
 */
class RechtschutzType extends AbstractStructBase
{
    /**
     * The selbstbeteiligung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $selbstbeteiligung;
    /**
     * The kundengruppe
     * @var string
     */
    public $kundengruppe;
    /**
     * The versicherungssumme
     * Meta information extracted from the WSDL
     * - documentation: Auf der Oberfläche ist das Feld eine Auswahlliste - wenn der übergebene Wert in der Liste gefunden wird, wird er selektiert, ansonsten zieht der Default Wert - es erfolgt keine Fehlermeldung.
     * @var int
     */
    public $versicherungssumme;
    /**
     * The verkehrsbereich
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RsVerkehrsbereichsType
     */
    public $verkehrsbereich;
    /**
     * The privatBerufsbereichUnselbstaendig
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PrivatBerufsbereichsRechtsschutzType
     */
    public $privatBerufsbereichUnselbstaendig;
    /**
     * The berufsBereichSelbstaendige
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BerufsBereichsRechtsschutzType
     */
    public $berufsBereichSelbstaendige;
    /**
     * Constructor method for rechtschutzType
     * @uses RechtschutzType::setSelbstbeteiligung()
     * @uses RechtschutzType::setKundengruppe()
     * @uses RechtschutzType::setVersicherungssumme()
     * @uses RechtschutzType::setVerkehrsbereich()
     * @uses RechtschutzType::setPrivatBerufsbereichUnselbstaendig()
     * @uses RechtschutzType::setBerufsBereichSelbstaendige()
     * @param string $selbstbeteiligung
     * @param string $kundengruppe
     * @param int $versicherungssumme
     * @param \StructType\RsVerkehrsbereichsType $verkehrsbereich
     * @param \StructType\PrivatBerufsbereichsRechtsschutzType $privatBerufsbereichUnselbstaendig
     * @param \StructType\BerufsBereichsRechtsschutzType $berufsBereichSelbstaendige
     */
    public function __construct($selbstbeteiligung = null, $kundengruppe = null, $versicherungssumme = null, \StructType\RsVerkehrsbereichsType $verkehrsbereich = null, \StructType\PrivatBerufsbereichsRechtsschutzType $privatBerufsbereichUnselbstaendig = null, \StructType\BerufsBereichsRechtsschutzType $berufsBereichSelbstaendige = null)
    {
        $this
            ->setSelbstbeteiligung($selbstbeteiligung)
            ->setKundengruppe($kundengruppe)
            ->setVersicherungssumme($versicherungssumme)
            ->setVerkehrsbereich($verkehrsbereich)
            ->setPrivatBerufsbereichUnselbstaendig($privatBerufsbereichUnselbstaendig)
            ->setBerufsBereichSelbstaendige($berufsBereichSelbstaendige);
    }
    /**
     * Get selbstbeteiligung value
     * @return string|null
     */
    public function getSelbstbeteiligung()
    {
        return $this->selbstbeteiligung;
    }
    /**
     * Set selbstbeteiligung value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selbstbeteiligung
     * @return \StructType\RechtschutzType
     */
    public function setSelbstbeteiligung($selbstbeteiligung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($selbstbeteiligung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($selbstbeteiligung) ? implode(', ', $selbstbeteiligung) : var_export($selbstbeteiligung, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->selbstbeteiligung = $selbstbeteiligung;
        return $this;
    }
    /**
     * Get kundengruppe value
     * @return string|null
     */
    public function getKundengruppe()
    {
        return $this->kundengruppe;
    }
    /**
     * Set kundengruppe value
     * @uses \EnumType\RsKundengruppeType::valueIsValid()
     * @uses \EnumType\RsKundengruppeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kundengruppe
     * @return \StructType\RechtschutzType
     */
    public function setKundengruppe($kundengruppe = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RsKundengruppeType::valueIsValid($kundengruppe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RsKundengruppeType', is_array($kundengruppe) ? implode(', ', $kundengruppe) : var_export($kundengruppe, true), implode(', ', \EnumType\RsKundengruppeType::getValidValues())), __LINE__);
        }
        $this->kundengruppe = $kundengruppe;
        return $this;
    }
    /**
     * Get versicherungssumme value
     * @return int|null
     */
    public function getVersicherungssumme()
    {
        return $this->versicherungssumme;
    }
    /**
     * Set versicherungssumme value
     * @param int $versicherungssumme
     * @return \StructType\RechtschutzType
     */
    public function setVersicherungssumme($versicherungssumme = null)
    {
        // validation for constraint: int
        if (!is_null($versicherungssumme) && !(is_int($versicherungssumme) || ctype_digit($versicherungssumme))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($versicherungssumme, true), gettype($versicherungssumme)), __LINE__);
        }
        $this->versicherungssumme = $versicherungssumme;
        return $this;
    }
    /**
     * Get verkehrsbereich value
     * @return \StructType\RsVerkehrsbereichsType|null
     */
    public function getVerkehrsbereich()
    {
        return $this->verkehrsbereich;
    }
    /**
     * Set verkehrsbereich value
     * @param \StructType\RsVerkehrsbereichsType $verkehrsbereich
     * @return \StructType\RechtschutzType
     */
    public function setVerkehrsbereich(\StructType\RsVerkehrsbereichsType $verkehrsbereich = null)
    {
        $this->verkehrsbereich = $verkehrsbereich;
        return $this;
    }
    /**
     * Get privatBerufsbereichUnselbstaendig value
     * @return \StructType\PrivatBerufsbereichsRechtsschutzType|null
     */
    public function getPrivatBerufsbereichUnselbstaendig()
    {
        return $this->privatBerufsbereichUnselbstaendig;
    }
    /**
     * Set privatBerufsbereichUnselbstaendig value
     * @param \StructType\PrivatBerufsbereichsRechtsschutzType $privatBerufsbereichUnselbstaendig
     * @return \StructType\RechtschutzType
     */
    public function setPrivatBerufsbereichUnselbstaendig(\StructType\PrivatBerufsbereichsRechtsschutzType $privatBerufsbereichUnselbstaendig = null)
    {
        $this->privatBerufsbereichUnselbstaendig = $privatBerufsbereichUnselbstaendig;
        return $this;
    }
    /**
     * Get berufsBereichSelbstaendige value
     * @return \StructType\BerufsBereichsRechtsschutzType|null
     */
    public function getBerufsBereichSelbstaendige()
    {
        return $this->berufsBereichSelbstaendige;
    }
    /**
     * Set berufsBereichSelbstaendige value
     * @param \StructType\BerufsBereichsRechtsschutzType $berufsBereichSelbstaendige
     * @return \StructType\RechtschutzType
     */
    public function setBerufsBereichSelbstaendige(\StructType\BerufsBereichsRechtsschutzType $berufsBereichSelbstaendige = null)
    {
        $this->berufsBereichSelbstaendige = $berufsBereichSelbstaendige;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RechtschutzType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
