<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintDocument StructType
 * Meta information extracted from the WSDL
 * - documentation: Druckdokument eines Geschäftsfalles
 * @subpackage Structs
 */
class PrintDocument extends AbstractStructBase
{
    /**
     * The businessCaseNumber
     * Meta information extracted from the WSDL
     * - documentation: ID des zugehörigen Geschäftsfalles in der eVP
     * @var int
     */
    public $businessCaseNumber;
    /**
     * The versionNumber
     * Meta information extracted from the WSDL
     * - documentation: Versionsnummer des Geschäftsfalles
     * - minOccurs: 0
     * @var int
     */
    public $versionNumber;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: eindeutige id des Attachments
     * @var int
     */
    public $id;
    /**
     * The printType
     * @var string
     */
    public $printType;
    /**
     * The printData
     * Meta information extracted from the WSDL
     * - documentation: Der PDF-Stream des Druckdokumentes
     * @var string
     */
    public $printData;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Sonstige Beschreibung des Attachements | Freie Beschreibung des Geschäftsfalles | Beschreibung des Status
     * - base: xsd:string
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $description;
    /**
     * The benutzerbnr
     * Meta information extracted from the WSDL
     * - documentation: benutzer bnr
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $benutzerbnr;
    /**
     * The typVorlage
     * Meta information extracted from the WSDL
     * - documentation: Vorlage Typ
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $typVorlage;
    /**
     * Constructor method for PrintDocument
     * @uses PrintDocument::setBusinessCaseNumber()
     * @uses PrintDocument::setVersionNumber()
     * @uses PrintDocument::setId()
     * @uses PrintDocument::setPrintType()
     * @uses PrintDocument::setPrintData()
     * @uses PrintDocument::setDescription()
     * @uses PrintDocument::setBenutzerbnr()
     * @uses PrintDocument::setTypVorlage()
     * @param int $businessCaseNumber
     * @param int $versionNumber
     * @param int $id
     * @param string $printType
     * @param string $printData
     * @param string $description
     * @param int $benutzerbnr
     * @param int $typVorlage
     */
    public function __construct($businessCaseNumber = null, $versionNumber = null, $id = null, $printType = null, $printData = null, $description = null, $benutzerbnr = null, $typVorlage = null)
    {
        $this
            ->setBusinessCaseNumber($businessCaseNumber)
            ->setVersionNumber($versionNumber)
            ->setId($id)
            ->setPrintType($printType)
            ->setPrintData($printData)
            ->setDescription($description)
            ->setBenutzerbnr($benutzerbnr)
            ->setTypVorlage($typVorlage);
    }
    /**
     * Get businessCaseNumber value
     * @return int|null
     */
    public function getBusinessCaseNumber()
    {
        return $this->businessCaseNumber;
    }
    /**
     * Set businessCaseNumber value
     * @param int $businessCaseNumber
     * @return \StructType\PrintDocument
     */
    public function setBusinessCaseNumber($businessCaseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($businessCaseNumber) && !(is_int($businessCaseNumber) || ctype_digit($businessCaseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessCaseNumber, true), gettype($businessCaseNumber)), __LINE__);
        }
        $this->businessCaseNumber = $businessCaseNumber;
        return $this;
    }
    /**
     * Get versionNumber value
     * @return int|null
     */
    public function getVersionNumber()
    {
        return $this->versionNumber;
    }
    /**
     * Set versionNumber value
     * @param int $versionNumber
     * @return \StructType\PrintDocument
     */
    public function setVersionNumber($versionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($versionNumber) && !(is_int($versionNumber) || ctype_digit($versionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($versionNumber, true), gettype($versionNumber)), __LINE__);
        }
        $this->versionNumber = $versionNumber;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\PrintDocument
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get printType value
     * @return string|null
     */
    public function getPrintType()
    {
        return $this->printType;
    }
    /**
     * Set printType value
     * @uses \EnumType\PrintType::valueIsValid()
     * @uses \EnumType\PrintType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $printType
     * @return \StructType\PrintDocument
     */
    public function setPrintType($printType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrintType::valueIsValid($printType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PrintType', is_array($printType) ? implode(', ', $printType) : var_export($printType, true), implode(', ', \EnumType\PrintType::getValidValues())), __LINE__);
        }
        $this->printType = $printType;
        return $this;
    }
    /**
     * Get printData value
     * @return string|null
     */
    public function getPrintData()
    {
        return $this->printData;
    }
    /**
     * Set printData value
     * @param string $printData
     * @return \StructType\PrintDocument
     */
    public function setPrintData($printData = null)
    {
        // validation for constraint: string
        if (!is_null($printData) && !is_string($printData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printData, true), gettype($printData)), __LINE__);
        }
        $this->printData = $printData;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\PrintDocument
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($description) && mb_strlen($description) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($description) && mb_strlen($description) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get benutzerbnr value
     * @return int|null
     */
    public function getBenutzerbnr()
    {
        return $this->benutzerbnr;
    }
    /**
     * Set benutzerbnr value
     * @param int $benutzerbnr
     * @return \StructType\PrintDocument
     */
    public function setBenutzerbnr($benutzerbnr = null)
    {
        // validation for constraint: int
        if (!is_null($benutzerbnr) && !(is_int($benutzerbnr) || ctype_digit($benutzerbnr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($benutzerbnr, true), gettype($benutzerbnr)), __LINE__);
        }
        $this->benutzerbnr = $benutzerbnr;
        return $this;
    }
    /**
     * Get typVorlage value
     * @return int|null
     */
    public function getTypVorlage()
    {
        return $this->typVorlage;
    }
    /**
     * Set typVorlage value
     * @param int $typVorlage
     * @return \StructType\PrintDocument
     */
    public function setTypVorlage($typVorlage = null)
    {
        // validation for constraint: int
        if (!is_null($typVorlage) && !(is_int($typVorlage) || ctype_digit($typVorlage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typVorlage, true), gettype($typVorlage)), __LINE__);
        }
        $this->typVorlage = $typVorlage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrintDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
