<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for offenerSchadenType StructType
 * @subpackage Structs
 */
class OffenerSchadenType extends AbstractStructBase
{
    /**
     * The monat
     * @var int
     */
    public $monat;
    /**
     * The jahr
     * @var int
     */
    public $jahr;
    /**
     * Constructor method for offenerSchadenType
     * @uses OffenerSchadenType::setMonat()
     * @uses OffenerSchadenType::setJahr()
     * @param int $monat
     * @param int $jahr
     */
    public function __construct($monat = null, $jahr = null)
    {
        $this
            ->setMonat($monat)
            ->setJahr($jahr);
    }
    /**
     * Get monat value
     * @return int|null
     */
    public function getMonat()
    {
        return $this->monat;
    }
    /**
     * Set monat value
     * @param int $monat
     * @return \StructType\OffenerSchadenType
     */
    public function setMonat($monat = null)
    {
        // validation for constraint: int
        if (!is_null($monat) && !(is_int($monat) || ctype_digit($monat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($monat, true), gettype($monat)), __LINE__);
        }
        $this->monat = $monat;
        return $this;
    }
    /**
     * Get jahr value
     * @return int|null
     */
    public function getJahr()
    {
        return $this->jahr;
    }
    /**
     * Set jahr value
     * @param int $jahr
     * @return \StructType\OffenerSchadenType
     */
    public function setJahr($jahr = null)
    {
        // validation for constraint: int
        if (!is_null($jahr) && !(is_int($jahr) || ctype_digit($jahr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jahr, true), gettype($jahr)), __LINE__);
        }
        $this->jahr = $jahr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OffenerSchadenType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
