<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for newBusinessCaseSMOnlineRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request which starts a new online schadenmeldung and prefills it with the given data
 * @subpackage Structs
 */
class NewBusinessCaseSMOnlineRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 50
     * - minOccurs: 0
     * @var int[]
     */
    public $customer;
    /**
     * The paOid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $paOid;
    /**
     * The businessCaseId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $businessCaseId;
    /**
     * The dvag_vbnr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $dvag_vbnr;
    /**
     * The smonline
     * Meta information extracted from the WSDL
     * - documentation: Detaildaten Objekt einer Schadenmeldung
     * - minOccurs: 0
     * @var \StructType\Consultation_SMOnline
     */
    public $smonline;
    /**
     * The withoutFrame
     * Meta information extracted from the WSDL
     * - documentation: Definiert ob ein eVP Navigationsframe angezeigt wird oder nicht. Default FALSE
     * - default: false
     * - minOccurs: 0
     * @var bool
     */
    public $withoutFrame;
    /**
     * Constructor method for newBusinessCaseSMOnlineRequest
     * @uses NewBusinessCaseSMOnlineRequest::setLogin()
     * @uses NewBusinessCaseSMOnlineRequest::setCustomer()
     * @uses NewBusinessCaseSMOnlineRequest::setPaOid()
     * @uses NewBusinessCaseSMOnlineRequest::setBusinessCaseId()
     * @uses NewBusinessCaseSMOnlineRequest::setDvag_vbnr()
     * @uses NewBusinessCaseSMOnlineRequest::setSmonline()
     * @uses NewBusinessCaseSMOnlineRequest::setWithoutFrame()
     * @param \StructType\Login $login
     * @param int[] $customer
     * @param string $paOid
     * @param int $businessCaseId
     * @param int $dvag_vbnr
     * @param \StructType\Consultation_SMOnline $smonline
     * @param bool $withoutFrame
     */
    public function __construct(\StructType\Login $login = null, array $customer = array(), $paOid = null, $businessCaseId = null, $dvag_vbnr = null, \StructType\Consultation_SMOnline $smonline = null, $withoutFrame = false)
    {
        $this
            ->setLogin($login)
            ->setCustomer($customer)
            ->setPaOid($paOid)
            ->setBusinessCaseId($businessCaseId)
            ->setDvag_vbnr($dvag_vbnr)
            ->setSmonline($smonline)
            ->setWithoutFrame($withoutFrame);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\NewBusinessCaseSMOnlineRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get customer value
     * @return int[]|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerForArrayConstraintsFromSetCustomer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newBusinessCaseSMOnlineRequestCustomerItem) {
            // validation for constraint: itemType
            if (!(is_int($newBusinessCaseSMOnlineRequestCustomerItem) || ctype_digit($newBusinessCaseSMOnlineRequestCustomerItem))) {
                $invalidValues[] = is_object($newBusinessCaseSMOnlineRequestCustomerItem) ? get_class($newBusinessCaseSMOnlineRequestCustomerItem) : sprintf('%s(%s)', gettype($newBusinessCaseSMOnlineRequestCustomerItem), var_export($newBusinessCaseSMOnlineRequestCustomerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customer property can only contain items of type integer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customer value
     * @throws \InvalidArgumentException
     * @param int[] $customer
     * @return \StructType\NewBusinessCaseSMOnlineRequest
     */
    public function setCustomer(array $customer = array())
    {
        // validation for constraint: array
        if ('' !== ($customerArrayErrorMessage = self::validateCustomerForArrayConstraintsFromSetCustomer($customer))) {
            throw new \InvalidArgumentException($customerArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($customer) && count($customer) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 50', count($customer)), __LINE__);
        }
        $this->customer = $customer;
        return $this;
    }
    /**
     * Add item to customer value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\NewBusinessCaseSMOnlineRequest
     */
    public function addToCustomer($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The customer property can only contain items of type integer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($this->customer) && count($this->customer) >= 50) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 50', count($this->customer)), __LINE__);
        }
        $this->customer[] = $item;
        return $this;
    }
    /**
     * Get paOid value
     * @return string|null
     */
    public function getPaOid()
    {
        return $this->paOid;
    }
    /**
     * Set paOid value
     * @param string $paOid
     * @return \StructType\NewBusinessCaseSMOnlineRequest
     */
    public function setPaOid($paOid = null)
    {
        // validation for constraint: string
        if (!is_null($paOid) && !is_string($paOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paOid, true), gettype($paOid)), __LINE__);
        }
        $this->paOid = $paOid;
        return $this;
    }
    /**
     * Get businessCaseId value
     * @return int|null
     */
    public function getBusinessCaseId()
    {
        return $this->businessCaseId;
    }
    /**
     * Set businessCaseId value
     * @param int $businessCaseId
     * @return \StructType\NewBusinessCaseSMOnlineRequest
     */
    public function setBusinessCaseId($businessCaseId = null)
    {
        // validation for constraint: int
        if (!is_null($businessCaseId) && !(is_int($businessCaseId) || ctype_digit($businessCaseId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessCaseId, true), gettype($businessCaseId)), __LINE__);
        }
        $this->businessCaseId = $businessCaseId;
        return $this;
    }
    /**
     * Get dvag_vbnr value
     * @return int|null
     */
    public function getDvag_vbnr()
    {
        return $this->dvag_vbnr;
    }
    /**
     * Set dvag_vbnr value
     * @param int $dvag_vbnr
     * @return \StructType\NewBusinessCaseSMOnlineRequest
     */
    public function setDvag_vbnr($dvag_vbnr = null)
    {
        // validation for constraint: int
        if (!is_null($dvag_vbnr) && !(is_int($dvag_vbnr) || ctype_digit($dvag_vbnr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dvag_vbnr, true), gettype($dvag_vbnr)), __LINE__);
        }
        $this->dvag_vbnr = $dvag_vbnr;
        return $this;
    }
    /**
     * Get smonline value
     * @return \StructType\Consultation_SMOnline|null
     */
    public function getSmonline()
    {
        return $this->smonline;
    }
    /**
     * Set smonline value
     * @param \StructType\Consultation_SMOnline $smonline
     * @return \StructType\NewBusinessCaseSMOnlineRequest
     */
    public function setSmonline(\StructType\Consultation_SMOnline $smonline = null)
    {
        $this->smonline = $smonline;
        return $this;
    }
    /**
     * Get withoutFrame value
     * @return bool|null
     */
    public function getWithoutFrame()
    {
        return $this->withoutFrame;
    }
    /**
     * Set withoutFrame value
     * @param bool $withoutFrame
     * @return \StructType\NewBusinessCaseSMOnlineRequest
     */
    public function setWithoutFrame($withoutFrame = false)
    {
        // validation for constraint: boolean
        if (!is_null($withoutFrame) && !is_bool($withoutFrame)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withoutFrame, true), gettype($withoutFrame)), __LINE__);
        }
        $this->withoutFrame = $withoutFrame;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NewBusinessCaseSMOnlineRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
