<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for newBusinessCaseCalculateAndSaveRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: DEPRECATED : will be deleted in V10.30.00 - use service newBusinessCaseToPolicy instead. Request for start a new consultation, which can be prefilled by a dynamical list of key value pairs, the consultation will be also calculated
 * and in the case of no errors saved.
 * @subpackage Structs
 */
class NewBusinessCaseCalculateAndSaveRequest extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - documentation: login user
     * @var \StructType\Login
     */
    public $login;
    /**
     * The inputValues
     * Meta information extracted from the WSDL
     * - documentation: list of input parameters which will be mapped to the model (BusinessObject / VPMS)
     * - maxOccurs: 200
     * @var \StructType\KeyValuePair[]
     */
    public $inputValues;
    /**
     * The businessCaseType
     * @var string
     */
    public $businessCaseType;
    /**
     * The saveStateOfConsultation
     * Meta information extracted from the WSDL
     * - documentation: state of the consultation, which will be used for saving
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $saveStateOfConsultation;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - documentation: customer eVP-ID´s
     * - maxOccurs: 50
     * - minOccurs: 0
     * @var int[]
     */
    public $customer;
    /**
     * The externalContractNumber
     * Meta information extracted from the WSDL
     * - documentation: external contract number
     * - minOccurs: 0
     * @var string
     */
    public $externalContractNumber;
    /**
     * The businessCaseNumber
     * Meta information extracted from the WSDL
     * - documentation: existing id in eVP. if the id doesn´t exist, an exception will be thrown. if the id exists, the consultation will be overwritten
     * - minOccurs: 0
     * @var int
     */
    public $businessCaseNumber;
    /**
     * Constructor method for newBusinessCaseCalculateAndSaveRequest
     * @uses NewBusinessCaseCalculateAndSaveRequest::setLogin()
     * @uses NewBusinessCaseCalculateAndSaveRequest::setInputValues()
     * @uses NewBusinessCaseCalculateAndSaveRequest::setBusinessCaseType()
     * @uses NewBusinessCaseCalculateAndSaveRequest::setSaveStateOfConsultation()
     * @uses NewBusinessCaseCalculateAndSaveRequest::setCustomer()
     * @uses NewBusinessCaseCalculateAndSaveRequest::setExternalContractNumber()
     * @uses NewBusinessCaseCalculateAndSaveRequest::setBusinessCaseNumber()
     * @param \StructType\Login $login
     * @param \StructType\KeyValuePair[] $inputValues
     * @param string $businessCaseType
     * @param string $saveStateOfConsultation
     * @param int[] $customer
     * @param string $externalContractNumber
     * @param int $businessCaseNumber
     */
    public function __construct(\StructType\Login $login = null, array $inputValues = array(), $businessCaseType = null, $saveStateOfConsultation = null, array $customer = array(), $externalContractNumber = null, $businessCaseNumber = null)
    {
        $this
            ->setLogin($login)
            ->setInputValues($inputValues)
            ->setBusinessCaseType($businessCaseType)
            ->setSaveStateOfConsultation($saveStateOfConsultation)
            ->setCustomer($customer)
            ->setExternalContractNumber($externalContractNumber)
            ->setBusinessCaseNumber($businessCaseNumber);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\NewBusinessCaseCalculateAndSaveRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get inputValues value
     * @return \StructType\KeyValuePair[]|null
     */
    public function getInputValues()
    {
        return $this->inputValues;
    }
    /**
     * This method is responsible for validating the values passed to the setInputValues method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInputValues method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInputValuesForArrayConstraintsFromSetInputValues(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newBusinessCaseCalculateAndSaveRequestInputValuesItem) {
            // validation for constraint: itemType
            if (!$newBusinessCaseCalculateAndSaveRequestInputValuesItem instanceof \StructType\KeyValuePair) {
                $invalidValues[] = is_object($newBusinessCaseCalculateAndSaveRequestInputValuesItem) ? get_class($newBusinessCaseCalculateAndSaveRequestInputValuesItem) : sprintf('%s(%s)', gettype($newBusinessCaseCalculateAndSaveRequestInputValuesItem), var_export($newBusinessCaseCalculateAndSaveRequestInputValuesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The inputValues property can only contain items of type \StructType\KeyValuePair, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set inputValues value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePair[] $inputValues
     * @return \StructType\NewBusinessCaseCalculateAndSaveRequest
     */
    public function setInputValues(array $inputValues = array())
    {
        // validation for constraint: array
        if ('' !== ($inputValuesArrayErrorMessage = self::validateInputValuesForArrayConstraintsFromSetInputValues($inputValues))) {
            throw new \InvalidArgumentException($inputValuesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(200)
        if (is_array($inputValues) && count($inputValues) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 200', count($inputValues)), __LINE__);
        }
        $this->inputValues = $inputValues;
        return $this;
    }
    /**
     * Add item to inputValues value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePair $item
     * @return \StructType\NewBusinessCaseCalculateAndSaveRequest
     */
    public function addToInputValues(\StructType\KeyValuePair $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValuePair) {
            throw new \InvalidArgumentException(sprintf('The inputValues property can only contain items of type \StructType\KeyValuePair, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(200)
        if (is_array($this->inputValues) && count($this->inputValues) >= 200) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 200', count($this->inputValues)), __LINE__);
        }
        $this->inputValues[] = $item;
        return $this;
    }
    /**
     * Get businessCaseType value
     * @return string|null
     */
    public function getBusinessCaseType()
    {
        return $this->businessCaseType;
    }
    /**
     * Set businessCaseType value
     * @uses \EnumType\BusinessCaseType::valueIsValid()
     * @uses \EnumType\BusinessCaseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $businessCaseType
     * @return \StructType\NewBusinessCaseCalculateAndSaveRequest
     */
    public function setBusinessCaseType($businessCaseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessCaseType::valueIsValid($businessCaseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessCaseType', is_array($businessCaseType) ? implode(', ', $businessCaseType) : var_export($businessCaseType, true), implode(', ', \EnumType\BusinessCaseType::getValidValues())), __LINE__);
        }
        $this->businessCaseType = $businessCaseType;
        return $this;
    }
    /**
     * Get saveStateOfConsultation value
     * @return string|null
     */
    public function getSaveStateOfConsultation()
    {
        return $this->saveStateOfConsultation;
    }
    /**
     * Set saveStateOfConsultation value
     * @param string $saveStateOfConsultation
     * @return \StructType\NewBusinessCaseCalculateAndSaveRequest
     */
    public function setSaveStateOfConsultation($saveStateOfConsultation = null)
    {
        // validation for constraint: string
        if (!is_null($saveStateOfConsultation) && !is_string($saveStateOfConsultation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saveStateOfConsultation, true), gettype($saveStateOfConsultation)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($saveStateOfConsultation) && mb_strlen($saveStateOfConsultation) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($saveStateOfConsultation)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($saveStateOfConsultation) && mb_strlen($saveStateOfConsultation) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($saveStateOfConsultation)), __LINE__);
        }
        $this->saveStateOfConsultation = $saveStateOfConsultation;
        return $this;
    }
    /**
     * Get customer value
     * @return int[]|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerForArrayConstraintsFromSetCustomer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newBusinessCaseCalculateAndSaveRequestCustomerItem) {
            // validation for constraint: itemType
            if (!(is_int($newBusinessCaseCalculateAndSaveRequestCustomerItem) || ctype_digit($newBusinessCaseCalculateAndSaveRequestCustomerItem))) {
                $invalidValues[] = is_object($newBusinessCaseCalculateAndSaveRequestCustomerItem) ? get_class($newBusinessCaseCalculateAndSaveRequestCustomerItem) : sprintf('%s(%s)', gettype($newBusinessCaseCalculateAndSaveRequestCustomerItem), var_export($newBusinessCaseCalculateAndSaveRequestCustomerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customer property can only contain items of type integer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customer value
     * @throws \InvalidArgumentException
     * @param int[] $customer
     * @return \StructType\NewBusinessCaseCalculateAndSaveRequest
     */
    public function setCustomer(array $customer = array())
    {
        // validation for constraint: array
        if ('' !== ($customerArrayErrorMessage = self::validateCustomerForArrayConstraintsFromSetCustomer($customer))) {
            throw new \InvalidArgumentException($customerArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($customer) && count($customer) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 50', count($customer)), __LINE__);
        }
        $this->customer = $customer;
        return $this;
    }
    /**
     * Add item to customer value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\NewBusinessCaseCalculateAndSaveRequest
     */
    public function addToCustomer($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The customer property can only contain items of type integer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($this->customer) && count($this->customer) >= 50) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 50', count($this->customer)), __LINE__);
        }
        $this->customer[] = $item;
        return $this;
    }
    /**
     * Get externalContractNumber value
     * @return string|null
     */
    public function getExternalContractNumber()
    {
        return $this->externalContractNumber;
    }
    /**
     * Set externalContractNumber value
     * @param string $externalContractNumber
     * @return \StructType\NewBusinessCaseCalculateAndSaveRequest
     */
    public function setExternalContractNumber($externalContractNumber = null)
    {
        // validation for constraint: string
        if (!is_null($externalContractNumber) && !is_string($externalContractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalContractNumber, true), gettype($externalContractNumber)), __LINE__);
        }
        $this->externalContractNumber = $externalContractNumber;
        return $this;
    }
    /**
     * Get businessCaseNumber value
     * @return int|null
     */
    public function getBusinessCaseNumber()
    {
        return $this->businessCaseNumber;
    }
    /**
     * Set businessCaseNumber value
     * @param int $businessCaseNumber
     * @return \StructType\NewBusinessCaseCalculateAndSaveRequest
     */
    public function setBusinessCaseNumber($businessCaseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($businessCaseNumber) && !(is_int($businessCaseNumber) || ctype_digit($businessCaseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessCaseNumber, true), gettype($businessCaseNumber)), __LINE__);
        }
        $this->businessCaseNumber = $businessCaseNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NewBusinessCaseCalculateAndSaveRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
