<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Message StructType
 * Meta information extracted from the WSDL
 * - documentation: Nachricht
 * @subpackage Structs
 */
class Message extends AbstractStructBase
{
    /**
     * The messageHeader
     * Meta information extracted from the WSDL
     * - documentation: Betreff
     * @var \StructType\MessageHeader
     */
    public $messageHeader;
    /**
     * The content
     * Meta information extracted from the WSDL
     * - documentation: Nachricht Inhalt
     * @var string
     */
    public $content;
    /**
     * The sender
     * Meta information extracted from the WSDL
     * - documentation: Absender
     * @var string
     */
    public $sender;
    /**
     * The answerable
     * Meta information extracted from the WSDL
     * - documentation: Kann man auf die Nachricht antworten
     * @var bool
     */
    public $answerable;
    /**
     * The agreeable
     * Meta information extracted from the WSDL
     * - documentation: Kann man auf die Nachricht zustimmen
     * @var bool
     */
    public $agreeable;
    /**
     * The attachment
     * Meta information extracted from the WSDL
     * - documentation: Anhang
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Attachment[]
     */
    public $attachment;
    /**
     * Constructor method for Message
     * @uses Message::setMessageHeader()
     * @uses Message::setContent()
     * @uses Message::setSender()
     * @uses Message::setAnswerable()
     * @uses Message::setAgreeable()
     * @uses Message::setAttachment()
     * @param \StructType\MessageHeader $messageHeader
     * @param string $content
     * @param string $sender
     * @param bool $answerable
     * @param bool $agreeable
     * @param \StructType\Attachment[] $attachment
     */
    public function __construct(\StructType\MessageHeader $messageHeader = null, $content = null, $sender = null, $answerable = null, $agreeable = null, array $attachment = array())
    {
        $this
            ->setMessageHeader($messageHeader)
            ->setContent($content)
            ->setSender($sender)
            ->setAnswerable($answerable)
            ->setAgreeable($agreeable)
            ->setAttachment($attachment);
    }
    /**
     * Get messageHeader value
     * @return \StructType\MessageHeader|null
     */
    public function getMessageHeader()
    {
        return $this->messageHeader;
    }
    /**
     * Set messageHeader value
     * @param \StructType\MessageHeader $messageHeader
     * @return \StructType\Message
     */
    public function setMessageHeader(\StructType\MessageHeader $messageHeader = null)
    {
        $this->messageHeader = $messageHeader;
        return $this;
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \StructType\Message
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content, true), gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get sender value
     * @return string|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param string $sender
     * @return \StructType\Message
     */
    public function setSender($sender = null)
    {
        // validation for constraint: string
        if (!is_null($sender) && !is_string($sender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sender, true), gettype($sender)), __LINE__);
        }
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get answerable value
     * @return bool|null
     */
    public function getAnswerable()
    {
        return $this->answerable;
    }
    /**
     * Set answerable value
     * @param bool $answerable
     * @return \StructType\Message
     */
    public function setAnswerable($answerable = null)
    {
        // validation for constraint: boolean
        if (!is_null($answerable) && !is_bool($answerable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($answerable, true), gettype($answerable)), __LINE__);
        }
        $this->answerable = $answerable;
        return $this;
    }
    /**
     * Get agreeable value
     * @return bool|null
     */
    public function getAgreeable()
    {
        return $this->agreeable;
    }
    /**
     * Set agreeable value
     * @param bool $agreeable
     * @return \StructType\Message
     */
    public function setAgreeable($agreeable = null)
    {
        // validation for constraint: boolean
        if (!is_null($agreeable) && !is_bool($agreeable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($agreeable, true), gettype($agreeable)), __LINE__);
        }
        $this->agreeable = $agreeable;
        return $this;
    }
    /**
     * Get attachment value
     * @return \StructType\Attachment[]|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentForArrayConstraintsFromSetAttachment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $messageAttachmentItem) {
            // validation for constraint: itemType
            if (!$messageAttachmentItem instanceof \StructType\Attachment) {
                $invalidValues[] = is_object($messageAttachmentItem) ? get_class($messageAttachmentItem) : sprintf('%s(%s)', gettype($messageAttachmentItem), var_export($messageAttachmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment[] $attachment
     * @return \StructType\Message
     */
    public function setAttachment(array $attachment = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentArrayErrorMessage = self::validateAttachmentForArrayConstraintsFromSetAttachment($attachment))) {
            throw new \InvalidArgumentException($attachmentArrayErrorMessage, __LINE__);
        }
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Add item to attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment $item
     * @return \StructType\Message
     */
    public function addToAttachment(\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attachment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Message
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
