<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kundenportalSetAdvisorRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Kundenportal Betreuer festlegen Request
 * @subpackage Structs
 */
class KundenportalSetAdvisorRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The advisor
     * @var string
     */
    public $advisor;
    /**
     * Constructor method for kundenportalSetAdvisorRequest
     * @uses KundenportalSetAdvisorRequest::setLogin()
     * @uses KundenportalSetAdvisorRequest::setAdvisor()
     * @param \StructType\Login $login
     * @param string $advisor
     */
    public function __construct(\StructType\Login $login = null, $advisor = null)
    {
        $this
            ->setLogin($login)
            ->setAdvisor($advisor);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\KundenportalSetAdvisorRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get advisor value
     * @return string|null
     */
    public function getAdvisor()
    {
        return $this->advisor;
    }
    /**
     * Set advisor value
     * @param string $advisor
     * @return \StructType\KundenportalSetAdvisorRequest
     */
    public function setAdvisor($advisor = null)
    {
        // validation for constraint: string
        if (!is_null($advisor) && !is_string($advisor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advisor, true), gettype($advisor)), __LINE__);
        }
        $this->advisor = $advisor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenportalSetAdvisorRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
