<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kundenportalResendActivationLinkRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Kundenportal Resend Activation Link Request
 * @subpackage Structs
 */
class KundenportalResendActivationLinkRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The paoid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $paoid;
    /**
     * Constructor method for kundenportalResendActivationLinkRequest
     * @uses KundenportalResendActivationLinkRequest::setLogin()
     * @uses KundenportalResendActivationLinkRequest::setEmail()
     * @uses KundenportalResendActivationLinkRequest::setPaoid()
     * @param \StructType\Login $login
     * @param string $email
     * @param string $paoid
     */
    public function __construct(\StructType\Login $login = null, $email = null, $paoid = null)
    {
        $this
            ->setLogin($login)
            ->setEmail($email)
            ->setPaoid($paoid);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\KundenportalResendActivationLinkRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\KundenportalResendActivationLinkRequest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get paoid value
     * @return string|null
     */
    public function getPaoid()
    {
        return $this->paoid;
    }
    /**
     * Set paoid value
     * @param string $paoid
     * @return \StructType\KundenportalResendActivationLinkRequest
     */
    public function setPaoid($paoid = null)
    {
        // validation for constraint: string
        if (!is_null($paoid) && !is_string($paoid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paoid, true), gettype($paoid)), __LINE__);
        }
        $this->paoid = $paoid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenportalResendActivationLinkRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
