<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kaskoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Felder für Generali-Kasko
 * @subpackage Structs
 */
class KaskoType extends AbstractStructBase
{
    /**
     * The kaskoVersicherungsart
     * @var string
     */
    public $kaskoVersicherungsart;
    /**
     * The mindestSelbstbeteiligung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $mindestSelbstbeteiligung;
    /**
     * The vorsteuerErsetzen
     * @var string
     */
    public $vorsteuerErsetzen;
    /**
     * The kleinGlasUndMehr
     * Meta information extracted from the WSDL
     * - documentation: Kleinglas und mehr (ohne SB; Kleinglasschäden, Verlust persönlicher Gegenstände bis EUR 1.000,-)
     * - minOccurs: 0
     * @var string
     */
    public $kleinGlasUndMehr;
    /**
     * The grossglasReduktionSB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $grossglasReduktionSB;
    /**
     * The gapDeckung
     * Meta information extracted from the WSDL
     * - documentation: Leasing-Auflösewert
     * - minOccurs: 0
     * @var string
     */
    public $gapDeckung;
    /**
     * The neuwertklausel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $neuwertklausel;
    /**
     * The unfallDoppelterSB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $unfallDoppelterSB;
    /**
     * The garagenrisiko
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $garagenrisiko;
    /**
     * The naturgewaltenOhneSelbstbeteiligung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $naturgewaltenOhneSelbstbeteiligung;
    /**
     * The zusatzschutzBeiFahrlaessigemVerhalten
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zusatzschutzBeiFahrlaessigemVerhalten;
    /**
     * The carSharingVorteil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $carSharingVorteil;
    /**
     * The tipUndTatKfzAktiv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipUndTatKfzAktiv;
    /**
     * The kfzEuropaschutz
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kfzEuropaschutz;
    /**
     * The tipUndTatReparaturkosten
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipUndTatReparaturkosten;
    /**
     * The tipUndTatReparaturkostenSelbstbeteiligung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $tipUndTatReparaturkostenSelbstbeteiligung;
    /**
     * The sonderausstattung
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\SonderausstattungTyp[]
     */
    public $sonderausstattung;
    /**
     * Constructor method for kaskoType
     * @uses KaskoType::setKaskoVersicherungsart()
     * @uses KaskoType::setMindestSelbstbeteiligung()
     * @uses KaskoType::setVorsteuerErsetzen()
     * @uses KaskoType::setKleinGlasUndMehr()
     * @uses KaskoType::setGrossglasReduktionSB()
     * @uses KaskoType::setGapDeckung()
     * @uses KaskoType::setNeuwertklausel()
     * @uses KaskoType::setUnfallDoppelterSB()
     * @uses KaskoType::setGaragenrisiko()
     * @uses KaskoType::setNaturgewaltenOhneSelbstbeteiligung()
     * @uses KaskoType::setZusatzschutzBeiFahrlaessigemVerhalten()
     * @uses KaskoType::setCarSharingVorteil()
     * @uses KaskoType::setTipUndTatKfzAktiv()
     * @uses KaskoType::setKfzEuropaschutz()
     * @uses KaskoType::setTipUndTatReparaturkosten()
     * @uses KaskoType::setTipUndTatReparaturkostenSelbstbeteiligung()
     * @uses KaskoType::setSonderausstattung()
     * @param string $kaskoVersicherungsart
     * @param int $mindestSelbstbeteiligung
     * @param string $vorsteuerErsetzen
     * @param string $kleinGlasUndMehr
     * @param string $grossglasReduktionSB
     * @param string $gapDeckung
     * @param string $neuwertklausel
     * @param string $unfallDoppelterSB
     * @param string $garagenrisiko
     * @param string $naturgewaltenOhneSelbstbeteiligung
     * @param string $zusatzschutzBeiFahrlaessigemVerhalten
     * @param string $carSharingVorteil
     * @param string $tipUndTatKfzAktiv
     * @param string $kfzEuropaschutz
     * @param string $tipUndTatReparaturkosten
     * @param int $tipUndTatReparaturkostenSelbstbeteiligung
     * @param \StructType\SonderausstattungTyp[] $sonderausstattung
     */
    public function __construct($kaskoVersicherungsart = null, $mindestSelbstbeteiligung = null, $vorsteuerErsetzen = null, $kleinGlasUndMehr = null, $grossglasReduktionSB = null, $gapDeckung = null, $neuwertklausel = null, $unfallDoppelterSB = null, $garagenrisiko = null, $naturgewaltenOhneSelbstbeteiligung = null, $zusatzschutzBeiFahrlaessigemVerhalten = null, $carSharingVorteil = null, $tipUndTatKfzAktiv = null, $kfzEuropaschutz = null, $tipUndTatReparaturkosten = null, $tipUndTatReparaturkostenSelbstbeteiligung = null, array $sonderausstattung = array())
    {
        $this
            ->setKaskoVersicherungsart($kaskoVersicherungsart)
            ->setMindestSelbstbeteiligung($mindestSelbstbeteiligung)
            ->setVorsteuerErsetzen($vorsteuerErsetzen)
            ->setKleinGlasUndMehr($kleinGlasUndMehr)
            ->setGrossglasReduktionSB($grossglasReduktionSB)
            ->setGapDeckung($gapDeckung)
            ->setNeuwertklausel($neuwertklausel)
            ->setUnfallDoppelterSB($unfallDoppelterSB)
            ->setGaragenrisiko($garagenrisiko)
            ->setNaturgewaltenOhneSelbstbeteiligung($naturgewaltenOhneSelbstbeteiligung)
            ->setZusatzschutzBeiFahrlaessigemVerhalten($zusatzschutzBeiFahrlaessigemVerhalten)
            ->setCarSharingVorteil($carSharingVorteil)
            ->setTipUndTatKfzAktiv($tipUndTatKfzAktiv)
            ->setKfzEuropaschutz($kfzEuropaschutz)
            ->setTipUndTatReparaturkosten($tipUndTatReparaturkosten)
            ->setTipUndTatReparaturkostenSelbstbeteiligung($tipUndTatReparaturkostenSelbstbeteiligung)
            ->setSonderausstattung($sonderausstattung);
    }
    /**
     * Get kaskoVersicherungsart value
     * @return string|null
     */
    public function getKaskoVersicherungsart()
    {
        return $this->kaskoVersicherungsart;
    }
    /**
     * Set kaskoVersicherungsart value
     * @uses \EnumType\KaskoVersicherungsartType::valueIsValid()
     * @uses \EnumType\KaskoVersicherungsartType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kaskoVersicherungsart
     * @return \StructType\KaskoType
     */
    public function setKaskoVersicherungsart($kaskoVersicherungsart = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KaskoVersicherungsartType::valueIsValid($kaskoVersicherungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KaskoVersicherungsartType', is_array($kaskoVersicherungsart) ? implode(', ', $kaskoVersicherungsart) : var_export($kaskoVersicherungsart, true), implode(', ', \EnumType\KaskoVersicherungsartType::getValidValues())), __LINE__);
        }
        $this->kaskoVersicherungsart = $kaskoVersicherungsart;
        return $this;
    }
    /**
     * Get mindestSelbstbeteiligung value
     * @return int|null
     */
    public function getMindestSelbstbeteiligung()
    {
        return $this->mindestSelbstbeteiligung;
    }
    /**
     * Set mindestSelbstbeteiligung value
     * @param int $mindestSelbstbeteiligung
     * @return \StructType\KaskoType
     */
    public function setMindestSelbstbeteiligung($mindestSelbstbeteiligung = null)
    {
        // validation for constraint: int
        if (!is_null($mindestSelbstbeteiligung) && !(is_int($mindestSelbstbeteiligung) || ctype_digit($mindestSelbstbeteiligung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mindestSelbstbeteiligung, true), gettype($mindestSelbstbeteiligung)), __LINE__);
        }
        $this->mindestSelbstbeteiligung = $mindestSelbstbeteiligung;
        return $this;
    }
    /**
     * Get vorsteuerErsetzen value
     * @return string|null
     */
    public function getVorsteuerErsetzen()
    {
        return $this->vorsteuerErsetzen;
    }
    /**
     * Set vorsteuerErsetzen value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vorsteuerErsetzen
     * @return \StructType\KaskoType
     */
    public function setVorsteuerErsetzen($vorsteuerErsetzen = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($vorsteuerErsetzen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($vorsteuerErsetzen) ? implode(', ', $vorsteuerErsetzen) : var_export($vorsteuerErsetzen, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->vorsteuerErsetzen = $vorsteuerErsetzen;
        return $this;
    }
    /**
     * Get kleinGlasUndMehr value
     * @return string|null
     */
    public function getKleinGlasUndMehr()
    {
        return $this->kleinGlasUndMehr;
    }
    /**
     * Set kleinGlasUndMehr value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kleinGlasUndMehr
     * @return \StructType\KaskoType
     */
    public function setKleinGlasUndMehr($kleinGlasUndMehr = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($kleinGlasUndMehr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($kleinGlasUndMehr) ? implode(', ', $kleinGlasUndMehr) : var_export($kleinGlasUndMehr, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->kleinGlasUndMehr = $kleinGlasUndMehr;
        return $this;
    }
    /**
     * Get grossglasReduktionSB value
     * @return string|null
     */
    public function getGrossglasReduktionSB()
    {
        return $this->grossglasReduktionSB;
    }
    /**
     * Set grossglasReduktionSB value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $grossglasReduktionSB
     * @return \StructType\KaskoType
     */
    public function setGrossglasReduktionSB($grossglasReduktionSB = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($grossglasReduktionSB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($grossglasReduktionSB) ? implode(', ', $grossglasReduktionSB) : var_export($grossglasReduktionSB, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->grossglasReduktionSB = $grossglasReduktionSB;
        return $this;
    }
    /**
     * Get gapDeckung value
     * @return string|null
     */
    public function getGapDeckung()
    {
        return $this->gapDeckung;
    }
    /**
     * Set gapDeckung value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gapDeckung
     * @return \StructType\KaskoType
     */
    public function setGapDeckung($gapDeckung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($gapDeckung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($gapDeckung) ? implode(', ', $gapDeckung) : var_export($gapDeckung, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->gapDeckung = $gapDeckung;
        return $this;
    }
    /**
     * Get neuwertklausel value
     * @return string|null
     */
    public function getNeuwertklausel()
    {
        return $this->neuwertklausel;
    }
    /**
     * Set neuwertklausel value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $neuwertklausel
     * @return \StructType\KaskoType
     */
    public function setNeuwertklausel($neuwertklausel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($neuwertklausel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($neuwertklausel) ? implode(', ', $neuwertklausel) : var_export($neuwertklausel, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->neuwertklausel = $neuwertklausel;
        return $this;
    }
    /**
     * Get unfallDoppelterSB value
     * @return string|null
     */
    public function getUnfallDoppelterSB()
    {
        return $this->unfallDoppelterSB;
    }
    /**
     * Set unfallDoppelterSB value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unfallDoppelterSB
     * @return \StructType\KaskoType
     */
    public function setUnfallDoppelterSB($unfallDoppelterSB = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($unfallDoppelterSB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($unfallDoppelterSB) ? implode(', ', $unfallDoppelterSB) : var_export($unfallDoppelterSB, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->unfallDoppelterSB = $unfallDoppelterSB;
        return $this;
    }
    /**
     * Get garagenrisiko value
     * @return string|null
     */
    public function getGaragenrisiko()
    {
        return $this->garagenrisiko;
    }
    /**
     * Set garagenrisiko value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $garagenrisiko
     * @return \StructType\KaskoType
     */
    public function setGaragenrisiko($garagenrisiko = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($garagenrisiko)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($garagenrisiko) ? implode(', ', $garagenrisiko) : var_export($garagenrisiko, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->garagenrisiko = $garagenrisiko;
        return $this;
    }
    /**
     * Get naturgewaltenOhneSelbstbeteiligung value
     * @return string|null
     */
    public function getNaturgewaltenOhneSelbstbeteiligung()
    {
        return $this->naturgewaltenOhneSelbstbeteiligung;
    }
    /**
     * Set naturgewaltenOhneSelbstbeteiligung value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $naturgewaltenOhneSelbstbeteiligung
     * @return \StructType\KaskoType
     */
    public function setNaturgewaltenOhneSelbstbeteiligung($naturgewaltenOhneSelbstbeteiligung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($naturgewaltenOhneSelbstbeteiligung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($naturgewaltenOhneSelbstbeteiligung) ? implode(', ', $naturgewaltenOhneSelbstbeteiligung) : var_export($naturgewaltenOhneSelbstbeteiligung, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->naturgewaltenOhneSelbstbeteiligung = $naturgewaltenOhneSelbstbeteiligung;
        return $this;
    }
    /**
     * Get zusatzschutzBeiFahrlaessigemVerhalten value
     * @return string|null
     */
    public function getZusatzschutzBeiFahrlaessigemVerhalten()
    {
        return $this->zusatzschutzBeiFahrlaessigemVerhalten;
    }
    /**
     * Set zusatzschutzBeiFahrlaessigemVerhalten value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zusatzschutzBeiFahrlaessigemVerhalten
     * @return \StructType\KaskoType
     */
    public function setZusatzschutzBeiFahrlaessigemVerhalten($zusatzschutzBeiFahrlaessigemVerhalten = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($zusatzschutzBeiFahrlaessigemVerhalten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($zusatzschutzBeiFahrlaessigemVerhalten) ? implode(', ', $zusatzschutzBeiFahrlaessigemVerhalten) : var_export($zusatzschutzBeiFahrlaessigemVerhalten, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->zusatzschutzBeiFahrlaessigemVerhalten = $zusatzschutzBeiFahrlaessigemVerhalten;
        return $this;
    }
    /**
     * Get carSharingVorteil value
     * @return string|null
     */
    public function getCarSharingVorteil()
    {
        return $this->carSharingVorteil;
    }
    /**
     * Set carSharingVorteil value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carSharingVorteil
     * @return \StructType\KaskoType
     */
    public function setCarSharingVorteil($carSharingVorteil = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($carSharingVorteil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($carSharingVorteil) ? implode(', ', $carSharingVorteil) : var_export($carSharingVorteil, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->carSharingVorteil = $carSharingVorteil;
        return $this;
    }
    /**
     * Get tipUndTatKfzAktiv value
     * @return string|null
     */
    public function getTipUndTatKfzAktiv()
    {
        return $this->tipUndTatKfzAktiv;
    }
    /**
     * Set tipUndTatKfzAktiv value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipUndTatKfzAktiv
     * @return \StructType\KaskoType
     */
    public function setTipUndTatKfzAktiv($tipUndTatKfzAktiv = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($tipUndTatKfzAktiv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($tipUndTatKfzAktiv) ? implode(', ', $tipUndTatKfzAktiv) : var_export($tipUndTatKfzAktiv, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->tipUndTatKfzAktiv = $tipUndTatKfzAktiv;
        return $this;
    }
    /**
     * Get kfzEuropaschutz value
     * @return string|null
     */
    public function getKfzEuropaschutz()
    {
        return $this->kfzEuropaschutz;
    }
    /**
     * Set kfzEuropaschutz value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kfzEuropaschutz
     * @return \StructType\KaskoType
     */
    public function setKfzEuropaschutz($kfzEuropaschutz = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($kfzEuropaschutz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($kfzEuropaschutz) ? implode(', ', $kfzEuropaschutz) : var_export($kfzEuropaschutz, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->kfzEuropaschutz = $kfzEuropaschutz;
        return $this;
    }
    /**
     * Get tipUndTatReparaturkosten value
     * @return string|null
     */
    public function getTipUndTatReparaturkosten()
    {
        return $this->tipUndTatReparaturkosten;
    }
    /**
     * Set tipUndTatReparaturkosten value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipUndTatReparaturkosten
     * @return \StructType\KaskoType
     */
    public function setTipUndTatReparaturkosten($tipUndTatReparaturkosten = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($tipUndTatReparaturkosten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($tipUndTatReparaturkosten) ? implode(', ', $tipUndTatReparaturkosten) : var_export($tipUndTatReparaturkosten, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->tipUndTatReparaturkosten = $tipUndTatReparaturkosten;
        return $this;
    }
    /**
     * Get tipUndTatReparaturkostenSelbstbeteiligung value
     * @return int|null
     */
    public function getTipUndTatReparaturkostenSelbstbeteiligung()
    {
        return $this->tipUndTatReparaturkostenSelbstbeteiligung;
    }
    /**
     * Set tipUndTatReparaturkostenSelbstbeteiligung value
     * @param int $tipUndTatReparaturkostenSelbstbeteiligung
     * @return \StructType\KaskoType
     */
    public function setTipUndTatReparaturkostenSelbstbeteiligung($tipUndTatReparaturkostenSelbstbeteiligung = null)
    {
        // validation for constraint: int
        if (!is_null($tipUndTatReparaturkostenSelbstbeteiligung) && !(is_int($tipUndTatReparaturkostenSelbstbeteiligung) || ctype_digit($tipUndTatReparaturkostenSelbstbeteiligung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipUndTatReparaturkostenSelbstbeteiligung, true), gettype($tipUndTatReparaturkostenSelbstbeteiligung)), __LINE__);
        }
        $this->tipUndTatReparaturkostenSelbstbeteiligung = $tipUndTatReparaturkostenSelbstbeteiligung;
        return $this;
    }
    /**
     * Get sonderausstattung value
     * @return \StructType\SonderausstattungTyp[]|null
     */
    public function getSonderausstattung()
    {
        return $this->sonderausstattung;
    }
    /**
     * This method is responsible for validating the values passed to the setSonderausstattung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSonderausstattung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSonderausstattungForArrayConstraintsFromSetSonderausstattung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kaskoTypeSonderausstattungItem) {
            // validation for constraint: itemType
            if (!$kaskoTypeSonderausstattungItem instanceof \StructType\SonderausstattungTyp) {
                $invalidValues[] = is_object($kaskoTypeSonderausstattungItem) ? get_class($kaskoTypeSonderausstattungItem) : sprintf('%s(%s)', gettype($kaskoTypeSonderausstattungItem), var_export($kaskoTypeSonderausstattungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sonderausstattung property can only contain items of type \StructType\SonderausstattungTyp, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sonderausstattung value
     * @throws \InvalidArgumentException
     * @param \StructType\SonderausstattungTyp[] $sonderausstattung
     * @return \StructType\KaskoType
     */
    public function setSonderausstattung(array $sonderausstattung = array())
    {
        // validation for constraint: array
        if ('' !== ($sonderausstattungArrayErrorMessage = self::validateSonderausstattungForArrayConstraintsFromSetSonderausstattung($sonderausstattung))) {
            throw new \InvalidArgumentException($sonderausstattungArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($sonderausstattung) && count($sonderausstattung) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($sonderausstattung)), __LINE__);
        }
        $this->sonderausstattung = $sonderausstattung;
        return $this;
    }
    /**
     * Add item to sonderausstattung value
     * @throws \InvalidArgumentException
     * @param \StructType\SonderausstattungTyp $item
     * @return \StructType\KaskoType
     */
    public function addToSonderausstattung(\StructType\SonderausstattungTyp $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SonderausstattungTyp) {
            throw new \InvalidArgumentException(sprintf('The sonderausstattung property can only contain items of type \StructType\SonderausstattungTyp, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->sonderausstattung) && count($this->sonderausstattung) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->sonderausstattung)), __LINE__);
        }
        $this->sonderausstattung[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KaskoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
