<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ITAssistance StructType
 * @subpackage Structs
 */
class ITAssistance extends AbstractStructBase
{
    /**
     * The paoid
     * Meta information extracted from the WSDL
     * - documentation: unique customernumber
     * @var string
     */
    public $paoid;
    /**
     * The referencenumber
     * Meta information extracted from the WSDL
     * - documentation: unique file number of support
     * @var string
     */
    public $referencenumber;
    /**
     * The chat
     * Meta information extracted from the WSDL
     * - documentation: full chat conversion
     * - maxOccurs: unbounded
     * @var \StructType\Chat[]
     */
    public $chat;
    /**
     * The attachments
     * Meta information extracted from the WSDL
     * - documentation: attachments
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Attachment[]
     */
    public $attachments;
    /**
     * Constructor method for ITAssistance
     * @uses ITAssistance::setPaoid()
     * @uses ITAssistance::setReferencenumber()
     * @uses ITAssistance::setChat()
     * @uses ITAssistance::setAttachments()
     * @param string $paoid
     * @param string $referencenumber
     * @param \StructType\Chat[] $chat
     * @param \StructType\Attachment[] $attachments
     */
    public function __construct($paoid = null, $referencenumber = null, array $chat = array(), array $attachments = array())
    {
        $this
            ->setPaoid($paoid)
            ->setReferencenumber($referencenumber)
            ->setChat($chat)
            ->setAttachments($attachments);
    }
    /**
     * Get paoid value
     * @return string|null
     */
    public function getPaoid()
    {
        return $this->paoid;
    }
    /**
     * Set paoid value
     * @param string $paoid
     * @return \StructType\ITAssistance
     */
    public function setPaoid($paoid = null)
    {
        // validation for constraint: string
        if (!is_null($paoid) && !is_string($paoid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paoid, true), gettype($paoid)), __LINE__);
        }
        $this->paoid = $paoid;
        return $this;
    }
    /**
     * Get referencenumber value
     * @return string|null
     */
    public function getReferencenumber()
    {
        return $this->referencenumber;
    }
    /**
     * Set referencenumber value
     * @param string $referencenumber
     * @return \StructType\ITAssistance
     */
    public function setReferencenumber($referencenumber = null)
    {
        // validation for constraint: string
        if (!is_null($referencenumber) && !is_string($referencenumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencenumber, true), gettype($referencenumber)), __LINE__);
        }
        $this->referencenumber = $referencenumber;
        return $this;
    }
    /**
     * Get chat value
     * @return \StructType\Chat[]|null
     */
    public function getChat()
    {
        return $this->chat;
    }
    /**
     * This method is responsible for validating the values passed to the setChat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChatForArrayConstraintsFromSetChat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $iTAssistanceChatItem) {
            // validation for constraint: itemType
            if (!$iTAssistanceChatItem instanceof \StructType\Chat) {
                $invalidValues[] = is_object($iTAssistanceChatItem) ? get_class($iTAssistanceChatItem) : sprintf('%s(%s)', gettype($iTAssistanceChatItem), var_export($iTAssistanceChatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The chat property can only contain items of type \StructType\Chat, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set chat value
     * @throws \InvalidArgumentException
     * @param \StructType\Chat[] $chat
     * @return \StructType\ITAssistance
     */
    public function setChat(array $chat = array())
    {
        // validation for constraint: array
        if ('' !== ($chatArrayErrorMessage = self::validateChatForArrayConstraintsFromSetChat($chat))) {
            throw new \InvalidArgumentException($chatArrayErrorMessage, __LINE__);
        }
        $this->chat = $chat;
        return $this;
    }
    /**
     * Add item to chat value
     * @throws \InvalidArgumentException
     * @param \StructType\Chat $item
     * @return \StructType\ITAssistance
     */
    public function addToChat(\StructType\Chat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Chat) {
            throw new \InvalidArgumentException(sprintf('The chat property can only contain items of type \StructType\Chat, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->chat[] = $item;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\Attachment[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentsForArrayConstraintsFromSetAttachments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $iTAssistanceAttachmentsItem) {
            // validation for constraint: itemType
            if (!$iTAssistanceAttachmentsItem instanceof \StructType\Attachment) {
                $invalidValues[] = is_object($iTAssistanceAttachmentsItem) ? get_class($iTAssistanceAttachmentsItem) : sprintf('%s(%s)', gettype($iTAssistanceAttachmentsItem), var_export($iTAssistanceAttachmentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attachments property can only contain items of type \StructType\Attachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment[] $attachments
     * @return \StructType\ITAssistance
     */
    public function setAttachments(array $attachments = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentsArrayErrorMessage = self::validateAttachmentsForArrayConstraintsFromSetAttachments($attachments))) {
            throw new \InvalidArgumentException($attachmentsArrayErrorMessage, __LINE__);
        }
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment $item
     * @return \StructType\ITAssistance
     */
    public function addToAttachments(\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of type \StructType\Attachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ITAssistance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
