<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HoraAdress StructType
 * Meta information extracted from the WSDL
 * - documentation: Adressobjekt for getHoraZone
 * @subpackage Structs
 */
class HoraAdress extends AbstractStructBase
{
    /**
     * The street
     * Meta information extracted from the WSDL
     * - documentation: Strasse
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $street;
    /**
     * The houseNumber
     * Meta information extracted from the WSDL
     * - documentation: Hausnummer
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $houseNumber;
    /**
     * The additionalDetails
     * Meta information extracted from the WSDL
     * - documentation: Zusätzliche Daten wie z.B. Stiege
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $additionalDetails;
    /**
     * The streetPoBox
     * Meta information extracted from the WSDL
     * - documentation: Postleitzahl
     * - base: xsd:string
     * - maxLength: 10
     * @var string
     */
    public $streetPoBox;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - documentation: Stadt
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $city;
    /**
     * Constructor method for HoraAdress
     * @uses HoraAdress::setStreet()
     * @uses HoraAdress::setHouseNumber()
     * @uses HoraAdress::setAdditionalDetails()
     * @uses HoraAdress::setStreetPoBox()
     * @uses HoraAdress::setCity()
     * @param string $street
     * @param string $houseNumber
     * @param string $additionalDetails
     * @param string $streetPoBox
     * @param string $city
     */
    public function __construct($street = null, $houseNumber = null, $additionalDetails = null, $streetPoBox = null, $city = null)
    {
        $this
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setAdditionalDetails($additionalDetails)
            ->setStreetPoBox($streetPoBox)
            ->setCity($city);
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\HoraAdress
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($street) && mb_strlen($street) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \StructType\HoraAdress
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($houseNumber) && mb_strlen($houseNumber) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get additionalDetails value
     * @return string|null
     */
    public function getAdditionalDetails()
    {
        return $this->additionalDetails;
    }
    /**
     * Set additionalDetails value
     * @param string $additionalDetails
     * @return \StructType\HoraAdress
     */
    public function setAdditionalDetails($additionalDetails = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDetails) && !is_string($additionalDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalDetails, true), gettype($additionalDetails)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($additionalDetails) && mb_strlen($additionalDetails) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($additionalDetails)), __LINE__);
        }
        $this->additionalDetails = $additionalDetails;
        return $this;
    }
    /**
     * Get streetPoBox value
     * @return string|null
     */
    public function getStreetPoBox()
    {
        return $this->streetPoBox;
    }
    /**
     * Set streetPoBox value
     * @param string $streetPoBox
     * @return \StructType\HoraAdress
     */
    public function setStreetPoBox($streetPoBox = null)
    {
        // validation for constraint: string
        if (!is_null($streetPoBox) && !is_string($streetPoBox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetPoBox, true), gettype($streetPoBox)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($streetPoBox) && mb_strlen($streetPoBox) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($streetPoBox)), __LINE__);
        }
        $this->streetPoBox = $streetPoBox;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\HoraAdress
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HoraAdress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
