<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HistoryContract StructType
 * Meta information extracted from the WSDL
 * - documentation: Historyobjekt für einen Antrag
 * @subpackage Structs
 */
class HistoryContract extends AbstractStructBase
{
    /**
     * The policyNumber
     * Meta information extracted from the WSDL
     * - documentation: Polizzennummer z.B. : 1/51/12345678 oder 1/51/12345678-01
     * @var string
     */
    public $policyNumber;
    /**
     * Constructor method for HistoryContract
     * @uses HistoryContract::setPolicyNumber()
     * @param string $policyNumber
     */
    public function __construct($policyNumber = null)
    {
        $this
            ->setPolicyNumber($policyNumber);
    }
    /**
     * Get policyNumber value
     * @return string|null
     */
    public function getPolicyNumber()
    {
        return $this->policyNumber;
    }
    /**
     * Set policyNumber value
     * @param string $policyNumber
     * @return \StructType\HistoryContract
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumber) && !is_string($policyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        $this->policyNumber = $policyNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HistoryContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
