<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getUserDataRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request zum Einloggen in der eVP
 * @subpackage Structs
 */
class GetUserDataRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userId;
    /**
     * The paoid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $paoid;
    /**
     * Constructor method for getUserDataRequest
     * @uses GetUserDataRequest::setLogin()
     * @uses GetUserDataRequest::setUserId()
     * @uses GetUserDataRequest::setPaoid()
     * @param \StructType\Login $login
     * @param string $userId
     * @param string $paoid
     */
    public function __construct(\StructType\Login $login = null, $userId = null, $paoid = null)
    {
        $this
            ->setLogin($login)
            ->setUserId($userId)
            ->setPaoid($paoid);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\GetUserDataRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \StructType\GetUserDataRequest
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get paoid value
     * @return string|null
     */
    public function getPaoid()
    {
        return $this->paoid;
    }
    /**
     * Set paoid value
     * @param string $paoid
     * @return \StructType\GetUserDataRequest
     */
    public function setPaoid($paoid = null)
    {
        // validation for constraint: string
        if (!is_null($paoid) && !is_string($paoid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paoid, true), gettype($paoid)), __LINE__);
        }
        $this->paoid = $paoid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetUserDataRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
