<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generaliprivatType StructType
 * @subpackage Structs
 */
class GeneraliprivatType extends AbstractStructBase
{
    /**
     * The header
     * @var \StructType\HeaderType
     */
    public $header;
    /**
     * The risikoAdresse
     * @var \StructType\RisikoAdresseType
     */
    public $risikoAdresse;
    /**
     * The risikoEigenheim
     * Meta information extracted from the WSDL
     * - choice: risikoEigenheim | risikoHHimMFH
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\RisikoEigenheimType
     */
    public $risikoEigenheim;
    /**
     * The risikoHHimMFH
     * Meta information extracted from the WSDL
     * - choice: risikoEigenheim | risikoHHimMFH
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\RisikoHHimMFHType
     */
    public $risikoHHimMFH;
    /**
     * The tarifierungsdaten
     * @var \StructType\TarifierungsdatenType
     */
    public $tarifierungsdaten;
    /**
     * The antragsdaten
     * @var \StructType\AntragsdatenType
     */
    public $antragsdaten;
    /**
     * The rueckmeldung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RueckmeldungType
     */
    public $rueckmeldung;
    /**
     * Constructor method for generaliprivatType
     * @uses GeneraliprivatType::setHeader()
     * @uses GeneraliprivatType::setRisikoAdresse()
     * @uses GeneraliprivatType::setRisikoEigenheim()
     * @uses GeneraliprivatType::setRisikoHHimMFH()
     * @uses GeneraliprivatType::setTarifierungsdaten()
     * @uses GeneraliprivatType::setAntragsdaten()
     * @uses GeneraliprivatType::setRueckmeldung()
     * @param \StructType\HeaderType $header
     * @param \StructType\RisikoAdresseType $risikoAdresse
     * @param \StructType\RisikoEigenheimType $risikoEigenheim
     * @param \StructType\RisikoHHimMFHType $risikoHHimMFH
     * @param \StructType\TarifierungsdatenType $tarifierungsdaten
     * @param \StructType\AntragsdatenType $antragsdaten
     * @param \StructType\RueckmeldungType $rueckmeldung
     */
    public function __construct(\StructType\HeaderType $header = null, \StructType\RisikoAdresseType $risikoAdresse = null, \StructType\RisikoEigenheimType $risikoEigenheim = null, \StructType\RisikoHHimMFHType $risikoHHimMFH = null, \StructType\TarifierungsdatenType $tarifierungsdaten = null, \StructType\AntragsdatenType $antragsdaten = null, \StructType\RueckmeldungType $rueckmeldung = null)
    {
        $this
            ->setHeader($header)
            ->setRisikoAdresse($risikoAdresse)
            ->setRisikoEigenheim($risikoEigenheim)
            ->setRisikoHHimMFH($risikoHHimMFH)
            ->setTarifierungsdaten($tarifierungsdaten)
            ->setAntragsdaten($antragsdaten)
            ->setRueckmeldung($rueckmeldung);
    }
    /**
     * Get header value
     * @return \StructType\HeaderType|null
     */
    public function getHeader()
    {
        return $this->header;
    }
    /**
     * Set header value
     * @param \StructType\HeaderType $header
     * @return \StructType\GeneraliprivatType
     */
    public function setHeader(\StructType\HeaderType $header = null)
    {
        $this->header = $header;
        return $this;
    }
    /**
     * Get risikoAdresse value
     * @return \StructType\RisikoAdresseType|null
     */
    public function getRisikoAdresse()
    {
        return $this->risikoAdresse;
    }
    /**
     * Set risikoAdresse value
     * @param \StructType\RisikoAdresseType $risikoAdresse
     * @return \StructType\GeneraliprivatType
     */
    public function setRisikoAdresse(\StructType\RisikoAdresseType $risikoAdresse = null)
    {
        $this->risikoAdresse = $risikoAdresse;
        return $this;
    }
    /**
     * Get risikoEigenheim value
     * @return \StructType\RisikoEigenheimType|null
     */
    public function getRisikoEigenheim()
    {
        return isset($this->risikoEigenheim) ? $this->risikoEigenheim : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRisikoEigenheim method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRisikoEigenheim method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRisikoEigenheimForChoiceConstraintsFromSetRisikoEigenheim($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'risikoHHimMFH',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property risikoEigenheim can\'t be set as the property %s is already set. Only one property must be set among these properties: risikoEigenheim, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set risikoEigenheim value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RisikoEigenheimType $risikoEigenheim
     * @return \StructType\GeneraliprivatType
     */
    public function setRisikoEigenheim(\StructType\RisikoEigenheimType $risikoEigenheim = null)
    {
        // validation for constraint: choice(risikoEigenheim, risikoHHimMFH)
        if ('' !== ($risikoEigenheimChoiceErrorMessage = self::validateRisikoEigenheimForChoiceConstraintsFromSetRisikoEigenheim($risikoEigenheim))) {
            throw new \InvalidArgumentException($risikoEigenheimChoiceErrorMessage, __LINE__);
        }
        if (is_null($risikoEigenheim) || (is_array($risikoEigenheim) && empty($risikoEigenheim))) {
            unset($this->risikoEigenheim);
        } else {
            $this->risikoEigenheim = $risikoEigenheim;
        }
        return $this;
    }
    /**
     * Get risikoHHimMFH value
     * @return \StructType\RisikoHHimMFHType|null
     */
    public function getRisikoHHimMFH()
    {
        return isset($this->risikoHHimMFH) ? $this->risikoHHimMFH : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRisikoHHimMFH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRisikoHHimMFH method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRisikoHHimMFHForChoiceConstraintsFromSetRisikoHHimMFH($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'risikoEigenheim',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property risikoHHimMFH can\'t be set as the property %s is already set. Only one property must be set among these properties: risikoHHimMFH, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set risikoHHimMFH value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RisikoHHimMFHType $risikoHHimMFH
     * @return \StructType\GeneraliprivatType
     */
    public function setRisikoHHimMFH(\StructType\RisikoHHimMFHType $risikoHHimMFH = null)
    {
        // validation for constraint: choice(risikoEigenheim, risikoHHimMFH)
        if ('' !== ($risikoHHimMFHChoiceErrorMessage = self::validateRisikoHHimMFHForChoiceConstraintsFromSetRisikoHHimMFH($risikoHHimMFH))) {
            throw new \InvalidArgumentException($risikoHHimMFHChoiceErrorMessage, __LINE__);
        }
        if (is_null($risikoHHimMFH) || (is_array($risikoHHimMFH) && empty($risikoHHimMFH))) {
            unset($this->risikoHHimMFH);
        } else {
            $this->risikoHHimMFH = $risikoHHimMFH;
        }
        return $this;
    }
    /**
     * Get tarifierungsdaten value
     * @return \StructType\TarifierungsdatenType|null
     */
    public function getTarifierungsdaten()
    {
        return $this->tarifierungsdaten;
    }
    /**
     * Set tarifierungsdaten value
     * @param \StructType\TarifierungsdatenType $tarifierungsdaten
     * @return \StructType\GeneraliprivatType
     */
    public function setTarifierungsdaten(\StructType\TarifierungsdatenType $tarifierungsdaten = null)
    {
        $this->tarifierungsdaten = $tarifierungsdaten;
        return $this;
    }
    /**
     * Get antragsdaten value
     * @return \StructType\AntragsdatenType|null
     */
    public function getAntragsdaten()
    {
        return $this->antragsdaten;
    }
    /**
     * Set antragsdaten value
     * @param \StructType\AntragsdatenType $antragsdaten
     * @return \StructType\GeneraliprivatType
     */
    public function setAntragsdaten(\StructType\AntragsdatenType $antragsdaten = null)
    {
        $this->antragsdaten = $antragsdaten;
        return $this;
    }
    /**
     * Get rueckmeldung value
     * @return \StructType\RueckmeldungType|null
     */
    public function getRueckmeldung()
    {
        return $this->rueckmeldung;
    }
    /**
     * Set rueckmeldung value
     * @param \StructType\RueckmeldungType $rueckmeldung
     * @return \StructType\GeneraliprivatType
     */
    public function setRueckmeldung(\StructType\RueckmeldungType $rueckmeldung = null)
    {
        $this->rueckmeldung = $rueckmeldung;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeneraliprivatType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
