<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for frameAgreement StructType
 * Meta information extracted from the WSDL
 * - documentation: Hauptelement für eine Maklerrahmenvereinbarung
 * @subpackage Structs
 */
class FrameAgreement extends AbstractStructBase
{
    /**
     * The frameAgreementType
     * @var string
     */
    public $frameAgreementType;
    /**
     * The frameAgreementNr
     * @var string
     */
    public $frameAgreementNr;
    /**
     * The frameAgreementDescription
     * @var string
     */
    public $frameAgreementDescription;
    /**
     * The clause
     * @var string
     */
    public $clause;
    /**
     * The clauseShortDescription
     * @var string
     */
    public $clauseShortDescription;
    /**
     * The beginn
     * @var string
     */
    public $beginn;
    /**
     * The end
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $end;
    /**
     * The printData
     * Meta information extracted from the WSDL
     * - documentation: Der PDF-Stream des Druckdokumentes
     * @var string
     */
    public $printData;
    /**
     * Constructor method for frameAgreement
     * @uses FrameAgreement::setFrameAgreementType()
     * @uses FrameAgreement::setFrameAgreementNr()
     * @uses FrameAgreement::setFrameAgreementDescription()
     * @uses FrameAgreement::setClause()
     * @uses FrameAgreement::setClauseShortDescription()
     * @uses FrameAgreement::setBeginn()
     * @uses FrameAgreement::setEnd()
     * @uses FrameAgreement::setPrintData()
     * @param string $frameAgreementType
     * @param string $frameAgreementNr
     * @param string $frameAgreementDescription
     * @param string $clause
     * @param string $clauseShortDescription
     * @param string $beginn
     * @param string $end
     * @param string $printData
     */
    public function __construct($frameAgreementType = null, $frameAgreementNr = null, $frameAgreementDescription = null, $clause = null, $clauseShortDescription = null, $beginn = null, $end = null, $printData = null)
    {
        $this
            ->setFrameAgreementType($frameAgreementType)
            ->setFrameAgreementNr($frameAgreementNr)
            ->setFrameAgreementDescription($frameAgreementDescription)
            ->setClause($clause)
            ->setClauseShortDescription($clauseShortDescription)
            ->setBeginn($beginn)
            ->setEnd($end)
            ->setPrintData($printData);
    }
    /**
     * Get frameAgreementType value
     * @return string|null
     */
    public function getFrameAgreementType()
    {
        return $this->frameAgreementType;
    }
    /**
     * Set frameAgreementType value
     * @param string $frameAgreementType
     * @return \StructType\FrameAgreement
     */
    public function setFrameAgreementType($frameAgreementType = null)
    {
        // validation for constraint: string
        if (!is_null($frameAgreementType) && !is_string($frameAgreementType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frameAgreementType, true), gettype($frameAgreementType)), __LINE__);
        }
        $this->frameAgreementType = $frameAgreementType;
        return $this;
    }
    /**
     * Get frameAgreementNr value
     * @return string|null
     */
    public function getFrameAgreementNr()
    {
        return $this->frameAgreementNr;
    }
    /**
     * Set frameAgreementNr value
     * @param string $frameAgreementNr
     * @return \StructType\FrameAgreement
     */
    public function setFrameAgreementNr($frameAgreementNr = null)
    {
        // validation for constraint: string
        if (!is_null($frameAgreementNr) && !is_string($frameAgreementNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frameAgreementNr, true), gettype($frameAgreementNr)), __LINE__);
        }
        $this->frameAgreementNr = $frameAgreementNr;
        return $this;
    }
    /**
     * Get frameAgreementDescription value
     * @return string|null
     */
    public function getFrameAgreementDescription()
    {
        return $this->frameAgreementDescription;
    }
    /**
     * Set frameAgreementDescription value
     * @param string $frameAgreementDescription
     * @return \StructType\FrameAgreement
     */
    public function setFrameAgreementDescription($frameAgreementDescription = null)
    {
        // validation for constraint: string
        if (!is_null($frameAgreementDescription) && !is_string($frameAgreementDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frameAgreementDescription, true), gettype($frameAgreementDescription)), __LINE__);
        }
        $this->frameAgreementDescription = $frameAgreementDescription;
        return $this;
    }
    /**
     * Get clause value
     * @return string|null
     */
    public function getClause()
    {
        return $this->clause;
    }
    /**
     * Set clause value
     * @param string $clause
     * @return \StructType\FrameAgreement
     */
    public function setClause($clause = null)
    {
        // validation for constraint: string
        if (!is_null($clause) && !is_string($clause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clause, true), gettype($clause)), __LINE__);
        }
        $this->clause = $clause;
        return $this;
    }
    /**
     * Get clauseShortDescription value
     * @return string|null
     */
    public function getClauseShortDescription()
    {
        return $this->clauseShortDescription;
    }
    /**
     * Set clauseShortDescription value
     * @param string $clauseShortDescription
     * @return \StructType\FrameAgreement
     */
    public function setClauseShortDescription($clauseShortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($clauseShortDescription) && !is_string($clauseShortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clauseShortDescription, true), gettype($clauseShortDescription)), __LINE__);
        }
        $this->clauseShortDescription = $clauseShortDescription;
        return $this;
    }
    /**
     * Get beginn value
     * @return string|null
     */
    public function getBeginn()
    {
        return $this->beginn;
    }
    /**
     * Set beginn value
     * @param string $beginn
     * @return \StructType\FrameAgreement
     */
    public function setBeginn($beginn = null)
    {
        // validation for constraint: string
        if (!is_null($beginn) && !is_string($beginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginn, true), gettype($beginn)), __LINE__);
        }
        $this->beginn = $beginn;
        return $this;
    }
    /**
     * Get end value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param string $end
     * @return \StructType\FrameAgreement
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->end = $end;
        return $this;
    }
    /**
     * Get printData value
     * @return string|null
     */
    public function getPrintData()
    {
        return $this->printData;
    }
    /**
     * Set printData value
     * @param string $printData
     * @return \StructType\FrameAgreement
     */
    public function setPrintData($printData = null)
    {
        // validation for constraint: string
        if (!is_null($printData) && !is_string($printData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printData, true), gettype($printData)), __LINE__);
        }
        $this->printData = $printData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FrameAgreement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
