<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fahrzeugzustandType StructType
 * @subpackage Structs
 */
class FahrzeugzustandType extends AbstractStructBase
{
    /**
     * The zustandsberichtLiegtAlsFormularBei
     * Meta information extracted from the WSDL
     * - documentation: Zustandsbericht liegt als Formular bei bzw. Besichtigung durch externe Stelle veranlasst - muss dann als Attachment mitgeschickt werden.
     * - minOccurs: 0
     * @var string
     */
    public $zustandsberichtLiegtAlsFormularBei;
    /**
     * The zustandsbeschreibung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zustandsbeschreibung;
    /**
     * The schaedenAnScheibenKleinglas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $schaedenAnScheibenKleinglas;
    /**
     * The schaedenAmFahrzeug
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $schaedenAmFahrzeug;
    /**
     * The kilometerLtBesichtigung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $kilometerLtBesichtigung;
    /**
     * The vorschaeden
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 500
     * - minOccurs: 0
     * @var string
     */
    public $vorschaeden;
    /**
     * The besichtigungsort
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $besichtigungsort;
    /**
     * The besichtigungsdatum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $besichtigungsdatum;
    /**
     * The grundFuerNachbesichtigung
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 500
     * - minOccurs: 0
     * @var string
     */
    public $grundFuerNachbesichtigung;
    /**
     * Constructor method for fahrzeugzustandType
     * @uses FahrzeugzustandType::setZustandsberichtLiegtAlsFormularBei()
     * @uses FahrzeugzustandType::setZustandsbeschreibung()
     * @uses FahrzeugzustandType::setSchaedenAnScheibenKleinglas()
     * @uses FahrzeugzustandType::setSchaedenAmFahrzeug()
     * @uses FahrzeugzustandType::setKilometerLtBesichtigung()
     * @uses FahrzeugzustandType::setVorschaeden()
     * @uses FahrzeugzustandType::setBesichtigungsort()
     * @uses FahrzeugzustandType::setBesichtigungsdatum()
     * @uses FahrzeugzustandType::setGrundFuerNachbesichtigung()
     * @param string $zustandsberichtLiegtAlsFormularBei
     * @param string $zustandsbeschreibung
     * @param string $schaedenAnScheibenKleinglas
     * @param string $schaedenAmFahrzeug
     * @param int $kilometerLtBesichtigung
     * @param string $vorschaeden
     * @param string $besichtigungsort
     * @param string $besichtigungsdatum
     * @param string $grundFuerNachbesichtigung
     */
    public function __construct($zustandsberichtLiegtAlsFormularBei = null, $zustandsbeschreibung = null, $schaedenAnScheibenKleinglas = null, $schaedenAmFahrzeug = null, $kilometerLtBesichtigung = null, $vorschaeden = null, $besichtigungsort = null, $besichtigungsdatum = null, $grundFuerNachbesichtigung = null)
    {
        $this
            ->setZustandsberichtLiegtAlsFormularBei($zustandsberichtLiegtAlsFormularBei)
            ->setZustandsbeschreibung($zustandsbeschreibung)
            ->setSchaedenAnScheibenKleinglas($schaedenAnScheibenKleinglas)
            ->setSchaedenAmFahrzeug($schaedenAmFahrzeug)
            ->setKilometerLtBesichtigung($kilometerLtBesichtigung)
            ->setVorschaeden($vorschaeden)
            ->setBesichtigungsort($besichtigungsort)
            ->setBesichtigungsdatum($besichtigungsdatum)
            ->setGrundFuerNachbesichtigung($grundFuerNachbesichtigung);
    }
    /**
     * Get zustandsberichtLiegtAlsFormularBei value
     * @return string|null
     */
    public function getZustandsberichtLiegtAlsFormularBei()
    {
        return $this->zustandsberichtLiegtAlsFormularBei;
    }
    /**
     * Set zustandsberichtLiegtAlsFormularBei value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zustandsberichtLiegtAlsFormularBei
     * @return \StructType\FahrzeugzustandType
     */
    public function setZustandsberichtLiegtAlsFormularBei($zustandsberichtLiegtAlsFormularBei = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($zustandsberichtLiegtAlsFormularBei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($zustandsberichtLiegtAlsFormularBei) ? implode(', ', $zustandsberichtLiegtAlsFormularBei) : var_export($zustandsberichtLiegtAlsFormularBei, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->zustandsberichtLiegtAlsFormularBei = $zustandsberichtLiegtAlsFormularBei;
        return $this;
    }
    /**
     * Get zustandsbeschreibung value
     * @return string|null
     */
    public function getZustandsbeschreibung()
    {
        return $this->zustandsbeschreibung;
    }
    /**
     * Set zustandsbeschreibung value
     * @uses \EnumType\ZustandsbeschreibungType::valueIsValid()
     * @uses \EnumType\ZustandsbeschreibungType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zustandsbeschreibung
     * @return \StructType\FahrzeugzustandType
     */
    public function setZustandsbeschreibung($zustandsbeschreibung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ZustandsbeschreibungType::valueIsValid($zustandsbeschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ZustandsbeschreibungType', is_array($zustandsbeschreibung) ? implode(', ', $zustandsbeschreibung) : var_export($zustandsbeschreibung, true), implode(', ', \EnumType\ZustandsbeschreibungType::getValidValues())), __LINE__);
        }
        $this->zustandsbeschreibung = $zustandsbeschreibung;
        return $this;
    }
    /**
     * Get schaedenAnScheibenKleinglas value
     * @return string|null
     */
    public function getSchaedenAnScheibenKleinglas()
    {
        return $this->schaedenAnScheibenKleinglas;
    }
    /**
     * Set schaedenAnScheibenKleinglas value
     * @uses \EnumType\SchaedenAnScheibenKleinglasType::valueIsValid()
     * @uses \EnumType\SchaedenAnScheibenKleinglasType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schaedenAnScheibenKleinglas
     * @return \StructType\FahrzeugzustandType
     */
    public function setSchaedenAnScheibenKleinglas($schaedenAnScheibenKleinglas = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SchaedenAnScheibenKleinglasType::valueIsValid($schaedenAnScheibenKleinglas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SchaedenAnScheibenKleinglasType', is_array($schaedenAnScheibenKleinglas) ? implode(', ', $schaedenAnScheibenKleinglas) : var_export($schaedenAnScheibenKleinglas, true), implode(', ', \EnumType\SchaedenAnScheibenKleinglasType::getValidValues())), __LINE__);
        }
        $this->schaedenAnScheibenKleinglas = $schaedenAnScheibenKleinglas;
        return $this;
    }
    /**
     * Get schaedenAmFahrzeug value
     * @return string|null
     */
    public function getSchaedenAmFahrzeug()
    {
        return $this->schaedenAmFahrzeug;
    }
    /**
     * Set schaedenAmFahrzeug value
     * @uses \EnumType\SchaedenAmFahrzeugType::valueIsValid()
     * @uses \EnumType\SchaedenAmFahrzeugType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schaedenAmFahrzeug
     * @return \StructType\FahrzeugzustandType
     */
    public function setSchaedenAmFahrzeug($schaedenAmFahrzeug = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SchaedenAmFahrzeugType::valueIsValid($schaedenAmFahrzeug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SchaedenAmFahrzeugType', is_array($schaedenAmFahrzeug) ? implode(', ', $schaedenAmFahrzeug) : var_export($schaedenAmFahrzeug, true), implode(', ', \EnumType\SchaedenAmFahrzeugType::getValidValues())), __LINE__);
        }
        $this->schaedenAmFahrzeug = $schaedenAmFahrzeug;
        return $this;
    }
    /**
     * Get kilometerLtBesichtigung value
     * @return int|null
     */
    public function getKilometerLtBesichtigung()
    {
        return $this->kilometerLtBesichtigung;
    }
    /**
     * Set kilometerLtBesichtigung value
     * @param int $kilometerLtBesichtigung
     * @return \StructType\FahrzeugzustandType
     */
    public function setKilometerLtBesichtigung($kilometerLtBesichtigung = null)
    {
        // validation for constraint: int
        if (!is_null($kilometerLtBesichtigung) && !(is_int($kilometerLtBesichtigung) || ctype_digit($kilometerLtBesichtigung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kilometerLtBesichtigung, true), gettype($kilometerLtBesichtigung)), __LINE__);
        }
        $this->kilometerLtBesichtigung = $kilometerLtBesichtigung;
        return $this;
    }
    /**
     * Get vorschaeden value
     * @return string|null
     */
    public function getVorschaeden()
    {
        return $this->vorschaeden;
    }
    /**
     * Set vorschaeden value
     * @param string $vorschaeden
     * @return \StructType\FahrzeugzustandType
     */
    public function setVorschaeden($vorschaeden = null)
    {
        // validation for constraint: string
        if (!is_null($vorschaeden) && !is_string($vorschaeden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorschaeden, true), gettype($vorschaeden)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($vorschaeden) && mb_strlen($vorschaeden) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($vorschaeden)), __LINE__);
        }
        $this->vorschaeden = $vorschaeden;
        return $this;
    }
    /**
     * Get besichtigungsort value
     * @return string|null
     */
    public function getBesichtigungsort()
    {
        return $this->besichtigungsort;
    }
    /**
     * Set besichtigungsort value
     * @param string $besichtigungsort
     * @return \StructType\FahrzeugzustandType
     */
    public function setBesichtigungsort($besichtigungsort = null)
    {
        // validation for constraint: string
        if (!is_null($besichtigungsort) && !is_string($besichtigungsort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($besichtigungsort, true), gettype($besichtigungsort)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($besichtigungsort) && mb_strlen($besichtigungsort) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($besichtigungsort)), __LINE__);
        }
        $this->besichtigungsort = $besichtigungsort;
        return $this;
    }
    /**
     * Get besichtigungsdatum value
     * @return string|null
     */
    public function getBesichtigungsdatum()
    {
        return $this->besichtigungsdatum;
    }
    /**
     * Set besichtigungsdatum value
     * @param string $besichtigungsdatum
     * @return \StructType\FahrzeugzustandType
     */
    public function setBesichtigungsdatum($besichtigungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($besichtigungsdatum) && !is_string($besichtigungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($besichtigungsdatum, true), gettype($besichtigungsdatum)), __LINE__);
        }
        $this->besichtigungsdatum = $besichtigungsdatum;
        return $this;
    }
    /**
     * Get grundFuerNachbesichtigung value
     * @return string|null
     */
    public function getGrundFuerNachbesichtigung()
    {
        return $this->grundFuerNachbesichtigung;
    }
    /**
     * Set grundFuerNachbesichtigung value
     * @param string $grundFuerNachbesichtigung
     * @return \StructType\FahrzeugzustandType
     */
    public function setGrundFuerNachbesichtigung($grundFuerNachbesichtigung = null)
    {
        // validation for constraint: string
        if (!is_null($grundFuerNachbesichtigung) && !is_string($grundFuerNachbesichtigung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grundFuerNachbesichtigung, true), gettype($grundFuerNachbesichtigung)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($grundFuerNachbesichtigung) && mb_strlen($grundFuerNachbesichtigung) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($grundFuerNachbesichtigung)), __LINE__);
        }
        $this->grundFuerNachbesichtigung = $grundFuerNachbesichtigung;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FahrzeugzustandType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
