<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for datenverwendungType StructType
 * @subpackage Structs
 */
class DatenverwendungType extends AbstractStructBase
{
    /**
     * The zustimmungZurDatenverwendungUndVerarbeitung
     * Meta information extracted from the WSDL
     * - documentation: -- nicht mehr benötigt --
     * - minOccurs: 0
     * @var string
     */
    public $zustimmungZurDatenverwendungUndVerarbeitung;
    /**
     * The zustimmungZurElektrUebermittlungVorvertraglDokumente
     * Meta information extracted from the WSDL
     * - documentation: Zustimmung zur elektronischen Übermittlung vorvertraglicher Dokumente
     * - minOccurs: 0
     * @var string
     */
    public $zustimmungZurElektrUebermittlungVorvertraglDokumente;
    /**
     * The elektrUebermittlungVorvertraglDokumenteEmail
     * Meta information extracted from the WSDL
     * - documentation: E-Mail Adresse zur Zusendung von vorvertraglichen Dokumenten
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $elektrUebermittlungVorvertraglDokumenteEmail;
    /**
     * The zustimmungZurVerwendungDerDatenZuWerbezwecken
     * Meta information extracted from the WSDL
     * - documentation: Zustimmung zur Verwendung personenbezogener Daten (Der Antragsteller stimmt im Sinne des Datenschutzgesetzes und des Telekommunikationsgesetzes zu, dass die Generali Versicherung AG, die Gesellschaften der Generali Gruppe sowie deren
     * Kooperationspartner (siehe dazu "Information zur Datenanwendung gem. §24 DSG") seine personenbezogenen Daten und seine Vertragsdaten (Name, Anschrift, E-Mailadresse, Telefonnummer, Produkt, Leistungsumfang, Vertragslaufzeit, nicht jedoch
     * Gesundheitsdaten) für Zwecke der Zusendung von Informationen über bestehende und neue Produkte der Generali-Gruppe und ihrer Kooperationspartner, für Qualitäts- und Zufriedenheitsumfragen sowie Marketingaktionen verwenden und ihn zu diesem Zwecke
     * per Telefon und E-Mail kontaktieren dürfen. Diese Zustimmung kann jederzeit widerrufen werden.)
     * @var string
     */
    public $zustimmungZurVerwendungDerDatenZuWerbezwecken;
    /**
     * Constructor method for datenverwendungType
     * @uses DatenverwendungType::setZustimmungZurDatenverwendungUndVerarbeitung()
     * @uses DatenverwendungType::setZustimmungZurElektrUebermittlungVorvertraglDokumente()
     * @uses DatenverwendungType::setElektrUebermittlungVorvertraglDokumenteEmail()
     * @uses DatenverwendungType::setZustimmungZurVerwendungDerDatenZuWerbezwecken()
     * @param string $zustimmungZurDatenverwendungUndVerarbeitung
     * @param string $zustimmungZurElektrUebermittlungVorvertraglDokumente
     * @param string $elektrUebermittlungVorvertraglDokumenteEmail
     * @param string $zustimmungZurVerwendungDerDatenZuWerbezwecken
     */
    public function __construct($zustimmungZurDatenverwendungUndVerarbeitung = null, $zustimmungZurElektrUebermittlungVorvertraglDokumente = null, $elektrUebermittlungVorvertraglDokumenteEmail = null, $zustimmungZurVerwendungDerDatenZuWerbezwecken = null)
    {
        $this
            ->setZustimmungZurDatenverwendungUndVerarbeitung($zustimmungZurDatenverwendungUndVerarbeitung)
            ->setZustimmungZurElektrUebermittlungVorvertraglDokumente($zustimmungZurElektrUebermittlungVorvertraglDokumente)
            ->setElektrUebermittlungVorvertraglDokumenteEmail($elektrUebermittlungVorvertraglDokumenteEmail)
            ->setZustimmungZurVerwendungDerDatenZuWerbezwecken($zustimmungZurVerwendungDerDatenZuWerbezwecken);
    }
    /**
     * Get zustimmungZurDatenverwendungUndVerarbeitung value
     * @return string|null
     */
    public function getZustimmungZurDatenverwendungUndVerarbeitung()
    {
        return $this->zustimmungZurDatenverwendungUndVerarbeitung;
    }
    /**
     * Set zustimmungZurDatenverwendungUndVerarbeitung value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zustimmungZurDatenverwendungUndVerarbeitung
     * @return \StructType\DatenverwendungType
     */
    public function setZustimmungZurDatenverwendungUndVerarbeitung($zustimmungZurDatenverwendungUndVerarbeitung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($zustimmungZurDatenverwendungUndVerarbeitung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($zustimmungZurDatenverwendungUndVerarbeitung) ? implode(', ', $zustimmungZurDatenverwendungUndVerarbeitung) : var_export($zustimmungZurDatenverwendungUndVerarbeitung, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->zustimmungZurDatenverwendungUndVerarbeitung = $zustimmungZurDatenverwendungUndVerarbeitung;
        return $this;
    }
    /**
     * Get zustimmungZurElektrUebermittlungVorvertraglDokumente value
     * @return string|null
     */
    public function getZustimmungZurElektrUebermittlungVorvertraglDokumente()
    {
        return $this->zustimmungZurElektrUebermittlungVorvertraglDokumente;
    }
    /**
     * Set zustimmungZurElektrUebermittlungVorvertraglDokumente value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zustimmungZurElektrUebermittlungVorvertraglDokumente
     * @return \StructType\DatenverwendungType
     */
    public function setZustimmungZurElektrUebermittlungVorvertraglDokumente($zustimmungZurElektrUebermittlungVorvertraglDokumente = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($zustimmungZurElektrUebermittlungVorvertraglDokumente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($zustimmungZurElektrUebermittlungVorvertraglDokumente) ? implode(', ', $zustimmungZurElektrUebermittlungVorvertraglDokumente) : var_export($zustimmungZurElektrUebermittlungVorvertraglDokumente, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->zustimmungZurElektrUebermittlungVorvertraglDokumente = $zustimmungZurElektrUebermittlungVorvertraglDokumente;
        return $this;
    }
    /**
     * Get elektrUebermittlungVorvertraglDokumenteEmail value
     * @return string|null
     */
    public function getElektrUebermittlungVorvertraglDokumenteEmail()
    {
        return $this->elektrUebermittlungVorvertraglDokumenteEmail;
    }
    /**
     * Set elektrUebermittlungVorvertraglDokumenteEmail value
     * @param string $elektrUebermittlungVorvertraglDokumenteEmail
     * @return \StructType\DatenverwendungType
     */
    public function setElektrUebermittlungVorvertraglDokumenteEmail($elektrUebermittlungVorvertraglDokumenteEmail = null)
    {
        // validation for constraint: string
        if (!is_null($elektrUebermittlungVorvertraglDokumenteEmail) && !is_string($elektrUebermittlungVorvertraglDokumenteEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($elektrUebermittlungVorvertraglDokumenteEmail, true), gettype($elektrUebermittlungVorvertraglDokumenteEmail)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($elektrUebermittlungVorvertraglDokumenteEmail) && mb_strlen($elektrUebermittlungVorvertraglDokumenteEmail) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($elektrUebermittlungVorvertraglDokumenteEmail)), __LINE__);
        }
        $this->elektrUebermittlungVorvertraglDokumenteEmail = $elektrUebermittlungVorvertraglDokumenteEmail;
        return $this;
    }
    /**
     * Get zustimmungZurVerwendungDerDatenZuWerbezwecken value
     * @return string|null
     */
    public function getZustimmungZurVerwendungDerDatenZuWerbezwecken()
    {
        return $this->zustimmungZurVerwendungDerDatenZuWerbezwecken;
    }
    /**
     * Set zustimmungZurVerwendungDerDatenZuWerbezwecken value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zustimmungZurVerwendungDerDatenZuWerbezwecken
     * @return \StructType\DatenverwendungType
     */
    public function setZustimmungZurVerwendungDerDatenZuWerbezwecken($zustimmungZurVerwendungDerDatenZuWerbezwecken = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($zustimmungZurVerwendungDerDatenZuWerbezwecken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($zustimmungZurVerwendungDerDatenZuWerbezwecken) ? implode(', ', $zustimmungZurVerwendungDerDatenZuWerbezwecken) : var_export($zustimmungZurVerwendungDerDatenZuWerbezwecken, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->zustimmungZurVerwendungDerDatenZuWerbezwecken = $zustimmungZurVerwendungDerDatenZuWerbezwecken;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatenverwendungType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
