<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for antragsdatenType StructType
 * @subpackage Structs
 */
class AntragsdatenType extends AbstractStructBase
{
    /**
     * The weitererVersicherungsnehmer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PartnerType
     */
    public $weitererVersicherungsnehmer;
    /**
     * The abweichenderPraemienzahler
     * Meta information extracted from the WSDL
     * - documentation: Ein abweichender Prämienzahler muss nur angegeben werden, wenn nicht der Versicherungsnehmer die Prämie zahlt
     * - minOccurs: 0
     * @var \StructType\PartnerType
     */
    public $abweichenderPraemienzahler;
    /**
     * The zahlungsdaten
     * @var \StructType\ZahlungsdatenType
     */
    public $zahlungsdaten;
    /**
     * The ersatzpolizzennummern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErsatzpolizzenType
     */
    public $ersatzpolizzennummern;
    /**
     * The vinkulierungKasko
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VinkularglaeubigerType
     */
    public $vinkulierungKasko;
    /**
     * The kfzdaten
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ZusaetzlicheKfzdatenType
     */
    public $kfzdaten;
    /**
     * The rechtsschutzdaten
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AntragrechtsschutzdatenType
     */
    public $rechtsschutzdaten;
    /**
     * The bonusMalusSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BonusMalusSystemType
     */
    public $bonusMalusSystem;
    /**
     * The fahrzeugnutzung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FahrzeugnutzungType
     */
    public $fahrzeugnutzung;
    /**
     * The vorversicherungen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VorversicherungenType
     */
    public $vorversicherungen;
    /**
     * The zusendungVertragsgrundlagenGewuenscht
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zusendungVertragsgrundlagenGewuenscht;
    /**
     * The zusendungGrueneKarteAbbestellen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zusendungGrueneKarteAbbestellen;
    /**
     * The besondereVereinbarungen
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1000
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $besondereVereinbarungen;
    /**
     * The polizzenversand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $polizzenversand;
    /**
     * The identifikationZuordnung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IdentifikationZuordnungType
     */
    public $identifikationZuordnung;
    /**
     * The kontierungsdaten
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\KontierungsdatenType
     */
    public $kontierungsdaten;
    /**
     * The datenverwendung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DatenverwendungType
     */
    public $datenverwendung;
    /**
     * The anmeldungKundenportal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AnmeldungKundenportalType
     */
    public $anmeldungKundenportal;
    /**
     * The maklervollmacht
     * Meta information extracted from the WSDL
     * - documentation: Sofern der Vermittler die Vermittlervollmacht und ein erteiltes SEPA-Lastschriftmandat dem Antrag nicht beilegt bzw. elektronisch anhängt, verpflichtet er sich diese Dokumente ensprechend den gesetzlichen Bestimmungen zur
     * Aufbewahrung von Geschäftsbüchern und Korrespondenzen bis zu deren Übermittlung an den Versicherer aufzubewahren.
     * - minOccurs: 0
     * @var string
     */
    public $maklervollmacht;
    /**
     * The beratungsdokumentation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BeratungsdokumentationType
     */
    public $beratungsdokumentation;
    /**
     * The versicherungsnehmer
     * Meta information extracted from the WSDL
     * - documentation: Versicherungsnehmer, wenn die Schnittstelle nicht zu einem bestimmten Partner aufgerufen wird
     * - minOccurs: 0
     * @var \StructType\PartnerType
     */
    public $versicherungsnehmer;
    /**
     * The vorsteuerAbzugsberechtigt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vorsteuerAbzugsberechtigt;
    /**
     * Constructor method for antragsdatenType
     * @uses AntragsdatenType::setWeitererVersicherungsnehmer()
     * @uses AntragsdatenType::setAbweichenderPraemienzahler()
     * @uses AntragsdatenType::setZahlungsdaten()
     * @uses AntragsdatenType::setErsatzpolizzennummern()
     * @uses AntragsdatenType::setVinkulierungKasko()
     * @uses AntragsdatenType::setKfzdaten()
     * @uses AntragsdatenType::setRechtsschutzdaten()
     * @uses AntragsdatenType::setBonusMalusSystem()
     * @uses AntragsdatenType::setFahrzeugnutzung()
     * @uses AntragsdatenType::setVorversicherungen()
     * @uses AntragsdatenType::setZusendungVertragsgrundlagenGewuenscht()
     * @uses AntragsdatenType::setZusendungGrueneKarteAbbestellen()
     * @uses AntragsdatenType::setBesondereVereinbarungen()
     * @uses AntragsdatenType::setPolizzenversand()
     * @uses AntragsdatenType::setIdentifikationZuordnung()
     * @uses AntragsdatenType::setKontierungsdaten()
     * @uses AntragsdatenType::setDatenverwendung()
     * @uses AntragsdatenType::setAnmeldungKundenportal()
     * @uses AntragsdatenType::setMaklervollmacht()
     * @uses AntragsdatenType::setBeratungsdokumentation()
     * @uses AntragsdatenType::setVersicherungsnehmer()
     * @uses AntragsdatenType::setVorsteuerAbzugsberechtigt()
     * @param \StructType\PartnerType $weitererVersicherungsnehmer
     * @param \StructType\PartnerType $abweichenderPraemienzahler
     * @param \StructType\ZahlungsdatenType $zahlungsdaten
     * @param \StructType\ErsatzpolizzenType $ersatzpolizzennummern
     * @param \StructType\VinkularglaeubigerType $vinkulierungKasko
     * @param \StructType\ZusaetzlicheKfzdatenType $kfzdaten
     * @param \StructType\AntragrechtsschutzdatenType $rechtsschutzdaten
     * @param \StructType\BonusMalusSystemType $bonusMalusSystem
     * @param \StructType\FahrzeugnutzungType $fahrzeugnutzung
     * @param \StructType\VorversicherungenType $vorversicherungen
     * @param string $zusendungVertragsgrundlagenGewuenscht
     * @param string $zusendungGrueneKarteAbbestellen
     * @param string $besondereVereinbarungen
     * @param string $polizzenversand
     * @param \StructType\IdentifikationZuordnungType $identifikationZuordnung
     * @param \StructType\KontierungsdatenType $kontierungsdaten
     * @param \StructType\DatenverwendungType $datenverwendung
     * @param \StructType\AnmeldungKundenportalType $anmeldungKundenportal
     * @param string $maklervollmacht
     * @param \StructType\BeratungsdokumentationType $beratungsdokumentation
     * @param \StructType\PartnerType $versicherungsnehmer
     * @param bool $vorsteuerAbzugsberechtigt
     */
    public function __construct(\StructType\PartnerType $weitererVersicherungsnehmer = null, \StructType\PartnerType $abweichenderPraemienzahler = null, \StructType\ZahlungsdatenType $zahlungsdaten = null, \StructType\ErsatzpolizzenType $ersatzpolizzennummern = null, \StructType\VinkularglaeubigerType $vinkulierungKasko = null, \StructType\ZusaetzlicheKfzdatenType $kfzdaten = null, \StructType\AntragrechtsschutzdatenType $rechtsschutzdaten = null, \StructType\BonusMalusSystemType $bonusMalusSystem = null, \StructType\FahrzeugnutzungType $fahrzeugnutzung = null, \StructType\VorversicherungenType $vorversicherungen = null, $zusendungVertragsgrundlagenGewuenscht = null, $zusendungGrueneKarteAbbestellen = null, $besondereVereinbarungen = null, $polizzenversand = null, \StructType\IdentifikationZuordnungType $identifikationZuordnung = null, \StructType\KontierungsdatenType $kontierungsdaten = null, \StructType\DatenverwendungType $datenverwendung = null, \StructType\AnmeldungKundenportalType $anmeldungKundenportal = null, $maklervollmacht = null, \StructType\BeratungsdokumentationType $beratungsdokumentation = null, \StructType\PartnerType $versicherungsnehmer = null, $vorsteuerAbzugsberechtigt = null)
    {
        $this
            ->setWeitererVersicherungsnehmer($weitererVersicherungsnehmer)
            ->setAbweichenderPraemienzahler($abweichenderPraemienzahler)
            ->setZahlungsdaten($zahlungsdaten)
            ->setErsatzpolizzennummern($ersatzpolizzennummern)
            ->setVinkulierungKasko($vinkulierungKasko)
            ->setKfzdaten($kfzdaten)
            ->setRechtsschutzdaten($rechtsschutzdaten)
            ->setBonusMalusSystem($bonusMalusSystem)
            ->setFahrzeugnutzung($fahrzeugnutzung)
            ->setVorversicherungen($vorversicherungen)
            ->setZusendungVertragsgrundlagenGewuenscht($zusendungVertragsgrundlagenGewuenscht)
            ->setZusendungGrueneKarteAbbestellen($zusendungGrueneKarteAbbestellen)
            ->setBesondereVereinbarungen($besondereVereinbarungen)
            ->setPolizzenversand($polizzenversand)
            ->setIdentifikationZuordnung($identifikationZuordnung)
            ->setKontierungsdaten($kontierungsdaten)
            ->setDatenverwendung($datenverwendung)
            ->setAnmeldungKundenportal($anmeldungKundenportal)
            ->setMaklervollmacht($maklervollmacht)
            ->setBeratungsdokumentation($beratungsdokumentation)
            ->setVersicherungsnehmer($versicherungsnehmer)
            ->setVorsteuerAbzugsberechtigt($vorsteuerAbzugsberechtigt);
    }
    /**
     * Get weitererVersicherungsnehmer value
     * @return \StructType\PartnerType|null
     */
    public function getWeitererVersicherungsnehmer()
    {
        return $this->weitererVersicherungsnehmer;
    }
    /**
     * Set weitererVersicherungsnehmer value
     * @param \StructType\PartnerType $weitererVersicherungsnehmer
     * @return \StructType\AntragsdatenType
     */
    public function setWeitererVersicherungsnehmer(\StructType\PartnerType $weitererVersicherungsnehmer = null)
    {
        $this->weitererVersicherungsnehmer = $weitererVersicherungsnehmer;
        return $this;
    }
    /**
     * Get abweichenderPraemienzahler value
     * @return \StructType\PartnerType|null
     */
    public function getAbweichenderPraemienzahler()
    {
        return $this->abweichenderPraemienzahler;
    }
    /**
     * Set abweichenderPraemienzahler value
     * @param \StructType\PartnerType $abweichenderPraemienzahler
     * @return \StructType\AntragsdatenType
     */
    public function setAbweichenderPraemienzahler(\StructType\PartnerType $abweichenderPraemienzahler = null)
    {
        $this->abweichenderPraemienzahler = $abweichenderPraemienzahler;
        return $this;
    }
    /**
     * Get zahlungsdaten value
     * @return \StructType\ZahlungsdatenType|null
     */
    public function getZahlungsdaten()
    {
        return $this->zahlungsdaten;
    }
    /**
     * Set zahlungsdaten value
     * @param \StructType\ZahlungsdatenType $zahlungsdaten
     * @return \StructType\AntragsdatenType
     */
    public function setZahlungsdaten(\StructType\ZahlungsdatenType $zahlungsdaten = null)
    {
        $this->zahlungsdaten = $zahlungsdaten;
        return $this;
    }
    /**
     * Get ersatzpolizzennummern value
     * @return \StructType\ErsatzpolizzenType|null
     */
    public function getErsatzpolizzennummern()
    {
        return $this->ersatzpolizzennummern;
    }
    /**
     * Set ersatzpolizzennummern value
     * @param \StructType\ErsatzpolizzenType $ersatzpolizzennummern
     * @return \StructType\AntragsdatenType
     */
    public function setErsatzpolizzennummern(\StructType\ErsatzpolizzenType $ersatzpolizzennummern = null)
    {
        $this->ersatzpolizzennummern = $ersatzpolizzennummern;
        return $this;
    }
    /**
     * Get vinkulierungKasko value
     * @return \StructType\VinkularglaeubigerType|null
     */
    public function getVinkulierungKasko()
    {
        return $this->vinkulierungKasko;
    }
    /**
     * Set vinkulierungKasko value
     * @param \StructType\VinkularglaeubigerType $vinkulierungKasko
     * @return \StructType\AntragsdatenType
     */
    public function setVinkulierungKasko(\StructType\VinkularglaeubigerType $vinkulierungKasko = null)
    {
        $this->vinkulierungKasko = $vinkulierungKasko;
        return $this;
    }
    /**
     * Get kfzdaten value
     * @return \StructType\ZusaetzlicheKfzdatenType|null
     */
    public function getKfzdaten()
    {
        return $this->kfzdaten;
    }
    /**
     * Set kfzdaten value
     * @param \StructType\ZusaetzlicheKfzdatenType $kfzdaten
     * @return \StructType\AntragsdatenType
     */
    public function setKfzdaten(\StructType\ZusaetzlicheKfzdatenType $kfzdaten = null)
    {
        $this->kfzdaten = $kfzdaten;
        return $this;
    }
    /**
     * Get rechtsschutzdaten value
     * @return \StructType\AntragrechtsschutzdatenType|null
     */
    public function getRechtsschutzdaten()
    {
        return $this->rechtsschutzdaten;
    }
    /**
     * Set rechtsschutzdaten value
     * @param \StructType\AntragrechtsschutzdatenType $rechtsschutzdaten
     * @return \StructType\AntragsdatenType
     */
    public function setRechtsschutzdaten(\StructType\AntragrechtsschutzdatenType $rechtsschutzdaten = null)
    {
        $this->rechtsschutzdaten = $rechtsschutzdaten;
        return $this;
    }
    /**
     * Get bonusMalusSystem value
     * @return \StructType\BonusMalusSystemType|null
     */
    public function getBonusMalusSystem()
    {
        return $this->bonusMalusSystem;
    }
    /**
     * Set bonusMalusSystem value
     * @param \StructType\BonusMalusSystemType $bonusMalusSystem
     * @return \StructType\AntragsdatenType
     */
    public function setBonusMalusSystem(\StructType\BonusMalusSystemType $bonusMalusSystem = null)
    {
        $this->bonusMalusSystem = $bonusMalusSystem;
        return $this;
    }
    /**
     * Get fahrzeugnutzung value
     * @return \StructType\FahrzeugnutzungType|null
     */
    public function getFahrzeugnutzung()
    {
        return $this->fahrzeugnutzung;
    }
    /**
     * Set fahrzeugnutzung value
     * @param \StructType\FahrzeugnutzungType $fahrzeugnutzung
     * @return \StructType\AntragsdatenType
     */
    public function setFahrzeugnutzung(\StructType\FahrzeugnutzungType $fahrzeugnutzung = null)
    {
        $this->fahrzeugnutzung = $fahrzeugnutzung;
        return $this;
    }
    /**
     * Get vorversicherungen value
     * @return \StructType\VorversicherungenType|null
     */
    public function getVorversicherungen()
    {
        return $this->vorversicherungen;
    }
    /**
     * Set vorversicherungen value
     * @param \StructType\VorversicherungenType $vorversicherungen
     * @return \StructType\AntragsdatenType
     */
    public function setVorversicherungen(\StructType\VorversicherungenType $vorversicherungen = null)
    {
        $this->vorversicherungen = $vorversicherungen;
        return $this;
    }
    /**
     * Get zusendungVertragsgrundlagenGewuenscht value
     * @return string|null
     */
    public function getZusendungVertragsgrundlagenGewuenscht()
    {
        return $this->zusendungVertragsgrundlagenGewuenscht;
    }
    /**
     * Set zusendungVertragsgrundlagenGewuenscht value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zusendungVertragsgrundlagenGewuenscht
     * @return \StructType\AntragsdatenType
     */
    public function setZusendungVertragsgrundlagenGewuenscht($zusendungVertragsgrundlagenGewuenscht = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($zusendungVertragsgrundlagenGewuenscht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($zusendungVertragsgrundlagenGewuenscht) ? implode(', ', $zusendungVertragsgrundlagenGewuenscht) : var_export($zusendungVertragsgrundlagenGewuenscht, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->zusendungVertragsgrundlagenGewuenscht = $zusendungVertragsgrundlagenGewuenscht;
        return $this;
    }
    /**
     * Get zusendungGrueneKarteAbbestellen value
     * @return string|null
     */
    public function getZusendungGrueneKarteAbbestellen()
    {
        return $this->zusendungGrueneKarteAbbestellen;
    }
    /**
     * Set zusendungGrueneKarteAbbestellen value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zusendungGrueneKarteAbbestellen
     * @return \StructType\AntragsdatenType
     */
    public function setZusendungGrueneKarteAbbestellen($zusendungGrueneKarteAbbestellen = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($zusendungGrueneKarteAbbestellen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($zusendungGrueneKarteAbbestellen) ? implode(', ', $zusendungGrueneKarteAbbestellen) : var_export($zusendungGrueneKarteAbbestellen, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->zusendungGrueneKarteAbbestellen = $zusendungGrueneKarteAbbestellen;
        return $this;
    }
    /**
     * Get besondereVereinbarungen value
     * @return string|null
     */
    public function getBesondereVereinbarungen()
    {
        return $this->besondereVereinbarungen;
    }
    /**
     * Set besondereVereinbarungen value
     * @param string $besondereVereinbarungen
     * @return \StructType\AntragsdatenType
     */
    public function setBesondereVereinbarungen($besondereVereinbarungen = null)
    {
        // validation for constraint: string
        if (!is_null($besondereVereinbarungen) && !is_string($besondereVereinbarungen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($besondereVereinbarungen, true), gettype($besondereVereinbarungen)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($besondereVereinbarungen) && mb_strlen($besondereVereinbarungen) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($besondereVereinbarungen)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($besondereVereinbarungen) && mb_strlen($besondereVereinbarungen) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($besondereVereinbarungen)), __LINE__);
        }
        $this->besondereVereinbarungen = $besondereVereinbarungen;
        return $this;
    }
    /**
     * Get polizzenversand value
     * @return string|null
     */
    public function getPolizzenversand()
    {
        return $this->polizzenversand;
    }
    /**
     * Set polizzenversand value
     * @uses \EnumType\PolizzenversandType::valueIsValid()
     * @uses \EnumType\PolizzenversandType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $polizzenversand
     * @return \StructType\AntragsdatenType
     */
    public function setPolizzenversand($polizzenversand = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PolizzenversandType::valueIsValid($polizzenversand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PolizzenversandType', is_array($polizzenversand) ? implode(', ', $polizzenversand) : var_export($polizzenversand, true), implode(', ', \EnumType\PolizzenversandType::getValidValues())), __LINE__);
        }
        $this->polizzenversand = $polizzenversand;
        return $this;
    }
    /**
     * Get identifikationZuordnung value
     * @return \StructType\IdentifikationZuordnungType|null
     */
    public function getIdentifikationZuordnung()
    {
        return $this->identifikationZuordnung;
    }
    /**
     * Set identifikationZuordnung value
     * @param \StructType\IdentifikationZuordnungType $identifikationZuordnung
     * @return \StructType\AntragsdatenType
     */
    public function setIdentifikationZuordnung(\StructType\IdentifikationZuordnungType $identifikationZuordnung = null)
    {
        $this->identifikationZuordnung = $identifikationZuordnung;
        return $this;
    }
    /**
     * Get kontierungsdaten value
     * @return \StructType\KontierungsdatenType|null
     */
    public function getKontierungsdaten()
    {
        return $this->kontierungsdaten;
    }
    /**
     * Set kontierungsdaten value
     * @param \StructType\KontierungsdatenType $kontierungsdaten
     * @return \StructType\AntragsdatenType
     */
    public function setKontierungsdaten(\StructType\KontierungsdatenType $kontierungsdaten = null)
    {
        $this->kontierungsdaten = $kontierungsdaten;
        return $this;
    }
    /**
     * Get datenverwendung value
     * @return \StructType\DatenverwendungType|null
     */
    public function getDatenverwendung()
    {
        return $this->datenverwendung;
    }
    /**
     * Set datenverwendung value
     * @param \StructType\DatenverwendungType $datenverwendung
     * @return \StructType\AntragsdatenType
     */
    public function setDatenverwendung(\StructType\DatenverwendungType $datenverwendung = null)
    {
        $this->datenverwendung = $datenverwendung;
        return $this;
    }
    /**
     * Get anmeldungKundenportal value
     * @return \StructType\AnmeldungKundenportalType|null
     */
    public function getAnmeldungKundenportal()
    {
        return $this->anmeldungKundenportal;
    }
    /**
     * Set anmeldungKundenportal value
     * @param \StructType\AnmeldungKundenportalType $anmeldungKundenportal
     * @return \StructType\AntragsdatenType
     */
    public function setAnmeldungKundenportal(\StructType\AnmeldungKundenportalType $anmeldungKundenportal = null)
    {
        $this->anmeldungKundenportal = $anmeldungKundenportal;
        return $this;
    }
    /**
     * Get maklervollmacht value
     * @return string|null
     */
    public function getMaklervollmacht()
    {
        return $this->maklervollmacht;
    }
    /**
     * Set maklervollmacht value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maklervollmacht
     * @return \StructType\AntragsdatenType
     */
    public function setMaklervollmacht($maklervollmacht = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($maklervollmacht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($maklervollmacht) ? implode(', ', $maklervollmacht) : var_export($maklervollmacht, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->maklervollmacht = $maklervollmacht;
        return $this;
    }
    /**
     * Get beratungsdokumentation value
     * @return \StructType\BeratungsdokumentationType|null
     */
    public function getBeratungsdokumentation()
    {
        return $this->beratungsdokumentation;
    }
    /**
     * Set beratungsdokumentation value
     * @param \StructType\BeratungsdokumentationType $beratungsdokumentation
     * @return \StructType\AntragsdatenType
     */
    public function setBeratungsdokumentation(\StructType\BeratungsdokumentationType $beratungsdokumentation = null)
    {
        $this->beratungsdokumentation = $beratungsdokumentation;
        return $this;
    }
    /**
     * Get versicherungsnehmer value
     * @return \StructType\PartnerType|null
     */
    public function getVersicherungsnehmer()
    {
        return $this->versicherungsnehmer;
    }
    /**
     * Set versicherungsnehmer value
     * @param \StructType\PartnerType $versicherungsnehmer
     * @return \StructType\AntragsdatenType
     */
    public function setVersicherungsnehmer(\StructType\PartnerType $versicherungsnehmer = null)
    {
        $this->versicherungsnehmer = $versicherungsnehmer;
        return $this;
    }
    /**
     * Get vorsteuerAbzugsberechtigt value
     * @return bool|null
     */
    public function getVorsteuerAbzugsberechtigt()
    {
        return $this->vorsteuerAbzugsberechtigt;
    }
    /**
     * Set vorsteuerAbzugsberechtigt value
     * @param bool $vorsteuerAbzugsberechtigt
     * @return \StructType\AntragsdatenType
     */
    public function setVorsteuerAbzugsberechtigt($vorsteuerAbzugsberechtigt = null)
    {
        // validation for constraint: boolean
        if (!is_null($vorsteuerAbzugsberechtigt) && !is_bool($vorsteuerAbzugsberechtigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vorsteuerAbzugsberechtigt, true), gettype($vorsteuerAbzugsberechtigt)), __LINE__);
        }
        $this->vorsteuerAbzugsberechtigt = $vorsteuerAbzugsberechtigt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AntragsdatenType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
