<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Abstractor StructType
 * Meta information extracted from the WSDL
 * - documentation: Referent
 * @subpackage Structs
 */
class Abstractor extends AbstractStructBase
{
    /**
     * The customerCommunication
     * Meta information extracted from the WSDL
     * - documentation: Telefonnummer, eMail-Adresse
     * @var \StructType\CommunicationDetails
     */
    public $customerCommunication;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Bearbeitername
     * @var string
     */
    public $name;
    /**
     * Constructor method for Abstractor
     * @uses Abstractor::setCustomerCommunication()
     * @uses Abstractor::setName()
     * @param \StructType\CommunicationDetails $customerCommunication
     * @param string $name
     */
    public function __construct(\StructType\CommunicationDetails $customerCommunication = null, $name = null)
    {
        $this
            ->setCustomerCommunication($customerCommunication)
            ->setName($name);
    }
    /**
     * Get customerCommunication value
     * @return \StructType\CommunicationDetails|null
     */
    public function getCustomerCommunication()
    {
        return $this->customerCommunication;
    }
    /**
     * Set customerCommunication value
     * @param \StructType\CommunicationDetails $customerCommunication
     * @return \StructType\Abstractor
     */
    public function setCustomerCommunication(\StructType\CommunicationDetails $customerCommunication = null)
    {
        $this->customerCommunication = $customerCommunication;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Abstractor
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Abstractor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
