<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Transfer ServiceType
 * @subpackage Services
 */
class Transfer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named transferSignedDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransferSignedDocumentRequest $parameter
     * @return \StructType\TransferSignedDocumentResponse|bool
     */
    public function transferSignedDocument(\StructType\TransferSignedDocumentRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->transferSignedDocument($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transferBusinessCase
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransferBusinessCaseRequest $parameter
     * @return \StructType\TransferBusinessCaseResponse|bool
     */
    public function transferBusinessCase(\StructType\TransferBusinessCaseRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->transferBusinessCase($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transferBusinessCases
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransferBusinessCasesRequest $parameter
     * @return \StructType\TransferBusinessCasesResponse|bool
     */
    public function transferBusinessCases(\StructType\TransferBusinessCasesRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->transferBusinessCases($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TransferBusinessCaseResponse|\StructType\TransferBusinessCasesResponse|\StructType\TransferSignedDocumentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
