<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sign ServiceType
 * @subpackage Services
 */
class Sign extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named signDocuments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SignDocumentsRequest $parameter
     * @return \StructType\SignDocumentsResponse|bool
     */
    public function signDocuments(\StructType\SignDocumentsRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->signDocuments($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SignDocumentsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
