<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Map ServiceType
 * @subpackage Services
 */
class Map extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named mapCustomerToPAPartner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MapCustomerToPAPartnerRequest $parameter
     * @return \StructType\MapCustomerToPAPartnerResponse|bool
     */
    public function mapCustomerToPAPartner(\StructType\MapCustomerToPAPartnerRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->mapCustomerToPAPartner($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MapCustomerToPAPartnerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
