<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\GetVersionResponse|bool
     */
    public function getVersion()
    {
        try {
            $this->setResult($this->getSoapClient()->getVersion());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerRequest $parameter
     * @return \StructType\GetCustomerResponse|bool
     */
    public function getCustomer(\StructType\GetCustomerRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getCustomer($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBusinessCases
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBusinessCasesRequest $parameter
     * @return \StructType\GetBusinessCasesResponse|bool
     */
    public function getBusinessCases(\StructType\GetBusinessCasesRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getBusinessCases($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBusinessCase
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBusinessCaseRequest $parameter
     * @return \StructType\GetBusinessCaseResponse|bool
     */
    public function getBusinessCase(\StructType\GetBusinessCaseRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getBusinessCase($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIDFromNumbergenerator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLatestIDFromNumbergeneratorRequest $parameter
     * @return \StructType\GetLatestIDFromNumbergeneratorResponse|bool
     */
    public function getIDFromNumbergenerator(\StructType\GetLatestIDFromNumbergeneratorRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getIDFromNumbergenerator($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBusinessCaseTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBusinessCaseTypesRequest $parameter
     * @return \StructType\GetBusinessCaseTypesResponse|bool
     */
    public function getBusinessCaseTypes(\StructType\GetBusinessCaseTypesRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getBusinessCaseTypes($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getZeusdaten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetZeusDatenRequest $parameter
     * @return \StructType\GetZeusDatenResponse|bool
     */
    public function getZeusdaten(\StructType\GetZeusDatenRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getZeusdaten($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getZeusdatenGreco
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetZeusDatenGrecoRequest $parameter
     * @return \StructType\GetZeusDatenGrecoResponse|bool
     */
    public function getZeusdatenGreco(\StructType\GetZeusDatenGrecoRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getZeusdatenGreco($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVinkulierungsdaten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVinkulierungsdatenRequest $parameter
     * @return \StructType\GetVinkulierungsdatenResponse|bool
     */
    public function getVinkulierungsdaten(\StructType\GetVinkulierungsdatenRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getVinkulierungsdaten($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBusinessCaseHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBusinessCaseHistoryRequest $parameter
     * @return \StructType\GetBusinessCaseHistoryResponse|bool
     */
    public function getBusinessCaseHistory(\StructType\GetBusinessCaseHistoryRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getBusinessCaseHistory($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getChoiceLists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetChoiceListsRequest $parameter
     * @return \StructType\GetChoiceListsResponse|bool
     */
    public function getChoiceLists(\StructType\GetChoiceListsRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getChoiceLists($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSignableDocuments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSignableDocumentsRequest $parameter
     * @return \StructType\GetSignableDocumentsResponse|bool
     */
    public function getSignableDocuments(\StructType\GetSignableDocumentsRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getSignableDocuments($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAreDocumentsSigned
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAreDocumentsSignedRequest $parameter
     * @return \StructType\GetAreDocumentsSignedResponse|bool
     */
    public function getAreDocumentsSigned(\StructType\GetAreDocumentsSignedRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getAreDocumentsSigned($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSignedDocuments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSignedDocumentsRequest $parameter
     * @return \StructType\GetSignedDocumentsResponse|bool
     */
    public function getSignedDocuments(\StructType\GetSignedDocumentsRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getSignedDocuments($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHoraZone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHoraZoneRequest $parameter
     * @return \StructType\GetHoraZoneResponse|bool
     */
    public function getHoraZone(\StructType\GetHoraZoneRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getHoraZone($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBusinessCollectionData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBusinessCollectionDataRequest $parameter
     * @return \StructType\GetBusinessCollectionDataResponse|bool
     */
    public function getBusinessCollectionData(\StructType\GetBusinessCollectionDataRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getBusinessCollectionData($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBusinessCaseReadonlyLink
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBusinessCaseReadonlyLinkRequest $parameter
     * @return \StructType\GetBusinessCaseReadonlyLinkResponse|bool
     */
    public function getBusinessCaseReadonlyLink(\StructType\GetBusinessCaseReadonlyLinkRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getBusinessCaseReadonlyLink($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getArcImage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetArcImageRequest $parameter
     * @return \StructType\GetArcImageResponse|bool
     */
    public function getArcImage(\StructType\GetArcImageRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getArcImage($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getArcImageInfos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetArcImageInfosRequest $parameter
     * @return \StructType\GetArcImageInfosResponse|bool
     */
    public function getArcImageInfos(\StructType\GetArcImageInfosRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getArcImageInfos($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContract
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContractRequest $parameter
     * @return \StructType\GetContractResponse|bool
     */
    public function getContract(\StructType\GetContractRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getContract($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBerechnungswerte
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBerechnungswerteRequest $parameter
     * @return \StructType\GetBerechnungswerteResponse|bool
     */
    public function getBerechnungswerte(\StructType\GetBerechnungswerteRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getBerechnungswerte($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContracts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContractsRequest $parameter
     * @return \StructType\GetContractsResponse|bool
     */
    public function getContracts(\StructType\GetContractsRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getContracts($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserDataRequest $parameter
     * @return \StructType\GetUserDataResponse|bool
     */
    public function getUserData(\StructType\GetUserDataRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getUserData($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetArcImageInfosResponse|\StructType\GetArcImageResponse|\StructType\GetAreDocumentsSignedResponse|\StructType\GetBerechnungswerteResponse|\StructType\GetBusinessCaseHistoryResponse|\StructType\GetBusinessCaseReadonlyLinkResponse|\StructType\GetBusinessCaseResponse|\StructType\GetBusinessCasesResponse|\StructType\GetBusinessCaseTypesResponse|\StructType\GetBusinessCollectionDataResponse|\StructType\GetChoiceListsResponse|\StructType\GetContractResponse|\StructType\GetContractsResponse|\StructType\GetCustomerResponse|\StructType\GetHoraZoneResponse|\StructType\GetLatestIDFromNumbergeneratorResponse|\StructType\GetSignableDocumentsResponse|\StructType\GetSignedDocumentsResponse|\StructType\GetUserDataResponse|\StructType\GetVersionResponse|\StructType\GetVinkulierungsdatenResponse|\StructType\GetZeusDatenGrecoResponse|\StructType\GetZeusDatenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
