<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createPartnerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePartnerGroupRequest $parameter
     * @return \StructType\CreatePartnerGroupResponse|bool
     */
    public function createPartnerGroup(\StructType\CreatePartnerGroupRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->createPartnerGroup($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createOrUpdatePartnerContact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrUpdatePartnerContactRequest $parameter
     * @return \StructType\CreateOrUpdatePartnerContactResponse|bool
     */
    public function createOrUpdatePartnerContact(\StructType\CreateOrUpdatePartnerContactRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->createOrUpdatePartnerContact($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateOrUpdatePartnerContactResponse|\StructType\CreatePartnerGroupResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
