<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addCustomerToBusinessCase
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCustomerToBusinessCaseRequest $parameter
     * @return \StructType\AddCustomerToBusinessCaseResponse|bool
     */
    public function addCustomerToBusinessCase(\StructType\AddCustomerToBusinessCaseRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->addCustomerToBusinessCase($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addStateHistoryEntry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddStateHistoryEntryRequest $parameter
     * @return \StructType\AddStateHistoryEntryResponse|bool
     */
    public function addStateHistoryEntry(\StructType\AddStateHistoryEntryRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->addStateHistoryEntry($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddCustomerToBusinessCaseResponse|\StructType\AddStateHistoryEntryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
