<?php

namespace EnumType;

/**
 * This class stands for ZeusSearchSource EnumType
 * Meta information extracted from the WSDL
 * - documentation: Typ des 1..Database 2..network share
 * @subpackage Enumerations
 */
class ZeusSearchSource
{
    /**
     * Constant for value 'database'
     * Meta information extracted from the WSDL
     * - id: database
     * @return string 'database'
     */
    const VALUE_DATABASE = 'database';
    /**
     * Constant for value 'networkshare'
     * Meta information extracted from the WSDL
     * - id: networkshare
     * @return string 'networkshare'
     */
    const VALUE_NETWORKSHARE = 'networkshare';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DATABASE
     * @uses self::VALUE_NETWORKSHARE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DATABASE,
            self::VALUE_NETWORKSHARE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
