<?php

namespace EnumType;

/**
 * This class stands for zahlungsartType EnumType
 * @subpackage Enumerations
 */
class ZahlungsartType
{
    /**
     * Constant for value 'Kontoeinzug'
     * @return string 'Kontoeinzug'
     */
    const VALUE_KONTOEINZUG = 'Kontoeinzug';
    /**
     * Constant for value 'Zahlungsanweisung'
     * @return string 'Zahlungsanweisung'
     */
    const VALUE_ZAHLUNGSANWEISUNG = 'Zahlungsanweisung';
    /**
     * Constant for value 'Kundenkonto'
     * @return string 'Kundenkonto'
     */
    const VALUE_KUNDENKONTO = 'Kundenkonto';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KONTOEINZUG
     * @uses self::VALUE_ZAHLUNGSANWEISUNG
     * @uses self::VALUE_KUNDENKONTO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KONTOEINZUG,
            self::VALUE_ZAHLUNGSANWEISUNG,
            self::VALUE_KUNDENKONTO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
